package fr.ifremer.tutti.ui.swing;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.StatusMessagePanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n._;

public class MainUI extends JFrame implements TuttiUI<TuttiUIContext, MainUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MENU_ACTION_FILL_CATCHES_ENABLED = "menuActionFillCatches.enabled";
    public static final String BINDING_MENU_ACTION_MANAGE_PROTOCOL_ENABLED = "menuActionManageProtocol.enabled";
    public static final String BINDING_MENU_ACTION_SELECT_CAMPAIGN_ENABLED = "menuActionSelectCampaign.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVXTW8jNRh2sk0/dwVtN6XbFkhhd+lepr2Xjw1pQqckTdVJpWp7KM6Mk7jMF7aHTrVaxE/gJ8CdCxI3TogDZw5cEH8BIQ5cAXsmmYwzM0kKolKj1n4e+3lf28/75uvfQIESsH0FfV8hns2whZSj8vl5s32FdHaAqE6wyxwCwp9cHuQvwJIRjVMG3ryoC/pun75bcSzXsZEdY+/XwSJlNyaiPYQYA6/KDJ3SXS2a3vddjwxWjUSlrfrlH7/nvzA+/yoPgO9ydUUeSmkSaxjJTB3kscHACt/pU7hrQrvLZRBsd7nee2KsYkJKj6GFPgGfgbk6mHUh4Ysx8Mb0IQdrBHzfZWDBgtiuEb4kA6UOUXCHIAsRhXmMYcXDCr3m+ysNjjpTXTcgzjJQsBwDmQzsZFNa4t8zteLYDPlsSJ3rQdswEWHgrUn7HYbIIXfGQrbHwH2RC78PPWrwsfdhDDUvUDVs8pCWE0iBWYmgxQGUy+zgrkcgw1wwKCZ4KkOWIBUj7t2HRxriBwB5dvcYWJMo0cwIZ7Bf1cdMjG3I80tivqwLEcHQK7Lc9eF0A9qwi06IwxzdMaOlSmlYDZn88VSg5ULctVOwxSGWizMrkOk9RFOA9wVQu7H1HnFsTGGW0AcpOJXfSTIMemcsuOpngDdSwGXTRF3ipKCDq3CITDdF493BnIYZirh70fy9wXy57XgsBTDTdowbBrYd0lWuuAV9zBw3PH9fOTpvYWYi4wTaKDidhYg2SxlkHjeqR5I1hBdHC+YaiFJxujEyAZsSnHuUMvSooYnkLkCBeHyY34CLpK2d8qnQ0NZHDE0sGMz+tbb683e/flsbuNgy37uYCo2ZMHcXlzguf9ZYbP1SaGEew+ZuA7r7F2CBBpcwcOitFGFaf5qL4/sF71YRdOUQ0h5fojD3y/c/rH300x2Qr4FF04FGDQq8ChZYj/AsOKbhu+89DRTdvZ7nny/z3zz3KiZOgj/Q0GOg65pYD+6NYge+VzRQB3omq5gORU0eQ98Etp4fBc6oHDQvj5utQ/X4g8vm8WWl3tSqL3yewq2UFEZxtBd+/HNV++bpII05HtaDTPgwlYVnYBbbJrZRUA76Tp9q/0suRZ7hDB09zeNB3OTdvkuWg89qIl13+K0Wds1PMMyWeANKJ/DSectGFn9zOgO5Grcq5jhmC7utAL46AlcYdv3AbD8MYhd/NUDMmycpmYmUbPTPLbAnRZeNOi6qwsBiiFJ1MTcbYkelvpa9Xpbq9DIxfTKXpS0R9/4RqTPhmCy0mGBl6ZPKyvSyVmKHFu5C5YyWRyWtJRlZmuKlbIrDnkM2bHPDZKD+PGgulC5imk4QsneelLbfKQX9RDigVA/U1uXJabPVrDTrpcePSyED00E9FFUMGTtPXkSxbkrJtKTqKQd9Mhr062OoWdFnVupbpWJvciq0ar1aaV1WTs9U7koZ4VKpAZDD1caHK1OnCFduNm4V7rMpT76maqEZn1RPyy21eRy/AhXiYYr6bWfyHqxL0XWG3U7CS+SsbGXxxnpGoqea/nFuxp4aHem4pjvBVGqW3NTO7lanV+hAk6JIfylbRNgJykGoo0E8nMTPiiS79/yfwgl7VTmc6i3CCfm3CSdk/JdwtrPl9LvpCZXg0cQFsgIa08H/u/akx3v0CdlfHYGPbU9Ezz99eyLXdsq/SyRep1zqQ8i4Ui8QY0v94FvL9CpXpA2g+EaTOGBJZqGPSa3/8WWyhMpfnyYpzfF2rYdwtye0vh32vyXIGMFtj6F3ExvkxOfiFKsWrrHBemL67+xF/gHn4So9dxIAAA==";
    private static final Log log = LogFactory.getLog(MainUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JXTitledPanel body;
    protected MainUIHandler handler;
    protected MainUI mainFrame = this;
    protected JMenuBar menu;
    protected JMenuItem menuActionFillCatches;
    protected JMenuItem menuActionManageProtocol;
    protected JMenuItem menuActionSelectCampaign;
    protected JMenu menuActions;
    protected JMenu menuFile;
    protected JMenuItem menuFileConfiguration;
    protected JMenuItem menuFileExit;
    protected JMenu menuHelp;
    protected JMenuItem menuHelpAbout;
    protected JMenuItem menuHelpSite;
    protected JMenuItem menuSynchronisationAllegro;
    protected JMenuItem menuSynchronisationExport;
    protected JMenuItem menuSynchronisationImport;
    protected JMenu menuSynchronisations;
    protected TuttiUIContext model;
    protected StatusMessagePanel status;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSeparator $JSeparator0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
        protected void $afterCompleteSetup() {
            getHandler().afterInitUI();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MainUI(TuttiUIContext context) {
        setContextValue(context);
                MainUIHandler handler = new MainUIHandler(context, this);
                setContextValue(handler);
                handler.beforeInitUI();
            $initialize();
    }

    public MainUI(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI() {
        $initialize();
    }

    public MainUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI(String param0) {
        super(param0);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__menuActionFillCatches(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showFillCatches();
    }

    public void doActionPerformed__on__menuActionManageProtocol(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showManageProtocol();
    }

    public void doActionPerformed__on__menuActionSelectCampaign(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showSelectCampaign();
    }

    public void doActionPerformed__on__menuFileConfiguration(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showConfig();
    }

    public void doActionPerformed__on__menuFileExit(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().closeTutti();
    }

    public void doActionPerformed__on__menuHelpAbout(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showAbout();
    }

    public void doActionPerformed__on__menuHelpSite(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().gotoSite();
    }

    public void doActionPerformed__on__menuSynchronisationAllegro(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showAllegroScreen();
    }

    public void doActionPerformed__on__menuSynchronisationExport(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showExportScreen();
    }

    public void doActionPerformed__on__menuSynchronisationImport(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportScreen();
    }

    public void doWindowClosing__on__mainFrame(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().closeTutti();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JXTitledPanel getBody() {
        return body;
    }

    public MainUIHandler getHandler() {
        return handler;
    }

    public JMenuBar getMenu() {
        return menu;
    }

    public JMenuItem getMenuActionFillCatches() {
        return menuActionFillCatches;
    }

    public JMenuItem getMenuActionManageProtocol() {
        return menuActionManageProtocol;
    }

    public JMenuItem getMenuActionSelectCampaign() {
        return menuActionSelectCampaign;
    }

    public JMenu getMenuActions() {
        return menuActions;
    }

    public JMenu getMenuFile() {
        return menuFile;
    }

    public JMenuItem getMenuFileConfiguration() {
        return menuFileConfiguration;
    }

    public JMenuItem getMenuFileExit() {
        return menuFileExit;
    }

    public JMenu getMenuHelp() {
        return menuHelp;
    }

    public JMenuItem getMenuHelpAbout() {
        return menuHelpAbout;
    }

    public JMenuItem getMenuHelpSite() {
        return menuHelpSite;
    }

    public JMenuItem getMenuSynchronisationAllegro() {
        return menuSynchronisationAllegro;
    }

    public JMenuItem getMenuSynchronisationExport() {
        return menuSynchronisationExport;
    }

    public JMenuItem getMenuSynchronisationImport() {
        return menuSynchronisationImport;
    }

    public JMenu getMenuSynchronisations() {
        return menuSynchronisations;
    }

    public TuttiUIContext getModel() {
        return model;
    }

    public StatusMessagePanel getStatus() {
        return status;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToMainFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add(SwingUtil.boxComponentWithJxLayer(body), BorderLayout.CENTER);
        add(status, BorderLayout.SOUTH);
        mainFrame.setJMenuBar(menu);
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add(menuFile);
        menu.add(menuActions);
        menu.add(menuSynchronisations);
        menu.add(menuHelp);
    }

    protected void addChildrenToMenuActions() {
        if (!allComponentsCreated) {
            return;
        }
        menuActions.add(menuActionManageProtocol);
        menuActions.add(menuActionSelectCampaign);
        menuActions.add(menuActionFillCatches);
    }

    protected void addChildrenToMenuFile() {
        if (!allComponentsCreated) {
            return;
        }
        menuFile.add(menuFileConfiguration);
        menuFile.add($JSeparator0);
        menuFile.add(menuFileExit);
    }

    protected void addChildrenToMenuHelp() {
        if (!allComponentsCreated) {
            return;
        }
        menuHelp.add(menuHelpSite);
        menuHelp.add(menuHelpAbout);
    }

    protected void addChildrenToMenuSynchronisations() {
        if (!allComponentsCreated) {
            return;
        }
        menuSynchronisations.add(menuSynchronisationImport);
        menuSynchronisations.add(menuSynchronisationExport);
        menuSynchronisations.add(menuSynchronisationAllegro);
    }

    protected void createBody() {
        $objectMap.put("body", body = new JXTitledPanel());
        
        body.setName("body");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(MainUIHandler.class));
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new JMenuBar());
        
        menu.setName("menu");
    }

    protected void createMenuActionFillCatches() {
        $objectMap.put("menuActionFillCatches", menuActionFillCatches = new JMenuItem());
        
        menuActionFillCatches.setName("menuActionFillCatches");
        menuActionFillCatches.setText(_("tutti.action.fillCatches"));
        menuActionFillCatches.setMnemonic(67);
        menuActionFillCatches.setToolTipText(_("tutti.action.fillCatches.tip"));
        menuActionFillCatches.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuActionFillCatches"));
    }

    protected void createMenuActionManageProtocol() {
        $objectMap.put("menuActionManageProtocol", menuActionManageProtocol = new JMenuItem());
        
        menuActionManageProtocol.setName("menuActionManageProtocol");
        menuActionManageProtocol.setText(_("tutti.action.manageProtocol"));
        menuActionManageProtocol.setMnemonic(80);
        menuActionManageProtocol.setToolTipText(_("tutti.action.manageProtocol.tip"));
        menuActionManageProtocol.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuActionManageProtocol"));
    }

    protected void createMenuActionSelectCampaign() {
        $objectMap.put("menuActionSelectCampaign", menuActionSelectCampaign = new JMenuItem());
        
        menuActionSelectCampaign.setName("menuActionSelectCampaign");
        menuActionSelectCampaign.setText(_("tutti.action.selectCampaign"));
        menuActionSelectCampaign.setMnemonic(83);
        menuActionSelectCampaign.setToolTipText(_("tutti.action.selectCampaign.tip"));
        menuActionSelectCampaign.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuActionSelectCampaign"));
    }

    protected void createMenuActions() {
        $objectMap.put("menuActions", menuActions = new JMenu());
        
        menuActions.setName("menuActions");
        menuActions.setText(_("tutti.menu.actions"));
        menuActions.setMnemonic(65);
        menuActions.setToolTipText(_("tutti.menu.actions.tip"));
    }

    protected void createMenuFile() {
        $objectMap.put("menuFile", menuFile = new JMenu());
        
        menuFile.setName("menuFile");
        menuFile.setText(_("tutti.menu.file"));
        menuFile.setMnemonic(70);
        menuFile.setToolTipText(_("tutti.menu.file.tip"));
    }

    protected void createMenuFileConfiguration() {
        $objectMap.put("menuFileConfiguration", menuFileConfiguration = new JMenuItem());
        
        menuFileConfiguration.setName("menuFileConfiguration");
        menuFileConfiguration.setText(_("tutti.action.configuration"));
        menuFileConfiguration.setMnemonic(67);
        menuFileConfiguration.setToolTipText(_("tutti.action.configuration.tip"));
        menuFileConfiguration.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileConfiguration"));
    }

    protected void createMenuFileExit() {
        $objectMap.put("menuFileExit", menuFileExit = new JMenuItem());
        
        menuFileExit.setName("menuFileExit");
        menuFileExit.setText(_("tutti.action.exit"));
        menuFileExit.setToolTipText(_("tutti.action.exit.tip"));
        menuFileExit.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileExit"));
    }

    protected void createMenuHelp() {
        $objectMap.put("menuHelp", menuHelp = new JMenu());
        
        menuHelp.setName("menuHelp");
        menuHelp.setText(_("tutti.menu.help"));
        menuHelp.setMnemonic(69);
        menuHelp.setToolTipText(_("tutti.menu.help.tip"));
    }

    protected void createMenuHelpAbout() {
        $objectMap.put("menuHelpAbout", menuHelpAbout = new JMenuItem());
        
        menuHelpAbout.setName("menuHelpAbout");
        menuHelpAbout.setText(_("tutti.action.about"));
        menuHelpAbout.setMnemonic(65);
        menuHelpAbout.setToolTipText(_("tutti.action.about.tip"));
        menuHelpAbout.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpAbout"));
    }

    protected void createMenuHelpSite() {
        $objectMap.put("menuHelpSite", menuHelpSite = new JMenuItem());
        
        menuHelpSite.setName("menuHelpSite");
        menuHelpSite.setText(_("tutti.action.site"));
        menuHelpSite.setMnemonic(83);
        menuHelpSite.setToolTipText(_("tutti.action.site.tip"));
        menuHelpSite.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpSite"));
    }

    protected void createMenuSynchronisationAllegro() {
        $objectMap.put("menuSynchronisationAllegro", menuSynchronisationAllegro = new JMenuItem());
        
        menuSynchronisationAllegro.setName("menuSynchronisationAllegro");
        menuSynchronisationAllegro.setEnabled(false);
        menuSynchronisationAllegro.setText(_("tutti.menu.synchronisationAllegro"));
        menuSynchronisationAllegro.setMnemonic(65);
        menuSynchronisationAllegro.setToolTipText(_("tutti.menu.synchronisationAllegro.tip"));
        menuSynchronisationAllegro.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuSynchronisationAllegro"));
    }

    protected void createMenuSynchronisationExport() {
        $objectMap.put("menuSynchronisationExport", menuSynchronisationExport = new JMenuItem());
        
        menuSynchronisationExport.setName("menuSynchronisationExport");
        menuSynchronisationExport.setEnabled(false);
        menuSynchronisationExport.setText(_("tutti.menu.synchronisationExport"));
        menuSynchronisationExport.setMnemonic(69);
        menuSynchronisationExport.setToolTipText(_("tutti.menu.synchronisationExport.tip"));
        menuSynchronisationExport.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuSynchronisationExport"));
    }

    protected void createMenuSynchronisationImport() {
        $objectMap.put("menuSynchronisationImport", menuSynchronisationImport = new JMenuItem());
        
        menuSynchronisationImport.setName("menuSynchronisationImport");
        menuSynchronisationImport.setEnabled(false);
        menuSynchronisationImport.setText(_("tutti.menu.synchronisationImport"));
        menuSynchronisationImport.setMnemonic(73);
        menuSynchronisationImport.setToolTipText(_("tutti.menu.synchronisationImport.tip"));
        menuSynchronisationImport.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuSynchronisationImport"));
    }

    protected void createMenuSynchronisations() {
        $objectMap.put("menuSynchronisations", menuSynchronisations = new JMenu());
        
        menuSynchronisations.setName("menuSynchronisations");
        menuSynchronisations.setText(_("tutti.menu.synchronisations"));
        menuSynchronisations.setMnemonic(83);
        menuSynchronisations.setToolTipText(_("tutti.menu.synchronisations.tip"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(TuttiUIContext.class));
    }

    protected void createStatus() {
        $objectMap.put("status", status = new StatusMessagePanel());
        
        status.setName("status");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToMainFrame();
        addChildrenToMenu();
        addChildrenToMenuFile();
        addChildrenToMenuActions();
        addChildrenToMenuSynchronisations();
        addChildrenToMenuHelp();
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        menuFileConfiguration.setIcon(SwingUtil.createActionIcon("config"));
        menuFileExit.setIcon(SwingUtil.createActionIcon("exit"));
        menuHelpSite.setIcon(SwingUtil.createActionIcon("site"));
        menuHelpAbout.setIcon(SwingUtil.createActionIcon("about"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("mainFrame", mainFrame);
        createModel();
        createHandler();
        createMenu();
        createMenuFile();
        createMenuFileConfiguration();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createMenuFileExit();
        createMenuActions();
        createMenuActionManageProtocol();
        createMenuActionSelectCampaign();
        createMenuActionFillCatches();
        createMenuSynchronisations();
        createMenuSynchronisationImport();
        createMenuSynchronisationExport();
        createMenuSynchronisationAllegro();
        createMenuHelp();
        createMenuHelpSite();
        createMenuHelpAbout();
        createBody();
        createStatus();
        // inline creation of mainFrame
        setName("mainFrame");
        SwingUtil.setComponentHeight(mainFrame,600);
        SwingUtil.setComponentWidth(mainFrame,800);
        setTitle(_("tutti.application.name"));
        mainFrame.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__mainFrame"));
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_MANAGE_PROTOCOL_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("protocolFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionManageProtocol.setEnabled(model.getScreen() != TuttiScreen.EDIT_PROTOCOL && model.isProtocolFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("protocolFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_SELECT_CAMPAIGN_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionSelectCampaign.setEnabled(model.getScreen() != TuttiScreen.SELECT_CRUISE);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_FILL_CATCHES_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseContextFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionFillCatches.setEnabled(model.getScreen() != TuttiScreen.EDIT_FISHING_OPERATION && model.isCruiseContextFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseContextFilled", this);
                }
            }
        });
    }

}