/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.catches;

import fr.ifremer.tutti.persistence.entities.CampaignBean;
import fr.ifremer.tutti.persistence.entities.TraitBean;
import fr.ifremer.tutti.persistence.entities.TuttiBeans;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.catches.CatchesUI;
import fr.ifremer.tutti.ui.swing.content.catches.CatchesUIModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CatchesUIHandler
extends AbstractTuttiUIHandler<CatchesUIModel> {
    private static final Log log = LogFactory.getLog(CatchesUIHandler.class);
    private final CatchesUI ui;
    private final PersistenceService persistenceService;

    public CatchesUIHandler(TuttiUIContext context, CatchesUI ui) {
        super(context);
        this.ui = ui;
        this.persistenceService = context.getService(PersistenceService.class);
    }

    @Override
    public void beforeInitUI() {
        CatchesUIModel model = new CatchesUIModel();
        String campaignId = this.context.getCampaignId();
        CampaignBean campaign = this.persistenceService.getCampaign(campaignId);
        model.setCampaign(campaign);
        List traits = this.persistenceService.getAllTraits(campaignId);
        model.setTrait(traits);
        if (log.isInfoEnabled()) {
            log.info((Object)("Loaded " + traits.size() + " trait(s)."));
        }
        this.ui.setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        CatchesUIModel model = this.ui.getModel();
        this.initUI(this.ui);
        List<TraitBean> traits = model.getTrait();
        this.initBeanComboBox(this.ui.getTraitComboBox(), traits, model.getSelectedTrait());
        model.addPropertyChangeListener("selectedTrait", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CatchesUIHandler.this.selectTrait((TraitBean)evt.getNewValue());
            }
        });
        model.addPropertyChangeListener("trait", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CatchesUIHandler.this.ui.getTraitComboBox().setData(null);
                CatchesUIHandler.this.ui.getTraitComboBox().setData((List)evt.getNewValue());
            }
        });
        if (!traits.isEmpty()) {
            model.setSelectedTrait(traits.get(0));
        }
    }

    @Override
    public void onCloseUI() {
        this.ui.getTabPane().setSelectedIndex(0);
        this.ui.getTraitTabContent().getTraitTabPane().setSelectedIndex(0);
    }

    @Override
    protected CatchesUIModel getModel() {
        return this.ui.getModel();
    }

    public void createNewTrait() {
        this.ui.getModel().setSelectedTrait(null);
        TraitBean newTrait = new TraitBean();
        newTrait.setCampaign(this.ui.getModel().getCampaign());
        newTrait.setDate(new Date());
        this.selectTrait(newTrait);
    }

    public void selectTrait(TraitBean selectedTrait) {
        if (log.isInfoEnabled()) {
            log.info((Object)("New selected trait: " + selectedTrait));
        }
        this.ui.getTabPane().setSelectedIndex(0);
        this.ui.getTraitTabContent().getTraitTabPane().setSelectedIndex(0);
        this.ui.getTraitTabContent().selectTrait(selectedTrait);
        this.ui.getFishesTabContent().selectTrait(selectedTrait);
        this.ui.getBenthosTabContent().selectTrait(selectedTrait);
        this.ui.getTabPane().repaint();
    }

    public void saveTrait(TraitBean toSave) {
        boolean create = toSave.getId() == null;
        TraitBean savedTrait = create ? this.persistenceService.createTrait(toSave) : this.persistenceService.saveTrait(toSave);
        CatchesUIModel model = this.ui.getModel();
        List<TraitBean> data = model.getTrait();
        TraitBean existingTrait = (TraitBean)TuttiBeans.findById(data, (String)savedTrait.getId());
        if (existingTrait != null) {
            data.remove(existingTrait);
        }
        data.add(savedTrait);
        model.setTrait(data);
        model.setSelectedTrait(savedTrait);
    }
}

