package fr.ifremer.tutti.ui.swing.content.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id: FishesTabUIHandler.java 20 2012-11-26 10:27:11Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/catches/FishesTabUIHandler.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.CatchBean;
import fr.ifremer.tutti.persistence.entities.SpeciesBean;
import fr.ifremer.tutti.persistence.entities.TraitBean;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

import static org.nuiton.i18n.I18n._;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class FishesTabUIHandler extends AbstractTuttiUIHandler<FishesTabUIModel> {

    /** Logger. */
    private static final Log log = LogFactory.getLog(FishesTabUIHandler.class);

    private final FishesTabUI ui;

    private final CatchesUI parentUi;

    private final PersistenceService persistenceService;

    public FishesTabUIHandler(CatchesUI parentUi, FishesTabUI ui) {
        super(parentUi.getHandler().getContext());
        this.ui = ui;
        this.parentUi = parentUi;
        this.persistenceService = context.getService(PersistenceService.class);
    }

    @Override
    public void beforeInitUI() {

        FishesTabUIModel model = new FishesTabUIModel();
        ui.setContextValue(model);

        JTable tb = new JTable();

        TableCellEditor defaultEditor = tb.getDefaultEditor(String.class);
        TableCellRenderer defaultRenderer = tb.getDefaultRenderer(Object.class);

        DefaultTableCellRenderer dRender = new DefaultTableCellRenderer();
        // prepare the table column model
        TableColumnModel columnModel = new DefaultTableColumnModel();

        TableColumn col;

        // species (by code) column

        col = new TableColumn(0);

        JComboBox speciesEditor = new JComboBox();
        List<SpeciesBean> allSpecies = persistenceService.getAllSpecies();
        SwingUtil.fillComboBox(speciesEditor, allSpecies, null);
//        col.setCellEditor();
        col.setCellRenderer(newTableCellRender(SpeciesBean.class));
        col.setHeaderValue(_("tutti.table.fishes.header.speciesByCode"));
//        col.setHeaderRenderer(SwingUtil.newStringTableCellRenderer(dRender,50, true));
        col.setIdentifier("speciesByCode");
        columnModel.addColumn(col);

        // Vrac / Hors vrac
        col = new TableColumn(1);
        col.setCellEditor(defaultEditor);
        col.setCellRenderer(defaultRenderer);
        col.setHeaderValue(_("tutti.table.fishes.header.vracHorsVrac"));
//        col.setHeaderRenderer(SwingUtil.newStringTableCellRenderer(dRender,50, true));
        col.setIdentifier("vracHorsVrac");
        columnModel.addColumn(col);

        // Catégorie de poids
        col = new TableColumn(2);
        col.setCellEditor(defaultEditor);
        col.setCellRenderer(defaultRenderer);
        col.setHeaderValue(_("tutti.table.fishes.header.weightCategory"));
//        col.setHeaderRenderer(SwingUtil.newStringTableCellRenderer(dRender,50, true));
        col.setIdentifier("weightCategory");
        columnModel.addColumn(col);

        // Sex
        col = new TableColumn(3);
        col.setCellEditor(defaultEditor);
        col.setCellRenderer(defaultRenderer);
        col.setHeaderValue(_("tutti.table.fishes.header.sex"));
//        col.setHeaderRenderer(SwingUtil.newStringTableCellRenderer(dRender,50, true));
        col.setIdentifier("sex");
        columnModel.addColumn(col);

        // Maturity
        col = new TableColumn(4);
        col.setCellEditor(defaultEditor);
        col.setCellRenderer(defaultRenderer);
        col.setHeaderValue(_("tutti.table.fishes.header.maturity"));
//        col.setHeaderRenderer(SwingUtil.newStringTableCellRenderer(dRender,50, true));
        col.setIdentifier("maturity");
        columnModel.addColumn(col);

        // Age
        col = new TableColumn(5);
        col.setCellEditor(defaultEditor);
        col.setCellRenderer(defaultRenderer);
        col.setHeaderValue(_("tutti.table.fishes.header.age"));
//        col.setHeaderRenderer(SwingUtil.newStringTableCellRenderer(dRender,50, true));
        col.setIdentifier("age");
        columnModel.addColumn(col);

        // Type de mensuration
        col = new TableColumn(6);
        col.setCellEditor(defaultEditor);
        col.setCellRenderer(defaultRenderer);
        col.setHeaderValue(_("tutti.table.fishes.header.mensurationType"));
//        col.setHeaderRenderer(SwingUtil.newStringTableCellRenderer(dRender,50, true));
        col.setIdentifier("mensurationType");
        columnModel.addColumn(col);

        // Poids observé
        col = new TableColumn(7);
        col.setCellEditor(defaultEditor);
        col.setCellRenderer(defaultRenderer);
        col.setHeaderValue(_("tutti.table.fishes.header.weight"));
//        col.setHeaderRenderer(SwingUtil.newStringTableCellRenderer(dRender,50, true));
        col.setIdentifier("weight");
        columnModel.addColumn(col);

        // Poids calculé
        col = new TableColumn(8);
        col.setCellEditor(defaultEditor);
        col.setCellRenderer(defaultRenderer);
        col.setHeaderValue(_("tutti.table.fishes.header.computedWeight"));
//        col.setHeaderRenderer(SwingUtil.newStringTableCellRenderer(dRender,50, true));
        col.setIdentifier("computedWeight");
        columnModel.addColumn(col);

        // Nombre calculé
        col = new TableColumn(9);
        col.setCellEditor(defaultEditor);
        col.setCellRenderer(defaultRenderer);
        col.setHeaderValue(_("tutti.table.fishes.header.computedNumber"));
//        col.setHeaderRenderer(SwingUtil.newStringTableCellRenderer(dRender,50, true));
        col.setIdentifier("computedNumber");
        columnModel.addColumn(col);

        // Poids d'échantillon
        col = new TableColumn(10);
        col.setCellEditor(defaultEditor);
        col.setCellRenderer(defaultRenderer);
        col.setHeaderValue(_("tutti.table.fishes.header.sampleWeight"));
//        col.setHeaderRenderer(SwingUtil.newStringTableCellRenderer(dRender,50, true));
        col.setIdentifier("sampleWeight");
        columnModel.addColumn(col);

        // Fraction d'élévation
        col = new TableColumn(11);
        col.setCellEditor(defaultEditor);
        col.setCellRenderer(defaultRenderer);
        col.setHeaderValue(_("tutti.table.fishes.header.elevationRate"));
//        col.setHeaderRenderer(SwingUtil.newStringTableCellRenderer(dRender,50, true));
        col.setIdentifier("elevationRate");
        columnModel.addColumn(col);

        ui.setContextValue(columnModel);

        final FishesTableModel tableModel = new FishesTableModel(columnModel);
        ui.setContextValue(tableModel);

        model.addPropertyChangeListener(FishesTabUIModel.PROPERTY_CATCHES, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                tableModel.setData((List<CatchBean>) evt.getNewValue());
            }
        });

    }

    @Override
    public void afterInitUI() {
        FishesTabUIModel model = ui.getModel();

        initUI(ui);
    }

    @Override
    public void onCloseUI() {
    }

    @Override
    protected FishesTabUIModel getModel() {
        return ui.getModel();
    }

    public void selectTrait(TraitBean bean) {

        boolean empty = bean == null;

        FishesTabUIModel model = ui.getModel();

        List<CatchBean> catches;

        if (empty) {
            catches = null;
            bean = new TraitBean();
        } else {
            catches = persistenceService.getAllCatches(bean.getId());
        }

        model.fromBean(bean);
        model.setCatches(catches);

    }

    public void cancel() {

        if (log.isInfoEnabled()) {
            log.info("Cancel edition");
        }
    }

    public void save() {
        if (log.isInfoEnabled()) {
            log.info("Will save");
        }
    }
}
