package fr.ifremer.tutti.ui.swing.content.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id: CatchesUIModel.java 15 2012-11-24 13:10:24Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/catches/CatchesUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.CampaignBean;
import fr.ifremer.tutti.persistence.entities.TraitBean;
import org.jdesktop.beans.AbstractSerializableBean;

import java.util.List;

/**
 * Model fo UI {@link CatchesUI}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class CatchesUIModel extends AbstractSerializableBean {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_TRAIT = "trait";

    public static final String PROPERTY_SELECTED_TRAIT = "selectedTrait";

    public static final String PROPERTY_CAMPAIGN = "campaign";

    protected List<TraitBean> trait;

    protected TraitBean selectedTrait;

    protected CampaignBean campaign;

    public List<TraitBean> getTrait() {
        return trait;
    }

    public void setTrait(List<TraitBean> trait) {
        this.trait = trait;
        firePropertyChange(PROPERTY_TRAIT, null, trait);
    }

    public TraitBean getSelectedTrait() {
        return selectedTrait;
    }

    public void setSelectedTrait(TraitBean selectedTrait) {
        Object oldValue = getSelectedTrait();
        this.selectedTrait = selectedTrait;
        firePropertyChange(PROPERTY_SELECTED_TRAIT, oldValue, selectedTrait);
    }

    public CampaignBean getCampaign() {
        return campaign;
    }

    public void setCampaign(CampaignBean campaign) {
        Object oldValue = getCampaign();
        this.campaign = campaign;
        firePropertyChange(PROPERTY_CAMPAIGN, oldValue, campaign);
    }
}
