package fr.ifremer.tutti.ui.swing.content.campaign;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditSurveyUIHandler.java 15 2012-11-24 13:10:24Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/campaign/EditSurveyUIHandler.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.SurveyBean;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableRenderer;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Handler of UI {@link EditSurveyUI}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class EditSurveyUIHandler extends AbstractTuttiUIHandler<EditSurveyUIModel> {

    /** Logger. */
    private static final Log log = LogFactory.getLog(EditSurveyUIHandler.class);

    private final EditSurveyUI ui;

    private final PersistenceService persistenceService;

    public EditSurveyUIHandler(TuttiUIContext context, EditSurveyUI ui) {
        super(context);
        this.ui = ui;
        persistenceService = context.getService(PersistenceService.class);
    }

    @Override
    public void beforeInitUI() {

        EditSurveyUIModel model = new EditSurveyUIModel();

        String surveyId = context.getSurveyId();
        if (surveyId == null) {

            if (log.isInfoEnabled()) {
                log.info("Edit new survey");
            }
        } else {

            if (log.isInfoEnabled()) {
                log.info("Edit existing survey " + surveyId);
            }
            // load existing survey
            SurveyBean survey = persistenceService.getSurvey(surveyId);

            model.fromBean(survey);
        }

        listModelIsModify(model);

        ui.setContextValue(model);
    }

    @Override
    public void afterInitUI() {

        EditSurveyUIModel model = ui.getModel();
        initBeanComboBox(ui.getZoneComboBox(),
                         persistenceService.getAllZones(),
                         model.getZone());

        SwingValidatorUtil.installUI(ui.getErrorTable(),
                                     new SwingValidatorMessageTableRenderer());

        listenValidatorValid(ui.getValidator(), model);

        // if new survey can already cancel his creation
        model.setModify(model.isCreate());
    }

    @Override
    public void onCloseUI() {
        ui.getValidator().setBean(null);
    }

    @Override
    protected EditSurveyUIModel getModel() {
        return ui.getModel();
    }

    public void cancel() {
        context.setScreen(TuttiScreen.SELECT_CAMPAIGN);
    }

    public void save() {

        EditSurveyUIModel model = ui.getModel();

        SurveyBean bean = model.toBean();

        SurveyBean saved;
        if (model.isCreate()) {

            saved = persistenceService.createSurvey(bean);
        } else {
            saved = persistenceService.saveSurvey(bean);
        }

        context.setSurveyId(saved.getId());
        context.setScreen(TuttiScreen.SELECT_CAMPAIGN);
    }
}
