package fr.ifremer.tutti.ui.swing.content.campaign;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditCampaignUIModel.java 15 2012-11-24 13:10:24Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/campaign/EditCampaignUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.CampaignBean;
import fr.ifremer.tutti.persistence.entities.CountryBean;
import fr.ifremer.tutti.persistence.entities.GearBean;
import fr.ifremer.tutti.persistence.entities.SurveyBean;
import fr.ifremer.tutti.persistence.entities.UserBean;
import fr.ifremer.tutti.persistence.entities.VesselBean;
import fr.ifremer.tutti.ui.swing.AbstractTuttiBeanUIModel;
import org.nuiton.util.beans.BinderFactory;

import java.util.List;

/**
 * Model of UI {@link EditCampaignUI}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1O
 */
public class EditCampaignUIModel extends AbstractTuttiBeanUIModel {

    private static final long serialVersionUID = 1L;

    protected SurveyBean survey;

    protected CountryBean country;

    protected String name;

    protected String surveyPart;

    protected List<VesselBean> vessel;

    protected List<GearBean> gear;

    protected List<UserBean> headOfMission;

    protected List<UserBean> headOfSortRoom;

    protected String comment;

//    protected boolean create;
//
//    public boolean isCreate() {
//        return create;
//    }
//
//    public void setCreate(boolean create) {
//        Object oldValue = isCreate();
//        this.create = create;
//        firePropertyChange("create", oldValue, create);
//    }

    public SurveyBean getSurvey() {
        return survey;
    }

    public void setSurvey(SurveyBean survey) {
        Object oldValue = getSurvey();
        this.survey = survey;
        firePropertyChange("survey", oldValue, survey);
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        Object oldValue = getName();
        this.name = name;
        firePropertyChange("name", oldValue, name);
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        Object oldValue = getComment();
        this.comment = comment;
        firePropertyChange("comment", oldValue, comment);
    }

    public CountryBean getCountry() {
        return country;
    }

    public void setCountry(CountryBean country) {
        Object oldValue = getCountry();
        this.country = country;
        firePropertyChange("country", oldValue, country);
    }

    public String getSurveyPart() {
        return surveyPart;
    }

    public void setSurveyPart(String surveyPart) {
        Object oldValue = getSurveyPart();
        this.surveyPart = surveyPart;
        firePropertyChange("surveyPart", oldValue, surveyPart);
    }

    public List<VesselBean> getVessel() {
        return vessel;
    }

    public void setVessel(List<VesselBean> vessel) {
        this.vessel = vessel;
        firePropertyChange("vessel", null, vessel);
    }

    public List<GearBean> getGear() {
        return gear;
    }

    public void setGear(List<GearBean> gear) {
        this.gear = gear;
        firePropertyChange("gear", null, gear);
    }

    public List<UserBean> getHeadOfMission() {
        return headOfMission;
    }

    public void setHeadOfMission(List<UserBean> headOfMission) {
        this.headOfMission = headOfMission;
        firePropertyChange("headOfMission", null, headOfMission);
    }

    public List<UserBean> getHeadOfSortRoom() {
        return headOfSortRoom;
    }

    public void setHeadOfSortRoom(List<UserBean> headOfSortRoom) {
        this.headOfSortRoom = headOfSortRoom;
        firePropertyChange("headOfSortRoom", null, headOfSortRoom);
    }

    public void fromBean(CampaignBean bean) {
        BinderFactory.newBinder(CampaignBean.class,
                                EditCampaignUIModel.class).copy(bean, this);
    }

    public CampaignBean toBean() {
        CampaignBean result = new CampaignBean();
        BinderFactory.newBinder(EditCampaignUIModel.class,
                                CampaignBean.class).copy(this, result);
        return result;
    }
}