package fr.ifremer.tutti.ui.swing.launcher;

/*
 * #%L
 * Tutti :: Launcher
 * %%
 * Copyright (C) 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/**
 * Created on 1/3/15.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 1.0
 */
public class LauncherProperties {

    public static final String LAUNCHER_PROPERTIES = "launcher.properties";

    public static final String LAUNCHER_PROPERTIES_JAR = "JAR";

    public static final String LAUNCHER_PROPERTIES_LOGFILE = "LOGFILE";

    public static final String LAUNCHER_PROPERTIES_JAVA_OPTS = "JAVA_OPTS";

    private final Path basedir;

    Properties launcherProperties;

    public LauncherProperties(Path basedir) {
        this.basedir = basedir;
    }

    public void load() throws IOException {

        // application launcher properties
        Path applicationFile = basedir.resolve(Launcher.APPLICATION_DIR).resolve(LAUNCHER_PROPERTIES);
        // local launcher properties
        Path localFile = basedir.resolve(LAUNCHER_PROPERTIES);

        if (!(Files.exists(localFile) || Files.exists(applicationFile))) {

            throw new IOException("Could not find " + LAUNCHER_PROPERTIES);

        }

        Properties p1 = new Properties();
        if (Files.isReadable(applicationFile)) {
            p1.load(new FileReader(applicationFile.toFile()));
        }

        launcherProperties = new Properties(p1);
        if (Files.isReadable(localFile)) {
            launcherProperties.load(new FileReader(localFile.toFile()));
        }
    }

    public Path getJarFile() {

        String jarFileName = launcherProperties.getProperty(LAUNCHER_PROPERTIES_JAR);
        Path jarFile = basedir.resolve(jarFileName);
        return jarFile;

    }

    public Path getLogFile() {

        String logFileName = launcherProperties.getProperty(LAUNCHER_PROPERTIES_LOGFILE);
        Path logFile = basedir.resolve(logFileName);
        return logFile;

    }

    public List<String> getJavaOptions() {

        List<String> javaOptions = new ArrayList<>();
        String javaOpts = launcherProperties.getProperty(LAUNCHER_PROPERTIES_JAVA_OPTS);
        if (!(javaOpts == null || javaOpts.trim().isEmpty())) {
            String[] javaOptsArray = javaOpts.replaceAll("\"", "").split(" ");
            for (String opt : javaOptsArray) {
                if (!(opt == null || opt.trim().isEmpty())) {
                    javaOptions.add(opt);
                }
            }
        }

        return javaOptions;

    }


}
