/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.widget.checkboxcombo;

import fr.ifremer.isisfish.ui.widget.checkboxcombo.CheckableItem;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.plaf.basic.ComboPopup;

public class CheckedComboBox<E extends CheckableItem<?>>
extends JComboBox<E> {
    private boolean keepOpen;
    private transient ActionListener listener;

    public CheckedComboBox(ComboBoxModel<E> model) {
        super(model);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 20);
    }

    @Override
    public void updateUI() {
        this.setRenderer(null);
        this.removeActionListener(this.listener);
        super.updateUI();
        this.listener = e -> {
            if (((long)e.getModifiers() & 0x10L) != 0L) {
                this.updateItem(this.getSelectedIndex());
                this.keepOpen = true;
            }
        };
        JLabel label = new JLabel(" ");
        JCheckBox check = new JCheckBox(" ");
        this.setRenderer((list, value, index, isSelected, cellHasFocus) -> {
            if (index < 0) {
                String txt = CheckedComboBox.getCheckedItemString(list.getModel());
                label.setText(txt.isEmpty() ? " " : txt);
                return label;
            }
            check.setText(Objects.toString(value, ""));
            check.setSelected(value.isSelected());
            if (isSelected) {
                check.setBackground(list.getSelectionBackground());
                check.setForeground(list.getSelectionForeground());
            } else {
                check.setBackground(list.getBackground());
                check.setForeground(list.getForeground());
            }
            return check;
        });
        this.addActionListener(this.listener);
        this.getInputMap(0).put(KeyStroke.getKeyStroke(32, 0), "checkbox-select");
        this.getActionMap().put("checkbox-select", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Accessible a = CheckedComboBox.this.getAccessibleContext().getAccessibleChild(0);
                if (a instanceof ComboPopup) {
                    CheckedComboBox.this.updateItem(((ComboPopup)((Object)a)).getList().getSelectedIndex());
                }
            }
        });
    }

    private static <E extends CheckableItem<?>> String getCheckedItemString(ListModel<E> model) {
        return IntStream.range(0, model.getSize()).mapToObj(model::getElementAt).filter(CheckableItem::isSelected).map(Objects::toString).collect(Collectors.joining(", "));
    }

    protected void updateItem(int index) {
        if (this.isPopupVisible()) {
            CheckableItem item;
            item.setSelected(!(item = (CheckableItem)this.getItemAt(index)).isSelected());
            this.setSelectedIndex(-1);
            this.setSelectedItem(item);
        }
    }

    @Override
    public void setPopupVisible(boolean v) {
        if (this.keepOpen) {
            this.keepOpen = false;
        } else {
            super.setPopupVisible(v);
        }
    }
}

