/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.script;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.FormuleStorage;
import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import fr.ifremer.isisfish.datastore.ObjectiveStorage;
import fr.ifremer.isisfish.datastore.OptimizationStorage;
import fr.ifremer.isisfish.datastore.ResultInfoStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.datastore.ScriptStorage;
import fr.ifremer.isisfish.datastore.SensitivityAnalysisStorage;
import fr.ifremer.isisfish.datastore.SensitivityExportStorage;
import fr.ifremer.isisfish.datastore.SimulationPlanStorage;
import fr.ifremer.isisfish.datastore.SimulatorStorage;
import fr.ifremer.isisfish.ui.WelcomePanelUI;
import fr.ifremer.isisfish.ui.script.ScriptFileFilter;
import fr.ifremer.isisfish.ui.script.ScriptUI;
import fr.ifremer.isisfish.ui.script.model.ScriptTree;
import fr.ifremer.isisfish.ui.script.model.ScriptTreeModel;
import fr.ifremer.isisfish.util.CompileHelper;
import fr.ifremer.isisfish.util.ErrorHelper;
import fr.ifremer.isisfish.util.JavadocHelper;
import fr.ifremer.isisfish.vcs.VCSException;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.FileUtil;
import org.nuiton.util.ZipUtil;

public class ScriptHandler
implements TreeSelectionListener {
    private static Log log = LogFactory.getLog(ScriptHandler.class);
    public static final Color COLOR_SUCCESS = new Color(210, 255, 210);
    public static final Color COLOR_FAILURE = new Color(255, 210, 210);
    protected CodeSourceStorage codeStorage;
    protected Configuration freemarkerConfiguration;
    protected ScriptUI scriptUI;
    protected static FileFilter scriptFileFilter;

    public ScriptHandler(ScriptUI scriptUI) {
        this.scriptUI = scriptUI;
        this.freemarkerConfiguration = new Configuration(Configuration.VERSION_2_3_0);
        this.freemarkerConfiguration.setDefaultEncoding("utf-8");
        ClassTemplateLoader templateLoader = new ClassTemplateLoader(ScriptHandler.class, "/");
        this.freemarkerConfiguration.setTemplateLoader((TemplateLoader)templateLoader);
    }

    public void afterInit() {
        ScriptTree scriptTree = this.scriptUI.getScriptTree();
        scriptTree.addTreeSelectionListener(this);
        scriptTree.expandRow(0);
        this.scriptUI.getMiSearch().setAction(this.scriptUI.getEditor().getFindAction());
        this.scriptUI.getMiReplace().setAction(this.scriptUI.getEditor().getReplaceAction());
        this.scriptUI.getMiGoto().setAction(this.scriptUI.getEditor().getGotoAction());
        this.scriptUI.getMiSave().setAction(this.scriptUI.getEditor().getSaveAction());
        this.scriptUI.getMiCopy().setAction(this.scriptUI.getEditor().getCopyAction());
        this.scriptUI.getMiCut().setAction(this.scriptUI.getEditor().getCutAction());
        this.scriptUI.getMiPaste().setAction(this.scriptUI.getEditor().getPasteAction());
        this.scriptUI.buttonScriptCut.setAction(this.scriptUI.getEditor().getCutAction());
        this.scriptUI.buttonScriptCopy.setAction(this.scriptUI.getEditor().getCopyAction());
        this.scriptUI.buttonScriptPaste.setAction(this.scriptUI.getEditor().getPasteAction());
        this.scriptUI.buttonScriptSave.setAction(this.scriptUI.getEditor().getSaveAction());
        this.scriptUI.getActionLogSplitPane().getBottomComponent().setMinimumSize(new Dimension());
        this.scriptUI.getActionLogSplitPane().setDividerLocation(1.0);
    }

    protected void setButton() {
        File selectedFile = this.scriptUI.getScriptTree().getSelectedFile();
        if (selectedFile != null) {
            this.scriptUI.setSingleFileSelected(selectedFile.isFile());
            boolean isFormule = selectedFile.getAbsolutePath().contains(File.separator + "formules" + File.separator);
            this.scriptUI.setJavaFileSelected(selectedFile.getName().endsWith(".java") && !isFormule);
        } else {
            this.scriptUI.setSingleFileSelected(false);
            this.scriptUI.setJavaFileSelected(false);
        }
    }

    protected void setStatusMessage(String msg) {
        WelcomePanelUI parentUI = this.scriptUI.getParentContainer(WelcomePanelUI.class);
        parentUI.setStatusMessage(msg);
    }

    protected void setStatusMessage(String msg, boolean running) {
        WelcomePanelUI parentUI = this.scriptUI.getParentContainer(WelcomePanelUI.class);
        parentUI.setStatusMessage(msg, running);
    }

    public void newScript(MouseEvent event) {
        JPopupMenu menu = new JPopupMenu();
        JMenu oldMenu = this.scriptUI.getScriptNewMenu();
        for (int i = 0; i < oldMenu.getItemCount(); ++i) {
            JMenuItem oldMenuItem = (JMenuItem)oldMenu.getMenuComponent(i);
            JMenuItem miCopy = new JMenuItem();
            miCopy.setText(oldMenuItem.getText());
            miCopy.setIcon(oldMenuItem.getIcon());
            for (ActionListener l : oldMenuItem.getActionListeners()) {
                miCopy.addActionListener(l);
            }
            menu.add(miCopy);
        }
        menu.show((Component)event.getSource(), event.getX(), event.getY());
    }

    public void newScript(ScriptMapping scriptType) {
        File scriptFile;
        String fileName;
        String equationModelType = "";
        Object equationModelTypePath = "";
        if (scriptType.equals((Object)ScriptMapping.Formule)) {
            List<String> values = FormuleStorage.getCategories();
            equationModelType = (String)JOptionPane.showInputDialog(this.scriptUI, I18n.t((String)"isisfish.message.new.formule.category", (Object[])new Object[0]), I18n.t((String)"isisfish.message.new.formule.title", (Object[])new Object[0]), -1, null, values.toArray(), values.get(0));
            equationModelTypePath = equationModelType + File.separator;
        }
        if (equationModelType != null && !StringUtils.isEmpty((CharSequence)(fileName = JOptionPane.showInputDialog(I18n.t((String)"isisfish.message.new.filename", (Object[])new Object[0])))) && (scriptFile = this.newScript((String)equationModelTypePath + fileName, scriptType)) != null) {
            ScriptTreeModel model = this.scriptUI.getScriptTreeModel();
            model.fileAdded(scriptFile);
            TreePath treePath = model.getTreePathFor(scriptFile);
            this.scriptUI.getScriptTree().setSelectionPath(treePath);
        }
    }

    protected File newScript(String fileName, ScriptMapping scriptType) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("newScript called [" + String.valueOf((Object)scriptType) + "]"));
        }
        File scriptFile = null;
        try {
            String scriptTemplatePath;
            String realFilename;
            int pos = fileName.lastIndexOf(47);
            if (pos != -1) {
                if (scriptType != ScriptMapping.Formule) {
                    String message = I18n.t((String)"isisfish.error.invalid.file.name", (Object[])new Object[]{fileName});
                    RuntimeException e = new RuntimeException(message);
                    this.returnError(I18n.t((String)"isisfish.error.script.create", (Object[])new Object[]{fileName, e.getMessage()}), e);
                    return null;
                }
                if (pos == fileName.length() - 1) {
                    String message = I18n.t((String)"isisfish.error.invalid.file.name", (Object[])new Object[]{fileName});
                    RuntimeException e = new RuntimeException(message);
                    this.returnError(I18n.t((String)"isisfish.error.script.create", (Object[])new Object[]{fileName, e.getMessage()}), e);
                    return null;
                }
                realFilename = fileName.substring(fileName.lastIndexOf(47) + 1);
                String category = fileName.substring(0, fileName.lastIndexOf(47));
            } else {
                realFilename = fileName;
                String category = "";
            }
            if (!realFilename.matches("[A-Z0-9_][a-zA-Z0-9_]*")) {
                String message = I18n.t((String)"isisfish.error.invalid.file.name", (Object[])new Object[]{fileName});
                RuntimeException e = new RuntimeException(message);
                this.returnError(I18n.t((String)"isisfish.error.script.create", (Object[])new Object[]{fileName, e.getMessage()}), e);
                return null;
            }
            JavaSourceStorage script = null;
            switch (scriptType.ordinal()) {
                case 19: {
                    script = SimulationPlanStorage.createSimulationPlan(fileName, CodeSourceStorage.Location.COMMUNITY);
                    break;
                }
                case 11: {
                    script = ExportStorage.createExport(fileName, CodeSourceStorage.Location.COMMUNITY);
                    break;
                }
                case 12: {
                    script = ObjectiveStorage.createObjective(fileName, CodeSourceStorage.Location.COMMUNITY);
                    break;
                }
                case 15: {
                    script = ResultInfoStorage.createResultInfo(fileName, CodeSourceStorage.Location.COMMUNITY);
                    break;
                }
                case 13: {
                    script = OptimizationStorage.createOptimization(fileName, CodeSourceStorage.Location.COMMUNITY);
                    break;
                }
                case 14: {
                    script = RuleStorage.createRule(fileName, CodeSourceStorage.Location.COMMUNITY);
                    break;
                }
                case 16: {
                    script = ScriptStorage.createScript(fileName, CodeSourceStorage.Location.COMMUNITY);
                    break;
                }
                case 20: {
                    script = SimulatorStorage.createSimulator(fileName, CodeSourceStorage.Location.COMMUNITY);
                    break;
                }
                case 17: {
                    script = SensitivityAnalysisStorage.createSensitivityAnalysis(fileName, CodeSourceStorage.Location.COMMUNITY);
                    break;
                }
                case 18: {
                    script = SensitivityExportStorage.createSensitivityExport(fileName, CodeSourceStorage.Location.COMMUNITY);
                    break;
                }
                default: {
                    if (!log.isErrorEnabled()) break;
                    log.fatal((Object)("ScriptType unknown: " + String.valueOf((Object)scriptType)));
                }
            }
            if (script != null && script.exists()) {
                String message = I18n.t((String)"isisfish.error.file.already.exists", (Object[])new Object[]{fileName});
                RuntimeException e = new RuntimeException(message);
                this.returnError(I18n.t((String)"isisfish.error.script.create", (Object[])new Object[]{fileName, e.getMessage()}), e);
            }
            if ((scriptTemplatePath = scriptType.getTemplatePath()) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Parsing freemarker template located in " + scriptTemplatePath));
                }
            } else {
                throw new IsisFishRuntimeException("There is no templatePath");
            }
            Template template = this.freemarkerConfiguration.getTemplate(scriptTemplatePath);
            HashMap<String, Object> root = new HashMap<String, Object>();
            root.put("name", realFilename);
            root.put("date", new Date());
            root.put("author", IsisFish.config.getUserName());
            root.put("email", IsisFish.config.getUserMail());
            StringWriter out = new StringWriter();
            template.process(root, (Writer)out);
            ((Writer)out).flush();
            script.setContent(((Object)out).toString());
            this.codeStorage = script;
            scriptFile = script.getFile();
        }
        catch (Exception eee) {
            this.returnError(I18n.t((String)"isisfish.error.script.create", (Object[])new Object[]{fileName, eee.getMessage()}), eee);
        }
        return scriptFile;
    }

    protected void returnError(String s, Exception eee) {
        if (log.isErrorEnabled()) {
            log.error((Object)s, (Throwable)eee);
        }
        ErrorHelper.showErrorDialog(s, eee);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (e.getNewLeadSelectionPath() != null) {
            Object selectedNode = e.getNewLeadSelectionPath().getLastPathComponent();
            if (selectedNode instanceof File && ((File)selectedNode).isFile()) {
                File selectedFile = (File)selectedNode;
                this.loadScript(selectedFile);
                this.scriptUI.getEditor().open(selectedFile);
                this.setButton();
            } else {
                this.scriptUI.getEditor().close();
                this.setButton();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void loadScript(File file) {
        ScriptMapping mapping = ScriptMapping.getMappingFor(file);
        Object var3_3 = null;
        try {
            void var3_26;
            switch (mapping.ordinal()) {
                case 10: 
                case 21: {
                    String fullPath = file.getAbsolutePath();
                    int lastIndexOf = fullPath.lastIndexOf(47);
                    String category = fullPath.substring(fullPath.lastIndexOf(47, lastIndexOf - 1) + 1, lastIndexOf);
                    if (mapping.equals((Object)ScriptMapping.Formule)) {
                        FormuleStorage formuleStorage = FormuleStorage.getFormule(category, file.getName());
                        break;
                    }
                    FormuleStorage formuleStorage = FormuleStorage.getCommunityFormule(category, file.getName());
                    break;
                }
                case 1: {
                    RuleStorage ruleStorage = RuleStorage.getRule(file.getName(), CodeSourceStorage.Location.OFFICIAL);
                    break;
                }
                case 2: {
                    ResultInfoStorage resultInfoStorage = ResultInfoStorage.getResultInfo(file.getName(), CodeSourceStorage.Location.OFFICIAL);
                    break;
                }
                case 3: {
                    ObjectiveStorage objectiveStorage = ObjectiveStorage.getObjective(file.getName(), CodeSourceStorage.Location.OFFICIAL);
                    break;
                }
                case 4: {
                    OptimizationStorage optimizationStorage = OptimizationStorage.getOptimization(file.getName(), CodeSourceStorage.Location.OFFICIAL);
                    break;
                }
                case 8: {
                    SimulationPlanStorage simulationPlanStorage = SimulationPlanStorage.getSimulationPlan(file.getName(), CodeSourceStorage.Location.OFFICIAL);
                    break;
                }
                case 0: {
                    ExportStorage exportStorage = ExportStorage.getExport(file.getName(), CodeSourceStorage.Location.OFFICIAL);
                    break;
                }
                case 5: {
                    ScriptStorage scriptStorage = ScriptStorage.getScript(file.getName(), CodeSourceStorage.Location.OFFICIAL);
                    break;
                }
                case 9: {
                    SimulatorStorage simulatorStorage = SimulatorStorage.getSimulator(file.getName(), CodeSourceStorage.Location.OFFICIAL);
                    break;
                }
                case 6: {
                    SensitivityAnalysisStorage sensitivityAnalysisStorage = SensitivityAnalysisStorage.getSensitivityAnalysis(file.getName(), CodeSourceStorage.Location.OFFICIAL);
                    break;
                }
                case 7: {
                    SensitivityExportStorage sensitivityExportStorage = SensitivityExportStorage.getSensitivityExport(file.getName(), CodeSourceStorage.Location.OFFICIAL);
                    break;
                }
                case 12: {
                    ObjectiveStorage objectiveStorage = ObjectiveStorage.getObjective(file.getName(), CodeSourceStorage.Location.COMMUNITY);
                    break;
                }
                case 13: {
                    OptimizationStorage optimizationStorage = OptimizationStorage.getOptimization(file.getName(), CodeSourceStorage.Location.COMMUNITY);
                    break;
                }
                case 14: {
                    RuleStorage ruleStorage = RuleStorage.getRule(file.getName(), CodeSourceStorage.Location.COMMUNITY);
                    break;
                }
                case 15: {
                    ResultInfoStorage resultInfoStorage = ResultInfoStorage.getResultInfo(file.getName(), CodeSourceStorage.Location.COMMUNITY);
                    break;
                }
                case 19: {
                    SimulationPlanStorage simulationPlanStorage = SimulationPlanStorage.getSimulationPlan(file.getName(), CodeSourceStorage.Location.COMMUNITY);
                    break;
                }
                case 11: {
                    ExportStorage exportStorage = ExportStorage.getExport(file.getName(), CodeSourceStorage.Location.COMMUNITY);
                    break;
                }
                case 16: {
                    ScriptStorage scriptStorage = ScriptStorage.getScript(file.getName(), CodeSourceStorage.Location.COMMUNITY);
                    break;
                }
                case 20: {
                    SimulatorStorage simulatorStorage = SimulatorStorage.getSimulator(file.getName(), CodeSourceStorage.Location.COMMUNITY);
                    break;
                }
                case 17: {
                    SensitivityAnalysisStorage sensitivityAnalysisStorage = SensitivityAnalysisStorage.getSensitivityAnalysis(file.getName(), CodeSourceStorage.Location.COMMUNITY);
                    break;
                }
                case 18: {
                    SensitivityExportStorage sensitivityExportStorage = SensitivityExportStorage.getSensitivityExport(file.getName(), CodeSourceStorage.Location.COMMUNITY);
                    break;
                }
                default: {
                    log.fatal((Object)("ScriptType unknown: " + file.getName()));
                }
            }
            this.codeStorage = var3_26;
        }
        catch (Exception eee) {
            this.returnError(I18n.t((String)"isisfish.error.script.load", (Object[])new Object[]{file.getAbsolutePath(), eee.getMessage()}), eee);
        }
        finally {
            this.codeStorage = var3_3;
        }
    }

    public boolean fileLoaded() {
        return this.codeStorage != null;
    }

    public boolean isJavaScript() {
        return this.codeStorage instanceof JavaSourceStorage;
    }

    public void saveScript() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("saveScript called on " + this.codeStorage.getName()));
        }
        try {
            this.scriptUI.getEditor().save();
            String content = this.scriptUI.getEditor().getText();
            this.codeStorage.setContent(content, false);
            ScriptTreeModel model = this.scriptUI.getScriptTreeModel();
            model.fileModified(this.codeStorage.getFile());
        }
        catch (Exception eee) {
            this.returnError(I18n.t((String)"isisfish.error.script.save", (Object[])new Object[]{this.codeStorage.getFile(), eee.getMessage()}), eee);
        }
        this.setStatusMessage(I18n.t((String)"isisfish.message.save.finished", (Object[])new Object[0]));
    }

    public void commitScript() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("commitScript called for " + this.codeStorage.getName()));
        }
        try {
            this.saveScript();
            String msg = JOptionPane.showInputDialog(I18n.t((String)"isisfish.message.script.commit", (Object[])new Object[]{this.codeStorage.getName()}));
            if (msg == null) {
                this.setStatusMessage(I18n.t((String)"isisfish.message.commit.cancelled", (Object[])new Object[0]));
            } else {
                this.codeStorage.commit(msg);
                this.codeStorage.reload();
                this.setStatusMessage(I18n.t((String)"isisfish.message.commit.finished", (Object[])new Object[0]));
            }
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error on script commit", (Throwable)ex);
            }
            ErrorHelper.showErrorDialog(ex.getMessage(), ex);
        }
    }

    public void exportScript() {
        TreePath[] selectedFilesPath = this.scriptUI.getScriptTree().getSelectionPaths();
        int prefixLength = IsisFish.config.getDatabaseDirectory().getAbsolutePath().length() + 1;
        List<String> listFiles = ScriptHandler.extractFiles(prefixLength, selectedFilesPath);
    }

    protected static List<String> extractFiles(int prefixLength, TreePath[] selectedPaths) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<File> dirFound = new ArrayList<File>();
        ArrayList<File> dirWithFileFound = new ArrayList<File>();
        for (TreePath selectedPath : selectedPaths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedPath.getPathComponent(1);
            String moduleDisplayName = String.valueOf(node.getUserObject());
            File file = ScriptMapping.valueOf(moduleDisplayName).getModule();
            int nbPaths = selectedPath.getPathCount();
            if (nbPaths > 2) {
                for (int i = 2; i < nbPaths; ++i) {
                    node = (DefaultMutableTreeNode)selectedPath.getPathComponent(i);
                    String pathName = String.valueOf(node.getUserObject());
                    file = new File(file, pathName);
                }
            }
            if (file.isFile()) {
                File parentFile = file.getParentFile();
                if (!dirFound.contains(parentFile)) {
                    dirFound.add(parentFile);
                }
                dirWithFileFound.add(parentFile);
                result.add(file.getAbsolutePath().substring(prefixLength));
                continue;
            }
            dirFound.add(file);
        }
        dirFound.removeAll(dirWithFileFound);
        dirWithFileFound.clear();
        if (!dirFound.isEmpty()) {
            ArrayList listF = new ArrayList();
            for (File dir : dirFound) {
                FileFilter filter = new FileFilter(){
                    FileFilter excludeFilter = ScriptHandler.getScriptFileFilter();

                    @Override
                    public boolean accept(File pathname) {
                        return !this.excludeFilter.accept(pathname);
                    }
                };
                listF.addAll(FileUtil.getFilteredElements((File)dir, (FileFilter)filter, (boolean)true));
            }
            for (File file : listF) {
                result.add(file.getAbsolutePath().substring(prefixLength));
            }
            listF.clear();
        }
        dirFound.clear();
        return result;
    }

    public static FileFilter getScriptFileFilter() {
        if (scriptFileFilter == null) {
            scriptFileFilter = new ScriptFileFilter(IsisFish.vcs);
        }
        return scriptFileFilter;
    }

    public boolean checkScript() {
        boolean check = false;
        this.resetCheckLogArea();
        if (this.codeStorage instanceof FormuleStorage) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"checkScript called");
        }
        this.saveScript();
        JavaSourceStorage javaCode = (JavaSourceStorage)this.codeStorage;
        StringWriter result = new StringWriter();
        PrintWriter out = new PrintWriter(result);
        try {
            int compileResult = javaCode.compile(false, out);
            if (compileResult == 0) {
                check = true;
            }
        }
        catch (Exception eee) {
            eee.printStackTrace(out);
        }
        out.flush();
        if (check) {
            this.scriptUI.getActionLogArea().setText(I18n.t((String)"isisfish.script.compilation.ok", (Object[])new Object[]{result.toString()}));
            this.scriptUI.getActionLogArea().setBackground(COLOR_SUCCESS);
        } else {
            this.scriptUI.getActionLogArea().setText(I18n.t((String)"isisfish.script.compilation.failed", (Object[])new Object[]{result.toString()}));
            this.scriptUI.getActionLogArea().setBackground(COLOR_FAILURE);
        }
        this.setStatusMessage(I18n.t((String)"isisfish.message.check.finished", (Object[])new Object[0]));
        return check;
    }

    public void checkAllScripts() {
        new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                ScriptHandler.this.checkAllScriptsAsync();
                return null;
            }
        }.execute();
    }

    protected void resetCheckLogArea() {
        int maxLocation = this.scriptUI.getActionLogSplitPane().getMaximumDividerLocation();
        if (this.scriptUI.getActionLogSplitPane().getBottomComponent().getHeight() == 0) {
            this.scriptUI.getActionLogSplitPane().setDividerLocation((int)((double)maxLocation * 0.75));
        }
        this.scriptUI.getActionLogArea().setBackground(null);
        this.scriptUI.getActionLogArea().setText("");
    }

    protected void checkAllScriptsAsync() {
        this.setStatusMessage(I18n.t((String)"isisfish.message.check.inprogress", (Object[])new Object[0]), true);
        boolean allSuccess = true;
        this.resetCheckLogArea();
        for (ScriptMapping scriptMapping : ScriptMapping.values()) {
            List javaFiles = FileUtil.find((File)scriptMapping.getModule(), (String)".+\\.java$", (boolean)false);
            javaFiles.removeIf(file -> file.getAbsolutePath().contains(File.separator + "formules" + File.separator));
            for (File javaFile : javaFiles) {
                this.scriptUI.getActionLogArea().append(I18n.t((String)"isisfish.script.compilingfile", (Object[])new Object[]{javaFile}));
                StringWriter result = new StringWriter();
                PrintWriter out = new PrintWriter(result);
                int compileResult = CompileHelper.compile(IsisFish.config.getDatabaseDirectory(), javaFile, IsisFish.config.getCompileDirectory(), out);
                out.flush();
                if (compileResult == 0) {
                    this.scriptUI.getActionLogArea().append(I18n.t((String)"isisfish.common.ok", (Object[])new Object[0]) + "\n");
                } else {
                    this.scriptUI.getActionLogArea().append(I18n.t((String)"isisfish.common.error", (Object[])new Object[0]) + ":\n");
                    this.scriptUI.getActionLogArea().append(result.toString() + "\n");
                    this.scriptUI.getActionLogArea().setBackground(COLOR_FAILURE);
                    allSuccess = false;
                }
                this.scriptUI.getActionLogArea().setCaretPosition(this.scriptUI.getActionLogArea().getText().length());
            }
        }
        if (allSuccess) {
            this.scriptUI.getActionLogArea().setBackground(COLOR_SUCCESS);
        }
        this.setStatusMessage(I18n.t((String)"isisfish.message.check.finished", (Object[])new Object[0]));
    }

    public void evaluateScript() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"evaluateScript called");
        }
        try {
            if (this.checkScript()) {
                this.scriptUI.getActionLogArea().setBackground(null);
                JavaSourceStorage javaCode = (JavaSourceStorage)this.codeStorage;
                ByteArrayOutputStream result = new ByteArrayOutputStream();
                PrintStream out = new PrintStream(result);
                PrintStream err = new PrintStream(result);
                PrintStream oldOut = System.out;
                PrintStream oldErr = System.err;
                System.setOut(out);
                System.setErr(err);
                Class clazz = javaCode.getCodeClass();
                Method main = clazz.getMethod("main", String[].class);
                main.invoke(null, new Object[]{new String[0]});
                System.setOut(oldOut);
                System.setErr(oldErr);
                this.scriptUI.getActionLogArea().setText(result.toString());
            }
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error on script evaluation", (Throwable)ex);
            }
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            PrintStream out = new PrintStream(result);
            ex.printStackTrace(out);
            this.scriptUI.getActionLogArea().setText(result.toString());
        }
        this.setStatusMessage(I18n.t((String)"isisfish.message.evaluation.finished", (Object[])new Object[0]));
    }

    protected void backup(File src, String path, String suffix) throws IOException {
    }

    protected static List<String>[] scanZip(File source, File root) {
        ArrayList overwrittenFiles = new ArrayList();
        ArrayList newFiles = new ArrayList();
        try {
            ZipUtil.scan((File)source, (File)root, newFiles, overwrittenFiles, (FileFilter)ScriptHandler.getScriptFileFilter(), null, null);
        }
        catch (IOException e) {
            log.error((Object)("Can't scan zip (" + String.valueOf(source) + ")"), (Throwable)e);
            throw new RuntimeException(e);
        }
        return new List[]{newFiles, overwrittenFiles};
    }

    public void deleteScript(boolean deleteRemote) {
        String name;
        int resp;
        if (log.isDebugEnabled()) {
            log.debug((Object)"DeleteScript called");
        }
        if ((resp = JOptionPane.showConfirmDialog(this.scriptUI, I18n.t((String)"isisfish.message.confirm.remove.script", (Object[])new Object[]{name = this.codeStorage.getName()}), null, 0)) == 0) {
            this.scriptUI.getEditor().close();
            try {
                this.scriptUI.getScriptTreeModel().fileDeleted(this.codeStorage.getFile());
                this.codeStorage.delete(deleteRemote);
                if (this.codeStorage.getFile().exists()) {
                    ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.script.delete", (Object[])new Object[]{this.codeStorage.getFile()}));
                }
            }
            catch (Exception eee) {
                this.returnError(I18n.t((String)"isisfish.error.script.delete", (Object[])new Object[]{this.codeStorage == null ? null : this.codeStorage.getFile(), eee.getMessage()}), eee);
            }
            this.setStatusMessage(I18n.t((String)"isisfish.message.delete.finished", (Object[])new Object[0]));
        } else {
            this.setStatusMessage(I18n.t((String)"isisfish.message.delete.canceled", (Object[])new Object[0]));
        }
    }

    public void diffScript() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Method diffScript called on " + String.valueOf(this.codeStorage.getFile())));
        }
        try {
            String result = IsisFish.vcs.isOnRemote(this.codeStorage.getFile()) ? IsisFish.vcs.getDiff(this.codeStorage.getFile()) : "File not on remote";
            this.scriptUI.getActionLogArea().setText(result);
        }
        catch (VCSException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't get diff", (Throwable)e);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.vcs.vcssvn.diff.error", (Object[])new Object[0]), e);
        }
    }

    public void generateScriptJavadoc() {
        this.setStatusMessage(I18n.t((String)"isisfish.script.menu.javadocgenerating", (Object[])new Object[]{IsisFish.config.getJavadocDirectory()}), true);
        SwingUtilities.invokeLater(() -> {
            File rootDatabase = IsisFish.config.getDatabaseDirectory();
            File javadocDirectory = IsisFish.config.getJavadocDirectory();
            StringWriter output = new StringWriter();
            try (PrintWriter out = new PrintWriter(output);){
                int ok = JavadocHelper.generateJavadoc(rootDatabase, javadocDirectory, out);
                if (ok == 0) {
                    this.scriptUI.getActionLogArea().setText(I18n.t((String)"isisfish.script.javadoc.ok", (Object[])new Object[]{output.toString()}));
                    this.scriptUI.getActionLogArea().setBackground(COLOR_SUCCESS);
                } else {
                    this.scriptUI.getActionLogArea().setText(I18n.t((String)"isisfish.script.compilation.failed", (Object[])new Object[]{output.toString()}));
                    this.scriptUI.getActionLogArea().setBackground(COLOR_FAILURE);
                }
            }
            this.setStatusMessage(I18n.t((String)"isisfish.script.menu.javadocgenerated", (Object[])new Object[]{IsisFish.config.getJavadocDirectory()}));
        });
    }

    public void showScriptJavadoc() {
        block2: {
            try {
                File indexFile = new File(IsisFish.config.getJavadocDirectory(), "index.html");
                URI uri = indexFile.toURI();
                Desktop.getDesktop().browse(uri);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't show script javadocs", (Throwable)e);
            }
        }
    }

    public void moveFiles(File directory, Collection<File> filesToMove) {
        ScriptTreeModel model = this.scriptUI.getScriptTreeModel();
        for (File fileToMove : filesToMove) {
            model.fileDeleted(fileToMove);
            File destFile = new File(directory, fileToMove.getName());
            try {
                FileUtils.moveFile((File)fileToMove, (File)destFile);
            }
            catch (IOException ex) {
                throw new IsisFishRuntimeException("Can't move file", ex);
            }
            model.fileAdded(destFile);
        }
    }

    protected static enum ScriptMapping {
        Export(ExportStorage.getExportDirectory(), "templates/script/export.ftl", true),
        Rule(RuleStorage.getRuleDirectory(), "templates/script/rule.ftl", true),
        ResultInfo(ResultInfoStorage.getResultInfoDirectory(), "templates/script/resultinfo.ftl", true),
        Objective(ObjectiveStorage.getObjectiveDirectory(), "templates/script/objective.ftl", true),
        Optimization(OptimizationStorage.getOptimizationDirectory(), "templates/script/optimization.ftl", true),
        Script(ScriptStorage.getScriptDirectory(), "templates/script/script.ftl", true),
        Sensitivity(SensitivityAnalysisStorage.getSensitivityAnalysisDirectory(), "templates/script/sensitivityanalysis.ftl", true),
        SensitivityExport(SensitivityExportStorage.getSensitivityExportDirectory(), "templates/script/sensitivityexport.ftl", true),
        SimulationPlan(SimulationPlanStorage.getSimulationPlanDirectory(), "templates/script/simulationplan.ftl", true),
        Simulator(SimulatorStorage.getSimulatorDirectory(), "templates/script/simulator.ftl", true),
        Formule(FormuleStorage.getFormuleDirectory(), "templates/script/equation.ftl", true),
        CommunityExport(ExportStorage.getCommunityExportDirectory(), "templates/script/export.ftl"),
        CommunityObjective(ObjectiveStorage.getCommunityObjectiveDirectory(), "templates/script/objective.ftl"),
        CommunityOptimization(OptimizationStorage.getCommunityOptimizationDirectory(), "templates/script/optimization.ftl"),
        CommunityRule(RuleStorage.getCommunityRuleDirectory(), "templates/script/rule.ftl"),
        CommunityResultInfo(ResultInfoStorage.getCommunityResultInfoDirectory(), "templates/script/resultinfo.ftl"),
        CommunityScript(ScriptStorage.getCommunityScriptDirectory(), "templates/script/script.ftl"),
        CommunitySensitivity(SensitivityAnalysisStorage.getCommunitySensitivityAnalysisDirectory(), "templates/script/sensitivityanalysis.ftl"),
        CommunitySensitivityExport(SensitivityExportStorage.getCommunitySensitivityExportDirectory(), "templates/script/sensitivityexport.ftl"),
        CommunitySimulationPlan(SimulationPlanStorage.getCommunitySimulationPlanDirectory(), "templates/script/simulationplan.ftl"),
        CommunitySimulator(SimulatorStorage.getCommunitySimulatorDirectory(), "templates/script/simulator.ftl"),
        CommunityFormule(FormuleStorage.getCommunityFormuleDirectory(), "templates/script/equation.ftl");

        protected File module;
        protected String templatePath;
        protected boolean officialVCS;

        private ScriptMapping(File module, String templatePath) {
            this(module, templatePath, false);
        }

        private ScriptMapping(File module, String templatePath, boolean officialVCS) {
            this.module = module;
            this.templatePath = templatePath;
            this.officialVCS = officialVCS;
        }

        public static ScriptMapping getMappingFor(File file) {
            ScriptMapping result = null;
            for (ScriptMapping mapping : ScriptMapping.values()) {
                if (!file.getAbsolutePath().startsWith(mapping.getModule().getAbsolutePath() + File.separator)) continue;
                result = mapping;
            }
            return result;
        }

        public File getModule() {
            return this.module;
        }

        public String getTemplatePath() {
            return this.templatePath;
        }

        public boolean isOfficialVCS() {
            return this.officialVCS;
        }
    }
}

