/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.keystore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.ui.keystore.PasswordUI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class PasswordManager {
    protected static final String ACCOUNT_SEPARATOR = ";";
    protected static final String PASSWORD_SEPARATOR = ":";
    protected static PasswordManager instance;
    protected Map<String, String> storedPasswords = new HashMap<String, String>();
    protected Map<String, String> memoryPassword = new HashMap<String, String>();

    public static PasswordManager getInstance() {
        if (instance == null) {
            instance = new PasswordManager();
        }
        return instance;
    }

    protected PasswordManager() {
        this.parsePasswords();
    }

    protected void parsePasswords() {
        String keystorePasswords = IsisFish.config.getKeystorePasswords();
        this.storedPasswords.clear();
        if (StringUtils.isNotBlank((CharSequence)keystorePasswords)) {
            String[] accounts;
            for (String account : accounts = keystorePasswords.split(Pattern.quote(ACCOUNT_SEPARATOR))) {
                String[] all = account.split(PASSWORD_SEPARATOR, 2);
                String pwd = new String(Base64.getDecoder().decode(all[1]));
                this.storedPasswords.put(all[0], pwd);
            }
        }
    }

    protected void addPassword(String identifier, String password, boolean store) {
        this.memoryPassword.put(identifier, password);
        if (store) {
            this.storedPasswords.put(identifier, password);
            this.storePasswords();
        }
    }

    protected void storePasswords() {
        String passwordAsString = this.storedPasswords.entrySet().stream().map(e -> (String)e.getKey() + PASSWORD_SEPARATOR + Base64.getEncoder().encodeToString(((String)e.getValue()).getBytes(StandardCharsets.UTF_8))).collect(Collectors.joining(ACCOUNT_SEPARATOR));
        IsisFish.config.setKeystorePasswords(passwordAsString);
        IsisFish.config.saveForUser(new String[0]);
    }

    public String getPassword(String identifier) {
        return this.getPassword(identifier, false);
    }

    public synchronized String getPassword(String identifier, boolean forceNew) {
        String current = this.storedPasswords.get(identifier);
        if (current == null) {
            current = this.memoryPassword.get(identifier);
        }
        if (current == null || forceNew) {
            PasswordUI passwordUI = new PasswordUI(null);
            String password = passwordUI.getPassword(identifier);
            if (password == null) {
                current = null;
                this.memoryPassword.remove(identifier);
            } else {
                this.addPassword(identifier, password, passwordUI.isRememberPassword());
                current = password;
            }
        }
        return current;
    }
}

