/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.cell;

import com.bbn.openmap.event.CoordMouseMode;
import com.bbn.openmap.event.SelectMouseMode;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.map.OpenMapEvents;
import fr.ifremer.isisfish.ui.input.InputContentHandler;
import fr.ifremer.isisfish.ui.input.InputUI;
import fr.ifremer.isisfish.ui.input.cell.CellUI;
import fr.ifremer.isisfish.ui.models.common.GenericComboModel;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityInputUI;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import org.nuiton.i18n.I18n;

public class CellHandler
extends InputContentHandler<CellUI> {
    protected boolean init;

    protected CellHandler(CellUI inputContentUI) {
        super(inputContentUI);
    }

    protected void afterInit() {
        this.setupGotoNextPath(I18n.t((String)"isisfish.input.continueZones", (Object[])new Object[0]), I18n.n((String)"isisfish.input.tree.zones", (Object[])new Object[0]));
        new OpenMapEvents(((CellUI)this.inputContentUI).getCellMap(), (CoordMouseMode)new SelectMouseMode(false), 1){

            @Override
            public boolean mouseClicked(MouseEvent e) {
                boolean result = false;
                if (((CellUI)CellHandler.this.inputContentUI).getBean() != null) {
                    for (Cell c : ((CellUI)CellHandler.this.inputContentUI).getCellMap().getSelectedCells()) {
                        if (c.getTopiaId().equals(((CellUI)CellHandler.this.inputContentUI).getBean().getTopiaId())) continue;
                        ((CellUI)CellHandler.this.inputContentUI).getFieldCell().setSelectedItem(c);
                        result = true;
                    }
                }
                return result;
            }
        };
        ((CellUI)this.inputContentUI).addPropertyChangeListener("bean", evt -> {
            this.init = true;
            GenericComboModel<Cell> cellModel = new GenericComboModel<Cell>();
            if (evt.getNewValue() == null) {
                ((CellUI)this.inputContentUI).fieldCellName.setText("");
                ((CellUI)this.inputContentUI).fieldCellLatitude.setText("");
                ((CellUI)this.inputContentUI).fieldCellLongitude.setText("");
                ((CellUI)this.inputContentUI).fieldCellComment.setText("");
                ((CellUI)this.inputContentUI).fieldCellLand.setSelected(false);
            }
            if (evt.getNewValue() != null) {
                cellModel.setElementList(((CellUI)this.inputContentUI).getFisheryRegion().getCell());
                cellModel.setSelectedItem(((CellUI)this.inputContentUI).getBean());
            }
            ((CellUI)this.inputContentUI).fieldCell.setModel(cellModel);
            this.init = false;
            ((CellUI)this.inputContentUI).getCellMap().setFisheryRegion(((CellUI)this.inputContentUI).getContextValue(FisheryRegion.class));
        });
    }

    protected void fieldCellChanged(ItemEvent event) {
        if (!this.init && event.getStateChange() == 1) {
            Cell c = (Cell)((CellUI)this.inputContentUI).fieldCell.getSelectedItem();
            if (c == null) {
                return;
            }
            Cell oldC = ((CellUI)this.inputContentUI).getBean();
            if (oldC != null && c.getTopiaId().equals(oldC.getTopiaId())) {
                return;
            }
            InputUI inputUI = ((CellUI)this.inputContentUI).getParentContainer(InputUI.class);
            if (inputUI != null) {
                inputUI.getHandler().setTreeSelection(this.inputContentUI, c.getTopiaId());
            } else {
                SensitivityInputUI sensitivityInputUI = ((CellUI)this.inputContentUI).getParentContainer(SensitivityInputUI.class);
                sensitivityInputUI.getHandler().setTreeSelection(this.inputContentUI, c.getTopiaId());
            }
        }
    }
}

