/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.map;

import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import fr.ifremer.isisfish.map.Coordinate;
import fr.ifremer.isisfish.map.DataMap;
import fr.ifremer.isisfish.map.DataMapInfo;
import fr.ifremer.isisfish.map.DefaultScale;
import fr.ifremer.isisfish.map.Motif;
import fr.ifremer.isisfish.map.Scale;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataMapList
implements Serializable {
    private static final long serialVersionUID = 7147651962434190318L;
    private static Log log = LogFactory.getLog(DataMapList.class);
    protected Motif motif;
    protected DataMapInfo info;
    protected Vector<DataMap> dataMap = new Vector();
    protected Scale scale;

    public DataMapList() {
        this(new Motif(), new DataMapInfo());
    }

    public DataMapList(Motif motif) {
        this(motif, new DataMapInfo());
    }

    public DataMapList(Motif motif, DataMapInfo info) {
        this.motif = motif;
        this.info = info;
    }

    public void addDataMap(DataMap data) {
        this.dataMap.add(data);
    }

    public Enumeration<DataMap> getDataMaps() {
        return this.dataMap.elements();
    }

    public List<DataMap> getDataMaps(Coordinate c) {
        ArrayList<DataMap> v = new ArrayList<DataMap>();
        for (DataMap aDataMap : this.dataMap) {
            DataMap dm = aDataMap;
            if (!this.contains(dm, c)) continue;
            v.add(dm);
        }
        return v;
    }

    public boolean contains(DataMap dm, Coordinate c) {
        Coordinate[] coord;
        for (Coordinate aCoord : coord = dm.getCoordinates()) {
            if (!(aCoord.y <= c.y) || !(c.y < aCoord.y + this.motif.getWidth()) || !(aCoord.x <= c.x) || !(c.x < aCoord.x + this.motif.getHeight())) continue;
            return true;
        }
        return false;
    }

    public Motif getMotif() {
        return this.motif;
    }

    public void setMotif(Motif v) {
        this.motif = v;
    }

    public DataMapInfo getInfo() {
        return this.info;
    }

    public void setInfo(DataMapInfo v) {
        this.info = v;
    }

    public Scale getScale() {
        return this.scale;
    }

    public void setScale(Scale v) {
        this.scale = v;
    }

    public double getMaxDataMapValue() {
        double max = 0.0;
        Enumeration<DataMap> enu = this.dataMap.elements();
        while (enu.hasMoreElements()) {
            max = Math.max(max, enu.nextElement().getValue());
        }
        return max;
    }

    public double getMinDataMapValue() {
        double min = 0.0;
        Enumeration<DataMap> enu = this.dataMap.elements();
        while (enu.hasMoreElements()) {
            min = Math.min(min, enu.nextElement().getValue());
        }
        return min;
    }

    public double getPositiveMinDataMapValue() {
        double min = 0.0;
        Enumeration<DataMap> enu = this.dataMap.elements();
        while (enu.hasMoreElements()) {
            double tmp = Math.min(min, enu.nextElement().getValue());
            if (tmp > 0.0) {
                min = tmp;
                continue;
            }
            if (!log.isErrorEnabled()) continue;
            log.error((Object)"getPositiveMinDataMapValue: error negative value encountered");
        }
        return min;
    }

    public OMGraphicList createOMGraphicList(Projection proj) {
        OMGraphicList omlist = new OMGraphicList();
        if (this.getMaxDataMapValue() > 0.0) {
            Motif motif = this.getMotif();
            Scale scale = this.getScale();
            if (scale == null) {
                scale = new DefaultScale(this.getMaxDataMapValue());
            }
            Enumeration<DataMap> enu = this.getDataMaps();
            while (enu.hasMoreElements()) {
                DataMap datamap = enu.nextElement();
                motif.createOMDataMap(proj, omlist, scale, datamap);
            }
        }
        return omlist;
    }
}

