/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.vcs;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.KeyPair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class VCSGenerateSshKeyUI
extends JDialog
implements JAXXObject {
    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAA/6WUz08TQRTHp5VSyg8FChURIgLReHCrMdEYCAIlRbAqWiTEXpzuTtvB6e46MwuLB+Of4J+gdy8m3jwZD549eDH+C8Z48Gp8s922LCylSXvYbee993nf9zrvvf+FYoKjizvYdTXumJJWiba+tL39sLhDdLlChM6pLS2Oap9IFEULqM9onAuJZgo5FZ72w9MZq2pbJjEPRM/lUK+Q+4yICiFSoslghC5EOt8wz7m2w+vUhqgw6ts/v6NvjNfvogi5NqgbgFKmTopqVtKVQ1FqSDQMmXZxmmGzDDI4Ncugd0CdZRgW4gGukhfoFYrnULeNOcAkmm6/ZI/hxbu2RInZ9RWKmVW+JpFW4hotcVIl8BZUlKioaA7VdnWhbWXyq8QkHEuSF5V7ZP/Jmm17mG6J4rObuMgIIMYC1Yo90K55NuWZaAT0zK7ncJEwiBhWdbm+a+1UOfU3fEcE4buEb3C6C8khc5YyIlEqELdJXJmlhBnB2Hqe6+r3UNCW9LlOkVHdxyrTSNBt1HeDpm1UOBakIfEQb/Cwo0TjAY3KsmdxI0TnRC02Y5klyqsn5zp7jL8yTx5pwQY2Q1rtnQZ9o9Zz6EvAa9mR0jKVfbrh1q9jUydsSZe0Zrrs2zk6H/j/YY605hw1L3qkgGLcgWO4MIWjo/cYTLWhGzs0dAroWf+lkt8//fyYrU/aMOQeDXU9sChgAmxu2YRLqlKfqY2ZIylL38f2XAElBGGwZbwtMhEiLO+bQRzkG1LhmgrX7mJRAUQs/uPzl9Szb6dQNIt6mYWNLFb+ayghKxy6YDHDte8seor693rgOai0SRSrWgZm8BfNU5NRk0xhCYNfdCRZcKEPEyF9aIgpJr7+TeY/LNZ7EQFt5451b/Yj9hR117J5e8dfKaF7ps8WxDGs5uoIWyYR9e61/bWQ9p43QouVVNZm7abrqNctT7X6drttSJeEkW/BGGyDEdct5lRN0QKTbAPTQwwq60uuA06iZJnyqqAvOwV1VwgtV1p152SKOl5uQUi1RVhtQRhri5DrmPCoY8JWx4RWnRzvmHChnTvB8L4FyxydnjewxFNFahqw4RfCiTPtTA8x1aU3Wgi71HFpnROuAOE/oZJ6bVcKAAA=";
    private static final Log log = LogFactory.getLog(VCSGenerateSshKeyUI.class);
    private static final long serialVersionUID = 1L;
    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();
    protected JButton cancelAction;
    protected JButton ok;
    protected JPasswordField serverConfirmPassPhrase;
    protected JLabel serverConfirmPassPhraseLabel;
    protected JPasswordField serverPassPhrase;
    protected JLabel serverPassPhraseLabel;
    protected JTextField serverPrivateKeyFile;
    protected JTextField serverPublicKeyFile;
    private VCSGenerateSshKeyUI $JDialog0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JPanel $JPanel0;
    private Table $Table0;
    private static VCSGenerateSshKeyUI instance;
    public boolean cancel;
    public boolean noPassPhrase;
    public Exception error;
    protected boolean invalidPassPhrase;
    protected String vcsLogin;

    public static VCSGenerateSshKeyUI getInstance(JDialog parent) {
        if (instance == null) {
            instance = new VCSGenerateSshKeyUI(parent);
        }
        return instance;
    }

    public void setData(String vcsLogin, File privateKeyFile) {
        this.vcsLogin = vcsLogin;
        this.serverPrivateKeyFile.setText(privateKeyFile.getAbsolutePath());
        this.serverPublicKeyFile.setText(privateKeyFile.getAbsolutePath() + ".pub");
        this.noPassPhrase = true;
        this.error = null;
        this.doCheck();
    }

    protected boolean doGenerate() {
        File privateKeyFile = new File(this.getServerPrivateKeyFile().getText());
        File publicKeyFile = new File(this.serverPublicKeyFile.getText());
        if (privateKeyFile.getParentFile() != null && !privateKeyFile.getParentFile().exists()) {
            privateKeyFile.getParentFile().mkdirs();
        }
        try {
            char[] password = this.getServerPassPhrase().getPassword();
            JSch jsch = new JSch();
            KeyPair kpair = KeyPair.genKeyPair((JSch)jsch, (int)2, (int)2048);
            if (password.length > 0) {
                String strPassphase = Arrays.toString(password);
                byte[] bytPassphrase = strPassphase.getBytes(StandardCharsets.UTF_8);
                kpair.writePrivateKey(privateKeyFile.getAbsolutePath(), bytPassphrase);
            } else {
                kpair.writePrivateKey(privateKeyFile.getAbsolutePath());
            }
            kpair.writePublicKey(publicKeyFile.getAbsolutePath(), this.vcsLogin + "@forIsisFish");
            if (log.isInfoEnabled()) {
                log.info((Object)("Finger print: " + kpair.getFingerPrint()));
            }
            kpair.dispose();
        }
        catch (Exception e) {
            this.error = e;
            return true;
        }
        return false;
    }

    protected boolean check() {
        this.invalidPassPhrase = !Arrays.equals(this.serverPassPhrase.getPassword(), this.serverConfirmPassPhrase.getPassword());
        return !this.invalidPassPhrase;
    }

    protected void doCheck() {
        this.ok.setEnabled(this.check());
        this.setColor(this.invalidPassPhrase, this.serverPassPhraseLabel);
        this.setColor(this.invalidPassPhrase, this.serverConfirmPassPhraseLabel);
    }

    protected void setColor(boolean invalid, JComponent component) {
        component.setForeground(invalid ? Color.red : Color.black);
    }

    private VCSGenerateSshKeyUI(JDialog instance) {
        super(instance);
        this.setDefaultCloseOperation(0);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0, param1, param2, param3);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1, param2, param3, param4);
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(Frame param0, String param1, boolean param2) {
        super(param0, param1, param2);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1, param2, param3);
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(Dialog param0) {
        super(param0);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(Dialog param0, boolean param1) {
        super(param0, param1);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1, param2);
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI() {
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext) {
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(Frame param0) {
        super(param0);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(Frame param0, boolean param1) {
        super(param0, param1);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1, param2);
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(Frame param0, String param1) {
        super(param0, param1);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1, param2);
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(Window param0, Dialog.ModalityType param1) {
        super(param0, param1);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Window param1, Dialog.ModalityType param2) {
        super(param1, param2);
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(Window param0, String param1) {
        super(param0, param1);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1, param2);
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(Window param0, String param1, Dialog.ModalityType param2) {
        super(param0, param1, param2);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Window param1, String param2, Dialog.ModalityType param3) {
        super(param1, param2, param3);
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(Window param0, String param1, Dialog.ModalityType param2, GraphicsConfiguration param3) {
        super(param0, param1, param2, param3);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Window param1, String param2, Dialog.ModalityType param3, GraphicsConfiguration param4) {
        super(param1, param2, param3, param4);
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(Dialog param0, String param1) {
        super(param0, param1);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1, param2);
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(Dialog param0, String param1, boolean param2) {
        super(param0, param1, param2);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1, param2, param3);
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0, param1, param2, param3);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1, param2, param3, param4);
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(Window param0) {
        super(param0);
        this.$initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor((String)$jaxxObjectDescriptor);
    }

    public void applyDataBinding(String $binding) {
        if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
            this.getDataBinding($binding).applyDataBinding();
        }
        this.processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String, Object> get$objectMap() {
        return this.$objectMap;
    }

    public JAXXBinding getDataBinding(String bindingId) {
        return this.$bindings.get(bindingId);
    }

    public JAXXBinding[] getDataBindings() {
        return this.$bindings.values().toArray(new JAXXBinding[this.$bindings.size()]);
    }

    public Object getObjectById(String id) {
        return this.$objectMap.get(id);
    }

    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && this.$activeBindings.contains($binding)) {
            return;
        }
        this.$activeBindings.add($binding);
        try {
            if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
                this.getDataBinding($binding).processDataBinding();
            }
        }
        finally {
            this.$activeBindings.remove($binding);
        }
    }

    public void processDataBinding(String $binding) {
        this.processDataBinding($binding, false);
    }

    public void registerDataBinding(JAXXBinding binding) {
        this.$bindings.put(binding.getId(), binding);
    }

    public void removeDataBinding(String $binding) {
        if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
            this.getDataBinding($binding).removeDataBinding();
        }
    }

    public <T> T getContextValue(Class<T> clazz) {
        return (T)this.delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return (T)this.delegateContext.getContextValue(clazz, name);
    }

    public JAXXContext getDelegateContext() {
        return this.delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return (O)SwingUtil.getParentContainer((Object)this, clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return (O)SwingUtil.getParentContainer((Object)source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        this.delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        this.delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        this.delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        this.delegateContext.setContextValue(o, name);
    }

    public void doActionPerformed__on__cancelAction(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.cancel = true;
        this.dispose();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.cancel = this.doGenerate();
        this.dispose();
    }

    public void doKeyReleased__on__serverConfirmPassPhrase(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.doCheck();
    }

    public void doKeyReleased__on__serverPassPhrase(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.doCheck();
    }

    public JButton getCancelAction() {
        return this.cancelAction;
    }

    public JButton getOk() {
        return this.ok;
    }

    public JPasswordField getServerConfirmPassPhrase() {
        return this.serverConfirmPassPhrase;
    }

    public JLabel getServerConfirmPassPhraseLabel() {
        return this.serverConfirmPassPhraseLabel;
    }

    public JPasswordField getServerPassPhrase() {
        return this.serverPassPhrase;
    }

    public JLabel getServerPassPhraseLabel() {
        return this.serverPassPhraseLabel;
    }

    public JTextField getServerPrivateKeyFile() {
        return this.serverPrivateKeyFile;
    }

    public JTextField getServerPublicKeyFile() {
        return this.serverPublicKeyFile;
    }

    protected JLabel get$JLabel0() {
        return this.$JLabel0;
    }

    protected JLabel get$JLabel1() {
        return this.$JLabel1;
    }

    protected JPanel get$JPanel0() {
        return this.$JPanel0;
    }

    protected Table get$Table0() {
        return this.$Table0;
    }

    protected void createCancelAction() {
        this.cancelAction = new JButton();
        this.$objectMap.put("cancelAction", this.cancelAction);
        this.cancelAction.setName("cancelAction");
        this.cancelAction.setText(I18n.t((String)"isisfish.common.cancel", (Object[])new Object[0]));
        this.cancelAction.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__cancelAction"));
    }

    protected void createOk() {
        this.ok = new JButton();
        this.$objectMap.put("ok", this.ok);
        this.ok.setName("ok");
        this.ok.setEnabled(false);
        this.ok.setText(I18n.t((String)"isisfish.common.apply", (Object[])new Object[0]));
        this.ok.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__ok"));
    }

    protected void createServerConfirmPassPhrase() {
        this.serverConfirmPassPhrase = new JPasswordField();
        this.$objectMap.put("serverConfirmPassPhrase", this.serverConfirmPassPhrase);
        this.serverConfirmPassPhrase.setName("serverConfirmPassPhrase");
        this.serverConfirmPassPhrase.setColumns(15);
        this.serverConfirmPassPhrase.addKeyListener((KeyListener)JAXXUtil.getEventListener(KeyListener.class, (String)"keyReleased", (Object)this, (String)"doKeyReleased__on__serverConfirmPassPhrase"));
    }

    protected void createServerConfirmPassPhraseLabel() {
        this.serverConfirmPassPhraseLabel = new JLabel();
        this.$objectMap.put("serverConfirmPassPhraseLabel", this.serverConfirmPassPhraseLabel);
        this.serverConfirmPassPhraseLabel.setName("serverConfirmPassPhraseLabel");
        this.serverConfirmPassPhraseLabel.setText(I18n.t((String)"isisfish.launch.server.ssh.confirm.passphrase", (Object[])new Object[0]));
    }

    protected void createServerPassPhrase() {
        this.serverPassPhrase = new JPasswordField();
        this.$objectMap.put("serverPassPhrase", this.serverPassPhrase);
        this.serverPassPhrase.setName("serverPassPhrase");
        this.serverPassPhrase.setColumns(15);
        this.serverPassPhrase.addKeyListener((KeyListener)JAXXUtil.getEventListener(KeyListener.class, (String)"keyReleased", (Object)this, (String)"doKeyReleased__on__serverPassPhrase"));
    }

    protected void createServerPassPhraseLabel() {
        this.serverPassPhraseLabel = new JLabel();
        this.$objectMap.put("serverPassPhraseLabel", this.serverPassPhraseLabel);
        this.serverPassPhraseLabel.setName("serverPassPhraseLabel");
        this.serverPassPhraseLabel.setText(I18n.t((String)"isisfish.launch.server.ssh.passphrase", (Object[])new Object[0]));
    }

    protected void createServerPrivateKeyFile() {
        this.serverPrivateKeyFile = new JTextField();
        this.$objectMap.put("serverPrivateKeyFile", this.serverPrivateKeyFile);
        this.serverPrivateKeyFile.setName("serverPrivateKeyFile");
        this.serverPrivateKeyFile.setColumns(15);
        this.serverPrivateKeyFile.setColumns(28);
        this.serverPrivateKeyFile.setEditable(false);
        if (this.serverPrivateKeyFile.getFont() != null) {
            this.serverPrivateKeyFile.setFont(this.serverPrivateKeyFile.getFont().deriveFont(12.0f));
        }
        SwingUtil.setComponentHeight((Component)this.serverPrivateKeyFile, (int)25);
    }

    protected void createServerPublicKeyFile() {
        this.serverPublicKeyFile = new JTextField();
        this.$objectMap.put("serverPublicKeyFile", this.serverPublicKeyFile);
        this.serverPublicKeyFile.setName("serverPublicKeyFile");
        this.serverPublicKeyFile.setColumns(15);
        this.serverPublicKeyFile.setColumns(28);
        this.serverPublicKeyFile.setEditable(false);
        if (this.serverPublicKeyFile.getFont() != null) {
            this.serverPublicKeyFile.setFont(this.serverPublicKeyFile.getFont().deriveFont(12.0f));
        }
        SwingUtil.setComponentHeight((Component)this.serverPublicKeyFile, (int)25);
    }

    private void $completeSetup() {
        this.allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.add((Component)this.$Table0);
        this.$Table0.add((Component)this.$JLabel0, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.serverPrivateKeyFile, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.$JLabel1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.serverPublicKeyFile, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.serverPassPhraseLabel, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.serverPassPhrase, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.serverConfirmPassPhraseLabel, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.serverConfirmPassPhrase, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.$JPanel0, (Object)new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$JPanel0.add(this.ok);
        this.$JPanel0.add(this.cancelAction);
        this.$JDialog0.pack();
    }

    private void $initialize() {
        if (this.allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.$objectMap.put("$JDialog0", this.$JDialog0);
        this.$Table0 = new Table();
        this.$objectMap.put("$Table0", this.$Table0);
        this.$Table0.setName("$Table0");
        this.$JLabel0 = new JLabel();
        this.$objectMap.put("$JLabel0", this.$JLabel0);
        this.$JLabel0.setName("$JLabel0");
        this.$JLabel0.setText(I18n.t((String)"isisfish.launch.server.ssh.privateKeyFile", (Object[])new Object[0]));
        this.createServerPrivateKeyFile();
        this.$JLabel1 = new JLabel();
        this.$objectMap.put("$JLabel1", this.$JLabel1);
        this.$JLabel1.setName("$JLabel1");
        this.$JLabel1.setText(I18n.t((String)"isisfish.launch.server.ssh.publicKeyFile", (Object[])new Object[0]));
        this.createServerPublicKeyFile();
        this.createServerPassPhraseLabel();
        this.createServerPassPhrase();
        this.createServerConfirmPassPhraseLabel();
        this.createServerConfirmPassPhrase();
        this.$JPanel0 = new JPanel();
        this.$objectMap.put("$JPanel0", this.$JPanel0);
        this.$JPanel0.setName("$JPanel0");
        this.$JPanel0.setLayout(new GridLayout(0, 2, 2, 2));
        this.createOk();
        this.createCancelAction();
        this.setName("$JDialog0");
        this.setModal(true);
        this.setTitle(I18n.t((String)"isisfish.server.ssh.generateKey.title", (Object[])new Object[0]));
        this.$completeSetup();
    }
}

