/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.simulator;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.ResultInfoStorage;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.SimulationParameterImpl;
import fr.ifremer.isisfish.simulator.sensitivity.FactorGroup;
import java.util.LinkedHashMap;
import java.util.List;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;

public class SimulatorContext
extends DefaultJAXXContext {
    private static final Log log = LogFactory.getLog(SimulatorContext.class);
    protected static TopiaContext db;

    public SimulatorContext(JAXXContext parent) {
        this.setParentContext(parent);
        this.initDefaultParameters();
        this.initFactorGroup();
        this.setSimulatorContext(this);
    }

    public static TopiaContext getDb() {
        return db;
    }

    public static void setDb(TopiaContext db) {
        SimulatorContext.db = db;
    }

    public void setSimulationParameter(SimulationParameter param) {
        this.setContextValue(param);
    }

    public void setFactorGroup(FactorGroup factorGroup) {
        this.setContextValue(factorGroup);
    }

    public void setRegionStorage(RegionStorage regionStorage) {
        this.setContextValue(regionStorage);
    }

    public void setSimulatorContext(SimulatorContext simulatorContext) {
        this.setContextValue((Object)simulatorContext, "SimulatorContext");
    }

    public void initDefaultParameters() {
        SimulationParameterImpl param = new SimulationParameterImpl();
        param.setSimulatorName(IsisFish.config.getSimulatorClassfile());
        param.setExportNames(IsisFish.config.getDefaultExportNamesAsList());
        List<String> defaultResultNames = IsisFish.config.getDefaultResultNamesAsList();
        if (defaultResultNames != null) {
            param.setResultEnabled(defaultResultNames);
        } else {
            List<String> allResultNames = ResultInfoStorage.getResultInfoNames();
            param.setResultEnabled(allResultNames);
        }
        LinkedHashMap<String, String> tv = new LinkedHashMap<String, String>();
        tv.putAll(IsisFish.config.getDefaultTagValueAsMap());
        tv.putAll(IsisFish.config.getDefaultSimulationConfig());
        param.setTagValue(tv);
        this.setSimulationParameter(param);
    }

    protected void initFactorGroup() {
        FactorGroup factorGroup = new FactorGroup(null);
        this.setContextValue(factorGroup);
    }
}

