/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.StorageChangeListener;
import fr.ifremer.isisfish.vcs.VCSException;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.collections4.map.ReferenceMap;

public class SensitivityExportStorage
extends ExportStorage {
    public static final String SENSITIVITY_EXPORT_PATH = "sensitivityexports";
    public static final String SENSITIVITY_EXPORT_TEMPLATE = "templates/script/sensitivityexport.ftl";
    protected static Map<String, SensitivityExportStorage> sensitivityExportsCache = new ReferenceMap();
    protected static Set<StorageChangeListener> storageListeners = Collections.newSetFromMap(new WeakHashMap());

    public static void addStorageListener(StorageChangeListener storageListener) {
        storageListeners.add(storageListener);
    }

    public static void registerWatcher() {
        SensitivityExportStorage.registerWatcher(storageListeners, SensitivityExportStorage.getSensitivityExportDirectory(), SensitivityExportStorage.getCommunitySensitivityExportDirectory());
    }

    protected SensitivityExportStorage(File rootSrc, File directory, String name) {
        super(rootSrc, directory, name);
    }

    @Override
    public String getPackage() {
        return SENSITIVITY_EXPORT_PATH;
    }

    public static File getSensitivityExportDirectory() {
        File result = new File(SensitivityExportStorage.getContextDatabaseDirectory(), SENSITIVITY_EXPORT_PATH);
        result.mkdirs();
        return result;
    }

    public static File getCommunitySensitivityExportDirectory() {
        File result = new File(SensitivityExportStorage.getCommunityDatabaseDirectory(), SENSITIVITY_EXPORT_PATH);
        result.mkdirs();
        return result;
    }

    public static SensitivityExportStorage getSensitivityExport(String name, CodeSourceStorage.Location ... location) {
        SensitivityExportStorage result = sensitivityExportsCache.get(name);
        if (result == null) {
            CodeSourceStorage.Location loc = SensitivityExportStorage.nonEmptyLocation(location);
            for (File dir : loc.getDirectories()) {
                SensitivityExportStorage storage = new SensitivityExportStorage(dir, new File(dir, SENSITIVITY_EXPORT_PATH), name);
                if (!storage.getFile().isFile()) continue;
                result = storage;
                sensitivityExportsCache.put(name, result);
            }
        }
        return result;
    }

    public static SensitivityExportStorage createSensitivityExport(String name, CodeSourceStorage.Location location) {
        File dir = location.getDirectories()[0];
        SensitivityExportStorage storage = new SensitivityExportStorage(dir, new File(dir, SENSITIVITY_EXPORT_PATH), name);
        return storage;
    }

    public static List<String> getSensitivityExportNames() {
        List<String> result = SensitivityExportStorage.getStorageNames(SensitivityExportStorage.getSensitivityExportDirectory());
        result.addAll(SensitivityExportStorage.getStorageNames(SensitivityExportStorage.getCommunitySensitivityExportDirectory()));
        return result;
    }

    public static void checkout() throws VCSException {
        SensitivityExportStorage.checkout(IsisFish.config.getDatabaseDirectory(), SENSITIVITY_EXPORT_PATH);
    }
}

