/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.sensitivity;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.SensitivityAnalysisStorage;
import fr.ifremer.isisfish.datastore.SensitivityExportStorage;
import fr.ifremer.isisfish.datastore.StorageChangeEvent;
import fr.ifremer.isisfish.datastore.StorageChangeListener;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.FactorGroup;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityAnalysis;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.ui.models.common.GenericListModel;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersParamModel;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersParamNameRenderer;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersParamValueEditor;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersParamValueRenderer;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityChooserUI;
import fr.ifremer.isisfish.ui.sensitivity.model.FactorCardinalityTableModel;
import fr.ifremer.isisfish.ui.widget.editor.ScriptParameterDialog;
import java.awt.CardLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SensitivityChooserHandler {
    private static final Log log = LogFactory.getLog(SensitivityChooserHandler.class);
    protected SensitivityChooserUI sensitivityChooserUI;
    protected StorageChangeListener sensitivityAnalysisListener;
    protected StorageChangeListener sensitivityExportListener;

    public SensitivityChooserHandler(SensitivityChooserUI sensitivityChooserUI) {
        this.sensitivityChooserUI = sensitivityChooserUI;
    }

    @Deprecated
    protected SimulationParameter getParameters() {
        return this.sensitivityChooserUI.getContextValue(SimulationParameter.class);
    }

    @Deprecated
    protected FactorGroup getFactorGroup() {
        return this.sensitivityChooserUI.getContextValue(FactorGroup.class);
    }

    protected void initSensitivityAnalysisModel(StorageChangeEvent evt) {
        this.sensitivityChooserUI.sensitivityAnalysisModel.setElementList(this.getSensitivityAnalysisNames());
    }

    protected void initAvailableExportListModel(StorageChangeEvent evt) {
        this.sensitivityChooserUI.availableExportListModel.setElementList(this.getSensitivityExportNames());
    }

    protected void afterInit() {
        this.sensitivityAnalysisListener = this::initSensitivityAnalysisModel;
        SensitivityAnalysisStorage.addStorageListener(this.sensitivityAnalysisListener);
        this.initSensitivityAnalysisModel(null);
        this.sensitivityExportListener = this::initAvailableExportListModel;
        SensitivityExportStorage.addStorageListener(this.sensitivityExportListener);
        this.initAvailableExportListModel(null);
    }

    public void refreshSelectedSensitivityAnalysis() {
        SensitivityAnalysis sensitivityAnalysis = this.getSensitivityAnalysis();
        if (sensitivityAnalysis != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Refreshing sensitivity analysis list");
            }
            this.sensitivityChooserUI.fieldSensitivityAnalysisSelect.setSelectedItem(sensitivityAnalysis.getClass().getSimpleName());
        }
    }

    protected void sensitivityAnalysisChanged() {
        String sensitivityName = (String)this.sensitivityChooserUI.fieldSensitivityAnalysisSelect.getSelectedItem();
        if (sensitivityName == null) {
            return;
        }
        SensitivityAnalysis sensitivityAnalysis = this.getSensitivityAnalysis();
        sensitivityAnalysis = sensitivityAnalysis != null && sensitivityAnalysis.getClass().getSimpleName().equals(sensitivityName) ? this.getSensitivityAnalysis() : this.getSensitivityAnalysisInstance(sensitivityName);
        if (sensitivityAnalysis != null) {
            this.setSensitivityAnalysis(sensitivityAnalysis);
            CardLayout factorPanelLayout = (CardLayout)this.sensitivityChooserUI.factorCardinalityPanel.getLayout();
            if (sensitivityAnalysis.canManageCardinality()) {
                factorPanelLayout.show(this.sensitivityChooserUI.factorCardinalityPanel, "factorCardinalitySupported");
            } else {
                factorPanelLayout.show(this.sensitivityChooserUI.factorCardinalityPanel, "factorCardinalityNotSupported");
            }
            ScriptParametersParamModel parametersTableModel = new ScriptParametersParamModel(sensitivityAnalysis);
            this.sensitivityChooserUI.simulSensitivityAnalysisParam.setModel(parametersTableModel);
            ScriptParametersParamNameRenderer nameRenderer = new ScriptParametersParamNameRenderer(sensitivityAnalysis);
            this.sensitivityChooserUI.simulSensitivityAnalysisParam.getColumnModel().getColumn(0).setCellRenderer(nameRenderer);
            ScriptParametersParamValueRenderer valueRenderer = new ScriptParametersParamValueRenderer();
            this.sensitivityChooserUI.simulSensitivityAnalysisParam.getColumnModel().getColumn(1).setCellRenderer(valueRenderer);
            this.sensitivityChooserUI.simulSensitivityAnalysisParam.getColumnModel().getColumn(1).setCellEditor(new ScriptParametersParamValueEditor(sensitivityAnalysis));
        }
    }

    public void setFactorCardinalityTableModel() {
        List<Factor> factors = this.getFactorGroup().getFactors();
        ArrayList<Factor> factorsContinue = new ArrayList<Factor>();
        for (Factor f : factors) {
            Domain domain = f.getDomain();
            if (!(domain instanceof ContinuousDomain)) continue;
            factorsContinue.add(f);
        }
        FactorCardinalityTableModel model = new FactorCardinalityTableModel(factorsContinue);
        this.sensitivityChooserUI.factorCardinality.setModel(model);
    }

    protected void addExports() {
        List<String> exportNames = this.sensitivityChooserUI.availableSensitivityExports.getSelectedValuesList();
        for (String exportName : exportNames) {
            this.addSensitivityExport(this.sensitivityChooserUI, exportName);
        }
        this.setSensitivityExportListModel();
    }

    protected void removeExports() {
        List<SensitivityExport> exports = this.sensitivityChooserUI.selectedSensitivityExports.getSelectedValuesList();
        for (SensitivityExport export : exports) {
            this.removeSensitivityExport(export);
        }
        this.setSensitivityExportListModel();
    }

    public void duplicateExports() {
        List<SensitivityExport> exports = this.sensitivityChooserUI.selectedSensitivityExports.getSelectedValuesList();
        for (SensitivityExport export : exports) {
            SensitivityExport e = (SensitivityExport)JavaSourceStorage.clone(export);
            this.getParameters().getSensitivityExport().add(e);
        }
        this.setSensitivityExportListModel();
    }

    public void setSensitivityExportListModel() {
        List<SensitivityExport> exports = this.getSensitivityExports();
        GenericListModel<SensitivityExport> model = new GenericListModel<SensitivityExport>(exports);
        this.sensitivityChooserUI.selectedSensitivityExports.setModel(model);
    }

    protected void availableSensitivityExportSelection() {
        this.sensitivityChooserUI.addExportButton.setEnabled(this.sensitivityChooserUI.availableSensitivityExports.getSelectedIndices().length != 0);
    }

    protected void selectedSensitivityExportSelection() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Sensitivity export selection change");
        }
        this.setExportParams();
        this.sensitivityChooserUI.removeExportButton.setEnabled(this.sensitivityChooserUI.selectedSensitivityExports.getSelectedIndices().length != 0);
        this.sensitivityChooserUI.duplicateExportButton.setEnabled(this.sensitivityChooserUI.selectedSensitivityExports.getSelectedIndices().length != 0);
    }

    protected void setExportParams() {
        if (this.sensitivityChooserUI.selectedSensitivityExports.getSelectedIndices().length == 1) {
            SensitivityExport export = this.sensitivityChooserUI.selectedSensitivityExports.getSelectedValue();
            ScriptParametersParamModel model = new ScriptParametersParamModel(export);
            this.sensitivityChooserUI.exportParamsTable.setModel(model);
            ScriptParametersParamNameRenderer nameRenderer = new ScriptParametersParamNameRenderer(export);
            this.sensitivityChooserUI.exportParamsTable.getColumnModel().getColumn(0).setCellRenderer(nameRenderer);
            ScriptParametersParamValueRenderer valueRenderer = new ScriptParametersParamValueRenderer();
            this.sensitivityChooserUI.exportParamsTable.getColumnModel().getColumn(1).setCellRenderer(valueRenderer);
            ScriptParametersParamValueEditor cellEditor = new ScriptParametersParamValueEditor(export);
            cellEditor.setRegionStorage(this.sensitivityChooserUI.getContextValue(RegionStorage.class));
            this.sensitivityChooserUI.exportParamsTable.getColumnModel().getColumn(1).setCellEditor(cellEditor);
        } else {
            this.sensitivityChooserUI.exportParamsTable.setModel(new DefaultTableModel());
        }
    }

    protected List<String> getSensitivityExportNames() {
        List<String> exportNames = SensitivityExportStorage.getSensitivityExportNames();
        ArrayList<String> result = new ArrayList<String>(exportNames);
        return result;
    }

    public List<SensitivityExport> getSensitivityExports() {
        List<SensitivityExport> result = this.getParameters().getSensitivityExport();
        return result;
    }

    public void addSensitivityExport(SensitivityChooserUI sensitivityChooserUI, String name) {
        block3: {
            try {
                SensitivityExportStorage storage = SensitivityExportStorage.getSensitivityExport(name, new CodeSourceStorage.Location[0]);
                SensitivityExport sensitivityExport = (SensitivityExport)storage.getNewInstance();
                sensitivityExport = (SensitivityExport)ScriptParameterDialog.displayConfigurationFrame((JAXXContext)sensitivityChooserUI, sensitivityExport);
                if (sensitivityExport != null) {
                    this.getParameters().getSensitivityExport().add(sensitivityExport);
                }
            }
            catch (IsisFishException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Can't add sensitivity export", (Throwable)e);
            }
        }
    }

    public void removeSensitivityExport(SensitivityExport export) {
        this.getParameters().getSensitivityExport().remove(export);
    }

    protected List<String> getSensitivityAnalysisNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (String r : SensitivityAnalysisStorage.getSensitivityAnalysisNames()) {
            if (!r.endsWith(".java")) continue;
            result.add(r.substring(0, r.length() - 5));
        }
        return result;
    }

    public SensitivityAnalysis getSensitivityAnalysis() {
        return this.getParameters().getSensitivityAnalysis();
    }

    public SensitivityAnalysis getSensitivityAnalysisInstance(String name) {
        SensitivityAnalysis sensitivityAnalysis;
        block2: {
            sensitivityAnalysis = null;
            try {
                SensitivityAnalysisStorage sensitivityStorage = SensitivityAnalysisStorage.getSensitivityAnalysis(name, new CodeSourceStorage.Location[0]);
                sensitivityAnalysis = (SensitivityAnalysis)sensitivityStorage.getNewInstance();
            }
            catch (IsisFishException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't set sensitivity analysis", (Throwable)e);
            }
        }
        return sensitivityAnalysis;
    }

    public void setSensitivityAnalysis(SensitivityAnalysis sensitivityAnalysis) {
        this.getParameters().setSensitivityAnalysis(sensitivityAnalysis);
    }
}

