/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.observation;

import fr.ifremer.isisfish.entities.Observation;
import fr.ifremer.isisfish.ui.input.InputContentHandler;
import fr.ifremer.isisfish.ui.input.observation.ObservationUI;
import fr.ifremer.isisfish.util.ErrorHelper;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.runtime.JaxxFileChooser;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;

public class ObservationHandler
extends InputContentHandler<ObservationUI> {
    private static final Log log = LogFactory.getLog(ObservationHandler.class);

    protected ObservationHandler(ObservationUI inputContentUI) {
        super(inputContentUI);
    }

    protected void afterInit() {
        ((ObservationUI)this.inputContentUI).addPropertyChangeListener("bean", evt -> {
            if (evt.getNewValue() == null) {
                ((ObservationUI)this.inputContentUI).fieldObservationValue.setMatrix(null);
            }
            if (evt.getNewValue() != null) {
                this.setObservationValueMatrix();
            }
        });
    }

    protected void setObservationValueMatrix() {
        MatrixND prop = ((ObservationUI)this.inputContentUI).getBean().getValue();
        if (prop != null) {
            ((ObservationUI)this.inputContentUI).fieldObservationValue.setMatrix(prop.copy());
        } else {
            ((ObservationUI)this.inputContentUI).fieldObservationValue.setMatrix(null);
        }
    }

    protected void createObservationValueMatrix() {
        this.createObservationValueMatrix(((ObservationUI)this.inputContentUI).getBean());
        this.setObservationValueMatrix();
    }

    public void loadObservationValueMatrix() {
        try {
            File file;
            Observation observation = ((ObservationUI)this.inputContentUI).getBean();
            if (observation != null && (file = JaxxFileChooser.forLoadingFile().setApprovalText(I18n.t((String)"isisfish.common.ok", (Object[])new Object[0])).setPatternOrDescriptionFilters(".*\\.csv", "MatrixND csv file", new String[0]).setUseAcceptAllFileFilter(true).choose()) != null) {
                MatrixND newMat = MatrixFactory.getInstance().create(file);
                observation.setValue(newMat);
                observation.update();
                this.setObservationValueMatrix();
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't load matrix observation", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.matrix.load", (Object[])new Object[0]), eee);
        }
    }

    public void createObservationValueMatrix(Observation observation) {
        try {
            String val = JOptionPane.showInputDialog(this.inputContentUI, I18n.t((String)"isisfish.message.observation.value.dimensions", (Object[])new Object[0]), I18n.t((String)"isisfish.common.newMatrix", (Object[])new Object[0]), 3);
            if (StringUtils.isNotBlank((CharSequence)val)) {
                String[] values = val.trim().split("(,|;|\\*|x|\\s)");
                ArrayList<Integer> dims = new ArrayList<Integer>();
                for (String value : values) {
                    if (value.isEmpty() || !StringUtils.isNumeric((CharSequence)value)) continue;
                    dims.add(Integer.valueOf(value));
                }
                int[] dim = new int[dims.size()];
                for (int i = 0; i < dims.size(); ++i) {
                    dim[i] = (Integer)dims.get(i);
                }
                MatrixND newMat = MatrixFactory.getInstance().create(dim);
                MatrixND mat = observation.getValue();
                if (mat != null) {
                    newMat.paste(mat);
                }
                observation.setValue(newMat);
                observation.update();
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't create matrix", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.matrix.create", (Object[])new Object[0]), eee);
        }
    }

    protected void observationValueMatrixChanged(MatrixPanelEvent event) {
        MatrixND mat = ((ObservationUI)this.inputContentUI).fieldObservationValue.getMatrix();
        if (((ObservationUI)this.inputContentUI).getBean() != null && mat != null) {
            ((ObservationUI)this.inputContentUI).getBean().setValue(mat.copy());
        }
    }
}

