/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.simulator.Historic;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.SimulationPlanContext;
import java.util.HashMap;
import java.util.Map;

public class SimulationPlanContextInternal
implements SimulationPlanContext {
    protected String id;
    protected int number = 0;
    protected SimulationParameter param;
    protected Historic historic;
    protected Map<String, Object> values = new HashMap<String, Object>();

    public SimulationPlanContextInternal(String id, SimulationParameter param) {
        this.id = id;
        this.param = param;
        this.historic = new Historic(id);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    public void incNumber() {
        ++this.number;
    }

    @Override
    public SimulationParameter getParam() {
        return this.param;
    }

    @Override
    public Object getValue(String key) {
        return this.values.get(key);
    }

    @Override
    public void setValue(String key, Object value) {
        this.values.put(key, value);
    }

    @Override
    public SimulationStorage getLastSimulation() {
        SimulationStorage result = this.getSimulation(this.getNumber() - 1);
        return result;
    }

    @Override
    public SimulationStorage getSimulation(int number) {
        SimulationStorage result = null;
        if (0 <= number && number <= this.getNumber()) {
            result = SimulationStorage.getSimulation(this.id + "_" + number);
        }
        return result;
    }

    @Override
    public Historic getHistoric() {
        return this.historic;
    }
}

