/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.util.converter.ConverterUtil;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntity;

public class StorageHelper {
    private static final Log log = LogFactory.getLog(StorageHelper.class);

    public static void populateStorageParams(int instanceIndex, TopiaContext context, Object instance, Properties props, String propPrefix) {
        String exportName = JavaSourceStorage.getName(instance);
        String paramTag = propPrefix + "." + instanceIndex + ".parameter.";
        for (Map.Entry<String, Field> entry : JavaSourceStorage.getParameterNamesAndField(instance).entrySet()) {
            String propName = entry.getKey();
            Field field = entry.getValue();
            Class<Object> type = field.getType();
            if (TopiaEntity.class.isAssignableFrom(type)) {
                type = TopiaEntity.class;
            }
            String valueString = "not initialized";
            try {
                valueString = props.getProperty(paramTag + propName);
                ConvertUtilsBean beanUtils = ConverterUtil.getConverter(context);
                Object value = beanUtils.convert(valueString, type);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Set instance param: " + paramTag + propName + " = " + String.valueOf(value) + "(" + valueString + ")"));
                }
                JavaSourceStorage.setParameterValue(instance, propName, value);
            }
            catch (Exception eee) {
                if (!log.isWarnEnabled()) continue;
                log.info((Object)("Properties: " + String.valueOf(props)));
                log.warn((Object)("Can't reload field " + propName + " for export " + exportName + " with value " + valueString), (Throwable)eee);
            }
        }
    }

    public static Properties getParamsAsProperties(int instanceIndex, TopiaContext context, Object instance, String propPrefix) {
        Properties result = new Properties();
        ConvertUtilsBean beanUtils = ConverterUtil.getConverter(context);
        for (String paramName : RuleStorage.getParameterNamesAndField(instance).keySet()) {
            try {
                Object value = RuleStorage.getParameterValue(instance, paramName);
                String paramValueString = beanUtils.convert(value);
                if (paramValueString == null) continue;
                result.setProperty(propPrefix + "." + instanceIndex + ".parameter." + paramName, paramValueString);
            }
            catch (IsisFishException eee) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Can't convert parameter value to String: " + paramName), (Throwable)eee);
            }
        }
        return result;
    }
}

