/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.models.result;

import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ResultInfoStorage;
import fr.ifremer.isisfish.result.ResultInfo;
import fr.ifremer.isisfish.ui.util.RendererHelper;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultInfoNameListRenderer
extends DefaultListCellRenderer {
    private static final Log log = LogFactory.getLog(ResultInfoNameListRenderer.class);
    private static final long serialVersionUID = -4070846632975105788L;
    protected Map<String, ResultInfo> resultNameCache = new HashMap<String, ResultInfo>();

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel c = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        String resultNameName = (String)value;
        String text = null;
        try {
            ResultInfo resultInfo = this.resultNameCache.get(resultNameName);
            if (resultInfo == null) {
                ResultInfoStorage storage = ResultInfoStorage.getResultInfo(resultNameName, new CodeSourceStorage.Location[0]);
                resultInfo = (ResultInfo)storage.getNewInstance();
                this.resultNameCache.put(resultNameName, resultInfo);
            }
            text = RendererHelper.getNameAndDocListString(resultNameName, resultInfo.getDescription());
        }
        catch (Exception ex) {
            text = RendererHelper.getNameAndCompListString(resultNameName);
        }
        c.setText(text);
        return c;
    }
}

