/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.StrategyMonthInfo;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.TimeStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class MetierMonitor {
    private static Log log = LogFactory.getLog(MetierMonitor.class);
    protected Set<Metier> forbiddenMetier = new HashSet<Metier>();
    protected Set<MultiKey<Object>> forbiddenMetierMonth = new HashSet<MultiKey<Object>>();
    protected Map<TimeStep, MatrixND> noActivity = new HashMap<TimeStep, MatrixND>();
    protected MultiKeyMap<Object, Licence> list = new MultiKeyMap();

    public void clear() {
        this.list.clear();
        this.forbiddenMetier.clear();
    }

    public void addforbiddenMetier(Metier metier) {
        this.forbiddenMetier.add(metier);
    }

    public void addforbiddenMetier(Metier metier, Month month) {
        this.forbiddenMetierMonth.add((MultiKey<Object>)new MultiKey((Object)metier, (Object)month));
    }

    public void removeforbiddenMetier(Metier metier, Month month) {
        this.forbiddenMetierMonth.remove(new MultiKey((Object)metier, (Object)month));
    }

    public void addforbiddenMetier(Collection<Metier> metiers) {
        this.forbiddenMetier.addAll(metiers);
    }

    public Set<Metier> getForbiddenMetier() {
        return this.forbiddenMetier;
    }

    public boolean isForbidden(Metier metier, Month month) {
        boolean result = this.forbiddenMetier.contains(metier);
        if (!result) {
            result = this.forbiddenMetierMonth.contains(new MultiKey((Object)metier, (Object)month));
        }
        return result;
    }

    public MatrixND getNoActivity(TimeStep step) {
        return this.noActivity.get(step);
    }

    public MatrixND getOrCreateNoActivity(TimeStep step, String name, List<Strategy> strategies, List<Metier> metiers) {
        MatrixND result = this.getNoActivity(step);
        if (result == null) {
            if (strategies.size() == 0) {
                strategies = new ArrayList<Strategy>();
                strategies.add(null);
            }
            if (metiers.size() == 0) {
                metiers = new ArrayList<Metier>();
                metiers.add(null);
            }
            result = MatrixFactory.getInstance().create(name, new List[]{strategies, metiers}, new String[]{I18n.n((String)"isisfish.metierMonitor.strategies", (Object[])new Object[0]), I18n.n((String)"isisfish.metierMonitor.metiers", (Object[])new Object[0])});
            this.setNoActivity(step, result);
        }
        return result;
    }

    public void setNoActivity(TimeStep step, MatrixND nonActivity) {
        this.noActivity.put(step, nonActivity);
    }

    public Licence getLicence(Metier metier, Month month) {
        Licence result = null;
        MapIterator i = this.list.mapIterator();
        while (i.hasNext()) {
            MultiKey keys = (MultiKey)i.next();
            Metier metierKey = (Metier)keys.getKey(0);
            Month firstMonth = (Month)keys.getKey(1);
            Month lastMonth = (Month)keys.getKey(2);
            if (!metier.equals(metierKey) || firstMonth.compareTo(month) > 0 || month.compareTo(lastMonth) > 0) continue;
            result = (Licence)i.getValue();
            break;
        }
        return result;
    }

    public void addLicence(Metier metier, int nbLicences, Month firstMonth, Month lastMonth) {
        if (!this.isLimitedPeriode(metier, firstMonth, lastMonth)) {
            Licence o = new Licence();
            o.nbLicences = nbLicences;
            o.proportionMaxTotal = this.computeProportionMaxTotal(metier, nbLicences);
            Month i = firstMonth;
            while (i.compareTo(lastMonth) <= 0) {
                o.proportionsMonth.put(i, this.computeProportionMonth(metier, i));
                i = i.next();
            }
            this.list.put((Object)metier, (Object)firstMonth, (Object)lastMonth, (Object)o);
        } else {
            log.warn((Object)("il existe deja une licence touchant le metier: " + metier + " sur la periode:" + firstMonth + "-" + lastMonth));
        }
    }

    public boolean isLimitedPeriode(Metier metier, Month firstMonth, Month lastMonth) {
        Month i = firstMonth;
        while (i.compareTo(lastMonth) <= 0) {
            if (this.isLimited(metier, i)) {
                return true;
            }
            i = i.next();
        }
        return false;
    }

    public boolean isLimited(Metier metier, Month month) {
        Licence l = this.getLicence(metier, month);
        return l != null;
    }

    public double getLicenceOverflow(Metier metier, Month month) {
        double prop;
        double propMax;
        Licence licence = this.getLicence(metier, month);
        if (licence != null && (propMax = licence.proportionMaxTotal) < (prop = licence.proportionsMonth.get(month).doubleValue())) {
            return prop - propMax;
        }
        return 0.0;
    }

    private double computeProportionMonth(Metier metier, Month month) {
        double prop = 0.0;
        try {
            TopiaContext tx = metier.getTopiaContext();
            List res = null;
            res = tx.findAll("select * from fr.ifremer.isisfish.entities.StrategyMonthInfo where strategyMonthInfo.month=?", new Object[]{month, metier});
            for (StrategyMonthInfo smi : res) {
                prop += smi.getProportionMetier(metier);
            }
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException("Can't find PropStrMet", eee);
        }
        return prop;
    }

    private double computeProportionMaxTotal(Metier metier, int nbLicences) {
        int nbBoat = 0;
        try {
            TopiaContext tx = metier.getTopiaContext();
            List res = null;
            res = tx.findAll("select setOfVessels from fr.ifremer.isisfish.entities.EffortDescription where possibleMetiers=?", new Object[]{metier});
            for (SetOfVessels sov : res) {
                nbBoat += sov.getNumberOfVessels();
            }
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException("Can't find SetOfVessels", eee);
        }
        double result = 0.0;
        if (nbBoat != 0) {
            result = (double)nbLicences / (double)nbBoat;
        }
        return result;
    }

    static class Licence {
        int nbLicences = 0;
        double proportionMaxTotal = 0.0;
        Map<Month, Double> proportionsMonth = new HashMap<Month, Double>();

        Licence() {
        }
    }
}

