/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.logging.console;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class LogConsoleModel {
    protected int nbLinesInEditor;
    protected long nbLines;
    protected String searchText;
    protected int levels;
    protected File logFile;
    protected String smtpServer;
    protected String to;
    protected String from;
    protected long firstLinePosition;
    protected List<String> allItems;
    protected EventListenerList listenerList = new EventListenerList();
    protected ChangeEvent changeEvent;

    public LogConsoleModel(File logFile, int nbLinesInEditor, String smtpServer, String fromMail, String to) {
        this.nbLinesInEditor = nbLinesInEditor;
        this.listenerList = new EventListenerList();
        this.allItems = new ArrayList<String>();
        this.logFile = logFile;
        this.smtpServer = smtpServer;
        this.from = fromMail;
        this.to = to;
        this.levels = 0;
        this.searchText = "";
    }

    public String getText() {
        StringBuffer sb = new StringBuffer();
        if (!this.allItems.isEmpty()) {
            for (String item : this.allItems) {
                sb.append('\n').append(item);
            }
        } else {
            sb.append(" no log found...");
        }
        return sb.toString().substring(1);
    }

    public boolean canReset() {
        return this.levels > 0 || !"".equals(this.searchText);
    }

    public long getNbLines() {
        return this.nbLines;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public long getFirstLinePosition() {
        if (this.allItems.isEmpty()) {
            return -1L;
        }
        return this.firstLinePosition;
    }

    public long getLastLinePosition() {
        if (this.allItems.isEmpty()) {
            return -1L;
        }
        return this.firstLinePosition + (long)this.allItems.size();
    }

    public int getLevels() {
        return this.levels;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer;
    }

    public void setEmailTo(String to) {
        this.to = to;
    }

    public void setEmailFrom(String from) {
        this.from = from;
    }

    public void setFirstLinePosition(long firstLinePosition) {
        this.firstLinePosition = firstLinePosition;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public void setNbLines(long nbLines) {
        this.nbLines = nbLines;
    }

    public void setLevels(int levels) {
        this.levels = levels;
    }

    public int getNbLinesInEditor() {
        return this.nbLinesInEditor;
    }

    public void setNbLinesInEditor(int nbLinesInEditor) {
        this.nbLinesInEditor = nbLinesInEditor;
    }

    public boolean isBOF() {
        return this.firstLinePosition == 0L;
    }

    public boolean isEOF() {
        return this.getLastLinePosition() == this.nbLines;
    }

    public String getFrom() {
        return this.from;
    }

    public String getSmtpServer() {
        return this.smtpServer;
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }
}

