package fr.ifremer.isisfish.ui.queue;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import fr.ifremer.isisfish.simulator.launcher.SimulationServiceTableModel;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class QueueUI extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_AUTO_LAUNCH_BUTTON_MODEL = "autoLaunchButtonModel";
    public static final String PROPERTY_CAN_CLEAR = "canClear";
    public static final String PROPERTY_CAN_RESTART = "canRestart";
    public static final String PROPERTY_CAN_SHOW_LOG = "canShowLog";
    public static final String PROPERTY_CAN_STOP = "canStop";
    public static final String PROPERTY_DONE_SIMULATION_MODEL = "doneSimulationModel";
    public static final String PROPERTY_NEW_SIMULATION_MODEL = "newSimulationModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CLEAR_DONE_JOBS_BUTTON_ENABLED = "clearDoneJobsButton.enabled";
    public static final String BINDING_RESTART_SIMULATION_BUTTON_ENABLED = "restartSimulationButton.enabled";
    public static final String BINDING_SHOW_LOG_BUTTON_ENABLED = "showLogButton.enabled";
    public static final String BINDING_STOP_SIMU_BUTTON_ENABLED = "stopSimuButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVy24URxQtD4yNnwGPbF6O5BCDAIUeUKQgZF6xHQeccUIYUBCTBTXdNdOFarra9cANkSI+gU8g+2wisWOFWGSdRTZRfiGKssg2yq3umanpcbtpMV70WHXvOffc27dO//wXKkuBPnqMo8gROlC0Q5ytzx88+Kb5mLhqg0hX0FBxgZK/sRIqNdC01z+XCn3cqBl4tQuvrvNOyAMSDKBXa2hKqqeMSJ8QpdCHaYQrZbXeD69GoRY91r6oLNaX//xdeuE9/6mEUBSCugVoZfldKNvJwRoqUU+heaj0BFcZDtogQ9CgDXpnzdk6w1J+jTtkB/2IJmpoPMQCyBQ6VbzlmCPGR6FCEyv3cJORiwqttIRDW4J0CPxKKltU+o6mzo4mmjjfmuf922EYQ8cB6OPAY0QodO7dwFtJ7gDaxUFdcRBwxPTlmF6dNc4ZwYHNmjJZPt+t8bY5OWIjhyCyDsli6Nwg7hKpsFBDkfmA7NZpRzOsKA+2uUeYQmtZ0mWSxQWo0oHrQ8wC60Q8oS6JhxaT2AoVD0Y+VMKETtiUBawVr8Wsa1qpvo4LuSO8g7UkA/mW75gkDK5Fr1o861iaQqfNXCNH7sL6OBukhTVTNSpVPYWwVEv7UW1AVybnlM2dWdmqh4yqOzgwm7M4WMpGTPJkHzMLGFdwxrqgo2lQP2TST9v3uTPQ0nwKEh+atLPZNS6Zw/NpurmdPW1dMA+nn3F4+A0pdDxdlrfbrPs20h3OSVho8/57wEoKmAU5KpJdtVtjsy4PzU8mF2HfhIpr7oNpa4s35d40gU6mrAhMzrEmZ11orIHKQsMxrFdjry/ehVDiiMeGHNEQxtH/Fiu/v/7z1WbPBitQeyEzdcDFwZ5CwUMwFGpKf5B4oFaUVbdxuNpAk8mCxha/lCGs3g2DOKiX2IqBO7ew9IGiPPHHm7eLj347gEqbaIpx7G1ik38bTSof3oPPmReFN27GimZ2D8HzsNEGewczvce1638RhWBk3WW8SgNGA7KMFVh0UytyPYKhLGUMpa+sOfnrv5X6Lzd7gxkDocf3TbfDKT9E40m1+AvRNf/ML8J0KIn2uDX5LNsfM79nwu6FXo+fX2Z1Ps0Fha9IvJkmaSvS5uerWLv5b7sw1QyMmD4j3xHa9tWIXOVOYptzVz2s8HKTBh5csevZhJ8UIJxNmZ9J+/79yebSTjoSmzlu5DBcKsSAR2ZojcyQ18WnBaZ6UJEob2+KcEyQwFxeL0fKZ4Wa+SFHSDGG5zkaroysoRhDnobVkTUUY8jTcG1kDYbhf94Ggw5TDAAA";
    private static final Log log = LogFactory.getLog(QueueUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JToggleButton autoLaunchButton;
    protected PauseButtonModel autoLaunchButtonModel;
    protected Boolean canClear;
    protected Boolean canRestart;
    protected Boolean canShowLog;
    protected Boolean canStop;
    protected JButton clearDoneJobsButton;
    protected SimulationServiceTableModel doneSimulationModel;
    protected QueueHandler handler;
    protected SimulationServiceTableModel newSimulationModel;
    protected JTable queueTable;
    protected JTable queueTableDone;
    protected JButton restartSimulationButton;
    protected DefaultListSelectionModel selectionModelQueueTable;
    protected DefaultListSelectionModel selectionModelQueueTableDone;
    protected JButton showLogButton;
    protected JButton stopSimuButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private JSplitPane $JSplitPane0;
    private QueueUI $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public QueueUI() {
        $initialize();
    }

    public QueueUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__clearDoneJobsButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.clearDoneJobs();
    }

    public void doActionPerformed__on__restartSimulationButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.restartSimulation();
    }

    public void doActionPerformed__on__showLogButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.viewLog();
    }

    public void doActionPerformed__on__stopSimuButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.stopSimulation();
    }

    public void doTableChanged__on__doneSimulationModel(TableModelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateActions();
    }

    public void doValueChanged__on__selectionModelQueueTable(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateActions();
    }

    public void doValueChanged__on__selectionModelQueueTableDone(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateActions();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JToggleButton getAutoLaunchButton() {
        return autoLaunchButton;
    }

    public PauseButtonModel getAutoLaunchButtonModel() {
        return autoLaunchButtonModel;
    }

    public Boolean getCanClear() {
        return canClear;
    }

    public Boolean getCanRestart() {
        return canRestart;
    }

    public Boolean getCanShowLog() {
        return canShowLog;
    }

    public Boolean getCanStop() {
        return canStop;
    }

    public JButton getClearDoneJobsButton() {
        return clearDoneJobsButton;
    }

    public SimulationServiceTableModel getDoneSimulationModel() {
        return doneSimulationModel;
    }

    public QueueHandler getHandler() {
        return handler;
    }

    public SimulationServiceTableModel getNewSimulationModel() {
        return newSimulationModel;
    }

    public JTable getQueueTable() {
        return queueTable;
    }

    public JTable getQueueTableDone() {
        return queueTableDone;
    }

    public JButton getRestartSimulationButton() {
        return restartSimulationButton;
    }

    public DefaultListSelectionModel getSelectionModelQueueTable() {
        return selectionModelQueueTable;
    }

    public DefaultListSelectionModel getSelectionModelQueueTableDone() {
        return selectionModelQueueTableDone;
    }

    public JButton getShowLogButton() {
        return showLogButton;
    }

    public JButton getStopSimuButton() {
        return stopSimuButton;
    }

    public Boolean isCanClear() {
        return canClear !=null && canClear;
    }

    public Boolean isCanRestart() {
        return canRestart !=null && canRestart;
    }

    public Boolean isCanShowLog() {
        return canShowLog !=null && canShowLog;
    }

    public Boolean isCanStop() {
        return canStop !=null && canStop;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAutoLaunchButtonModel(PauseButtonModel autoLaunchButtonModel) {
        PauseButtonModel oldValue = this.autoLaunchButtonModel;
        this.autoLaunchButtonModel = autoLaunchButtonModel;
        firePropertyChange(PROPERTY_AUTO_LAUNCH_BUTTON_MODEL, oldValue, autoLaunchButtonModel);
    }

    public void setCanClear(Boolean canClear) {
        Boolean oldValue = this.canClear;
        this.canClear = canClear;
        firePropertyChange(PROPERTY_CAN_CLEAR, oldValue, canClear);
    }

    public void setCanRestart(Boolean canRestart) {
        Boolean oldValue = this.canRestart;
        this.canRestart = canRestart;
        firePropertyChange(PROPERTY_CAN_RESTART, oldValue, canRestart);
    }

    public void setCanShowLog(Boolean canShowLog) {
        Boolean oldValue = this.canShowLog;
        this.canShowLog = canShowLog;
        firePropertyChange(PROPERTY_CAN_SHOW_LOG, oldValue, canShowLog);
    }

    public void setCanStop(Boolean canStop) {
        Boolean oldValue = this.canStop;
        this.canStop = canStop;
        firePropertyChange(PROPERTY_CAN_STOP, oldValue, canStop);
    }

    public void setDoneSimulationModel(SimulationServiceTableModel doneSimulationModel) {
        SimulationServiceTableModel oldValue = this.doneSimulationModel;
        this.doneSimulationModel = doneSimulationModel;
        firePropertyChange(PROPERTY_DONE_SIMULATION_MODEL, oldValue, doneSimulationModel);
    }

    public void setNewSimulationModel(SimulationServiceTableModel newSimulationModel) {
        SimulationServiceTableModel oldValue = this.newSimulationModel;
        this.newSimulationModel = newSimulationModel;
        firePropertyChange(PROPERTY_NEW_SIMULATION_MODEL, oldValue, newSimulationModel);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAutoLaunchButton() {
        $objectMap.put("autoLaunchButton", autoLaunchButton = new JToggleButton());
        
        autoLaunchButton.setName("autoLaunchButton");
        autoLaunchButton.setText(t("isisfish.queue.simulationLaunch"));
    }

    protected void createAutoLaunchButtonModel() {
        $objectMap.put("autoLaunchButtonModel", autoLaunchButtonModel = new PauseButtonModel(SimulationService.getService()));
    }

    protected void createCanClear() {
        $objectMap.put("canClear", canClear = false);
    }

    protected void createCanRestart() {
        $objectMap.put("canRestart", canRestart = false);
    }

    protected void createCanShowLog() {
        $objectMap.put("canShowLog", canShowLog = false);
    }

    protected void createCanStop() {
        $objectMap.put("canStop", canStop = false);
    }

    protected void createClearDoneJobsButton() {
        $objectMap.put("clearDoneJobsButton", clearDoneJobsButton = new JButton());
        
        clearDoneJobsButton.setName("clearDoneJobsButton");
        clearDoneJobsButton.setText(t("isisfish.queue.clearDone"));
        clearDoneJobsButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__clearDoneJobsButton"));
    }

    protected void createDoneSimulationModel() {
        $objectMap.put("doneSimulationModel", doneSimulationModel = new SimulationServiceTableModel(SimulationService.getService(), false));
        
        doneSimulationModel.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__doneSimulationModel"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new QueueHandler(this));
    }

    protected void createNewSimulationModel() {
        $objectMap.put("newSimulationModel", newSimulationModel = new SimulationServiceTableModel(SimulationService.getService(), true));
    }

    protected void createQueueTable() {
        $objectMap.put("queueTable", queueTable = new JTable());
        
        queueTable.setName("queueTable");
    }

    protected void createQueueTableDone() {
        $objectMap.put("queueTableDone", queueTableDone = new JTable());
        
        queueTableDone.setName("queueTableDone");
    }

    protected void createRestartSimulationButton() {
        $objectMap.put("restartSimulationButton", restartSimulationButton = new JButton());
        
        restartSimulationButton.setName("restartSimulationButton");
        restartSimulationButton.setText(t("isisfish.queue.restartSimulation"));
        restartSimulationButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__restartSimulationButton"));
    }

    protected void createSelectionModelQueueTable() {
        $objectMap.put("selectionModelQueueTable", selectionModelQueueTable = new DefaultListSelectionModel());
        
        selectionModelQueueTable.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectionModelQueueTable"));
    }

    protected void createSelectionModelQueueTableDone() {
        $objectMap.put("selectionModelQueueTableDone", selectionModelQueueTableDone = new DefaultListSelectionModel());
        
        selectionModelQueueTableDone.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectionModelQueueTableDone"));
    }

    protected void createShowLogButton() {
        $objectMap.put("showLogButton", showLogButton = new JButton());
        
        showLogButton.setName("showLogButton");
        showLogButton.setText(t("isisfish.queue.showLog"));
        showLogButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__showLogButton"));
    }

    protected void createStopSimuButton() {
        $objectMap.put("stopSimuButton", stopSimuButton = new JButton());
        
        stopSimuButton.setName("stopSimuButton");
        stopSimuButton.setText(t("isisfish.queue.stopSimulation"));
        stopSimuButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__stopSimuButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JSplitPane0, new GridBagConstraints(0, 0, 5, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(autoLaunchButton, new GridBagConstraints(0, 1, 1, 1, 0.3, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(stopSimuButton, new GridBagConstraints(1, 1, 1, 1, 0.3, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(restartSimulationButton, new GridBagConstraints(2, 1, 1, 1, 0.3, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(showLogButton, new GridBagConstraints(3, 1, 1, 1, 0.3, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(clearDoneJobsButton, new GridBagConstraints(4, 1, 1, 1, 0.3, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add($JScrollPane0, JSplitPane.LEFT);
        $JSplitPane0.add($JScrollPane1, JSplitPane.RIGHT);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(queueTable);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(queueTableDone);
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 7 property setters
        queueTable.setModel(newSimulationModel);
        queueTable.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        queueTable.setSelectionModel(selectionModelQueueTable);
        queueTableDone.setModel(doneSimulationModel);
        queueTableDone.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        queueTableDone.setSelectionModel(selectionModelQueueTableDone);
        autoLaunchButton.setModel(autoLaunchButtonModel);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createCanStop();
        createCanShowLog();
        createCanClear();
        createCanRestart();
        createNewSimulationModel();
        createDoneSimulationModel();
        createAutoLaunchButtonModel();
        createSelectionModelQueueTable();
        createSelectionModelQueueTableDone();
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new JSplitPane());
        
        $JSplitPane0.setName("$JSplitPane0");
        $JSplitPane0.setOneTouchExpandable(true);
        $JSplitPane0.setOrientation(0);
        $JSplitPane0.setResizeWeight(0.5);
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createQueueTable();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createQueueTableDone();
        createAutoLaunchButton();
        createStopSimuButton();
        createRestartSimulationButton();
        createShowLogButton();
        createClearDoneJobsButton();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STOP_SIMU_BUTTON_ENABLED, true ,"canStop") {
        
            @Override
            public void processDataBinding() {
                stopSimuButton.setEnabled(isCanStop());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESTART_SIMULATION_BUTTON_ENABLED, true ,"canRestart") {
        
            @Override
            public void processDataBinding() {
                restartSimulationButton.setEnabled(isCanRestart());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SHOW_LOG_BUTTON_ENABLED, true ,"canShowLog") {
        
            @Override
            public void processDataBinding() {
                showLogButton.setEnabled(isCanShowLog());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CLEAR_DONE_JOBS_BUTTON_ENABLED, true ,"canClear") {
        
            @Override
            public void processDataBinding() {
                clearDoneJobsButton.setEnabled(isCanClear());
            }
        });
    }

}