package fr.ifremer.isisfish.ui.input.zone;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import fr.ifremer.isisfish.ui.input.variable.EntityVariableUI;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import javax.swing.JTabbedPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class ZoneUI extends InputContentUI<fr.ifremer.isisfish.entities.Zone> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_VARIABLES_UI_ACTIVE = "variablesUI.active";
    public static final String BINDING_VARIABLES_UI_BEAN = "variablesUI.bean";
    public static final String BINDING_VARIABLES_UI_SENSITIVITY = "variablesUI.sensitivity";
    public static final String BINDING_ZONE_BASICS_UI_ACTIVE = "zoneBasicsUI.active";
    public static final String BINDING_ZONE_BASICS_UI_BEAN = "zoneBasicsUI.bean";
    public static final String BINDING_ZONE_BASICS_UI_SENSITIVITY = "zoneBasicsUI.sensitivity";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUTU9TQRS9rbRYiooQEBQTUBYsdIou2NQoihJK6kdEDKEb5/VN6ZDXeePMvPJwYfwJ/gTduzFx58q4cO3CjfEvGOPCrfHO6zc8oQldzLRz7zn3zO098+4npLSC2R0ahkQFwvAaI2u3NzcfOjusbO4yXVZcGl9B45NIQrIEWbd9rg1cLhUtPNeE55b9mvQFE13ofBGGtNnzmK4yZgxc7EWUtc6tt8P5UAaqxdoWFcf65vev5Gv31dskQChRXQavMnMUqnOTgSIkuWtgFCvVac6jYhtlKC62Ue8pe7bsUa0f0Bp7Di9hsAhpSRWSGbjU/5UjjggfSgMjcwUhA7PsC4PpG4UFA/MVRXhFsRrDXXNd4bpKAk64TSQvkJds4bJRkDLiSRsYcBgVBmbjkEjLDWc6AnUgg1UqXI8pA1f7q7fayO8u6rt72C3bmJDoXewTWXtEBfO6qlj4E+oYONeThkcOc22yTRxt5w/b/DtU87LeKBgg/UlrASzJeJsrW6eKUwenyFItHkrVSiX3bLf2njZ/7qfMzKHwgqj4+Ded7xmsxr2aUXkQcM0ezGBAwYUeIM466cx6ZxgTJUipAI8NTJYO2uMxhhrGmNxnDEsYRf9OjH37+OPDSssNaaw9HpvaZWacUql8iXPBbekzDSsEhnu5+1TmS+gp5uFLEDl9OkbYejOM4rDeWQsnFk5Wqa4iRWrw+6fPE8++noDkCgx5PnVXqM0vQMZUFXbB99xQ3lqKFA3vnsR1xGozkMY8Xscenb7hUkNnHC5cbPrNEJswHdOEthIn8+XP2Pr7pVYjEihs6r/pnWaktiDNhccFix6GpudjH4Ks1Cxw/Y6349yesPuUbE7HfLReibtpZGcbzYWB3RYi0fbb9b45spoJjcav4zgfi8oek0MYpvtiWDw2Q/4Ihn9iYb+ZuwYAAA==";
    private static final Log log = LogFactory.getLog(ZoneUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Zone bean;
    protected ZoneHandler handler;
    protected EntityVariableUI variablesUI;
    protected ZoneBasicsUI zoneBasicsUI;
    protected JTabbedPane zoneTab;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ZoneUI $InputContentUI0 = this;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }
    
        @Override
        public void setLayer(boolean active) {
            super.setLayer(active);
            zoneBasicsUI.setLayer(active);
            variablesUI.setLayer(active);
        }
        
        @Override
        public void resetChangeModel() {
            zoneBasicsUI.resetChangeModel();
            variablesUI.resetChangeModel();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ZoneUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ZoneUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ZoneUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ZoneUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ZoneUI() {
        $initialize();
    }

    public ZoneUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public ZoneUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ZoneUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Zone getBean() {
        return bean;
    }

    public ZoneHandler getHandler() {
        return handler;
    }

    public EntityVariableUI getVariablesUI() {
        return variablesUI;
    }

    public ZoneBasicsUI getZoneBasicsUI() {
        return zoneBasicsUI;
    }

    public JTabbedPane getZoneTab() {
        return zoneTab;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Zone bean) {
        Zone oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(zoneTab, BorderLayout.CENTER);
    }

    protected void addChildrenToZoneTab() {
        if (!allComponentsCreated) {
            return;
        }
        zoneTab.add(zoneBasicsUI);
        zoneTab.add(variablesUI);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener(zoneTab, 0));
        zoneTab.setTitleAt(0, t("isisfish.zone.title"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener(zoneTab, 1));
        zoneTab.setTitleAt(1, t("isisfish.variables.tabtitle"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new ZoneHandler(this));
    }

    protected void createVariablesUI() {
        $objectMap.put("variablesUI", variablesUI = new EntityVariableUI(this));
        
        variablesUI.setName("variablesUI");
    }

    protected void createZoneBasicsUI() {
        $objectMap.put("zoneBasicsUI", zoneBasicsUI = new ZoneBasicsUI(this));
        
        zoneBasicsUI.setName("zoneBasicsUI");
    }

    protected void createZoneTab() {
        $objectMap.put("zoneTab", zoneTab = new JTabbedPane());
        
        zoneTab.setName("zoneTab");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        addChildrenToZoneTab();
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createHandler();
        createZoneTab();
        createZoneBasicsUI();
        createVariablesUI();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(t("isisfish.zone.title"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setTitle(t("isisfish.variables.tabtitle"));
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ZONE_BASICS_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                zoneBasicsUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ZONE_BASICS_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                zoneBasicsUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ZONE_BASICS_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                zoneBasicsUI.setSensitivity(isSensitivity());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VARIABLES_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                variablesUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VARIABLES_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                variablesUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VARIABLES_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                variablesUI.setSensitivity(isSensitivity());
            }
        });
    }

}