package fr.ifremer.isisfish.ui.input.triptype;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.TripType;
import fr.ifremer.isisfish.types.TimeUnit;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class TripTypeUI extends InputContentUI<TripType> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CREATE_ENABLED = "create.enabled";
    public static final String BINDING_DELETE_ENABLED = "delete.enabled";
    public static final String BINDING_FIELD_TRIP_TYPE_COMMENT_ENABLED = "fieldTripTypeComment.enabled";
    public static final String BINDING_FIELD_TRIP_TYPE_COMMENT_TEXT = "fieldTripTypeComment.text";
    public static final String BINDING_FIELD_TRIP_TYPE_DURATION_ENABLED = "fieldTripTypeDuration.enabled";
    public static final String BINDING_FIELD_TRIP_TYPE_DURATION_TEXT = "fieldTripTypeDuration.text";
    public static final String BINDING_FIELD_TRIP_TYPE_MIN_TIME_BETWEEN_TRIP_ENABLED = "fieldTripTypeMinTimeBetweenTrip.enabled";
    public static final String BINDING_FIELD_TRIP_TYPE_MIN_TIME_BETWEEN_TRIP_TEXT = "fieldTripTypeMinTimeBetweenTrip.text";
    public static final String BINDING_FIELD_TRIP_TYPE_NAME_ENABLED = "fieldTripTypeName.enabled";
    public static final String BINDING_FIELD_TRIP_TYPE_NAME_TEXT = "fieldTripTypeName.text";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";
    private static final String BINDING_$JLABEL3_ENABLED = "$JLabel3.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUy27TQBSdhr5LeZWUQoEWCAjxcAoIECrvotKElFcCQmTDJJ42gyZjMzNu3Q3iE/gE2LNBYscKsWDNgg3iFxBiwRZxx06cOhjXyF1M3Ln3nnvuufZ58x31SYEOPMWuawiHK9okRvHao0d3ak9JXd0gsi6orSyB/L+eDMpU0YgZ3EuFDlVLujzfKs/PWU3b4oSvq54toWGp1hiRDUKUQvvCFXUp8+UgPOvajmijBqSiUF/9/JF5ab54nUHItYFdFkaZ3qiqM0lvCWWoqdAO6LSC8wzzZaAhKF8GvqP6bo5hKW/jJnmGnqOBEuq3sQAwhQ4mH9nD8OpdW6FtuQK3HTVncQXpDwozCs0sCYMuCdIk8CupXKKyYTjUoDrRUBpuzSZGBR4q8PCgYNseXr9CvTWCuUKHoxAAnipKZFDYKRtoYG4yIhQ6+3+9F/y6DtLQCmbUxDCvQsdDygcBQ66CokZZnw/bl+tHsMw12IGW223lFu9iTtg6vrkKrjECWk2EevjZXkxnZrsLTul/9+hjIggN5oolXCNsprund6uTJoPc7UuUMLM9vH4PFBoPFVWIq+Z1Uriw3cQjMBWOZUOgNxyBFbW4Dh6MBjkdATIVAlmkvAJ6XCdqlRCub2PgzkTAjeaK5bqwGNPCgzK7QkN2QuGqnSES8A00vW8j+5dC1wTBuuZk94JORyyoV+IV0HkshHLdUcoX6UyQ2F/HvO6v7Hx3BBoqEhUxCSPhiECToZcKzMjomFHHLXqqqE84cA1vYfVv/7oPId+5JrqcSwN60d/jY1/ef3s337ar3dA7G5m6zm3BRmxh2fCxUt16q+9VjqIsv4jt2SoakjBS3bfivRHEyq0wkIN+23W5ocuNBSwbANE38PXDx/EnnzehzDwaZhY257HOL6Ah1RCggsVM175y1WO0eXUQzm2aGyyRcL1EcNAtF+GrxtM1yk1Y12UXVNgboUJApTb06ddY+e3VthI9wGz3P9M7avQ9Rv2UM8qJZ90tV4606hFbEse0Ou4b5cc9+ne/3XKaOe+8GTVqr4LXGBzjot99GivwxpqjCMyqi255Q+inxYSY+rqgj2I0woFECPdSI8RxyCXncD8NQhyHIwm2M6Isi1XAhmBJMWQ2htpI0mQIceMcTS1pMoQ4DsdS65AMIY7DidQ6JEOI43AqtQ7JEOI4nEutQzKEOA4XUnNIhhDHYTY1h2QIcRwupeagEf4AnF1URVMNAAA=";
    private static final Log log = LogFactory.getLog(TripTypeUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TripType bean;
    protected JButton cancel;
    protected JButton create;
    protected JButton delete;
    protected JTextArea fieldTripTypeComment;
    protected JTextField fieldTripTypeDuration;
    protected JTextField fieldTripTypeMinTimeBetweenTrip;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "fieldTripTypeName")
    protected JTextField fieldTripTypeName;
    protected TripTypeHandler handler;
    protected JButton save;
    @Validator( validatorId = "validator")
    protected SwingValidator<TripType> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private TripTypeUI $InputContentUI0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JScrollPane $JScrollPane0;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public TripTypeUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TripTypeUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public TripTypeUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public TripTypeUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TripTypeUI() {
        $initialize();
    }

    public TripTypeUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public TripTypeUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public TripTypeUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__create(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().create(TripType.class);
    }

    public void doActionPerformed__on__delete(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().delete();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().save();validator.setChanged(false);
    }

    public void doKeyReleased__on__fieldTripTypeComment(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setComment(fieldTripTypeComment.getText());
    }

    public void doKeyReleased__on__fieldTripTypeDuration(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setTripDuration(new TimeUnit(Double.parseDouble(fieldTripTypeDuration.getText()) * 3600));
    }

    public void doKeyReleased__on__fieldTripTypeMinTimeBetweenTrip(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setMinTimeBetweenTrip(new TimeUnit(Double.parseDouble(fieldTripTypeMinTimeBetweenTrip.getText()) * 3600));
    }

    public void doKeyReleased__on__fieldTripTypeName(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setName(fieldTripTypeName.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TripType getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JButton getCreate() {
        return create;
    }

    public JButton getDelete() {
        return delete;
    }

    public JTextArea getFieldTripTypeComment() {
        return fieldTripTypeComment;
    }

    public JTextField getFieldTripTypeDuration() {
        return fieldTripTypeDuration;
    }

    public JTextField getFieldTripTypeMinTimeBetweenTrip() {
        return fieldTripTypeMinTimeBetweenTrip;
    }

    public JTextField getFieldTripTypeName() {
        return fieldTripTypeName;
    }

    public TripTypeHandler getHandler() {
        return handler;
    }

    public JButton getSave() {
        return save;
    }

    public SwingValidator<TripType> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(TripType bean) {
        TripType oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createCreate() {
        $objectMap.put("create", create = new JButton());
        
        create.setName("create");
        create.setText(t("isisfish.common.new"));
        create.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__create"));
    }

    protected void createDelete() {
        $objectMap.put("delete", delete = new JButton());
        
        delete.setName("delete");
        delete.setText(t("isisfish.common.remove"));
        delete.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__delete"));
    }

    protected void createFieldTripTypeComment() {
        $objectMap.put("fieldTripTypeComment", fieldTripTypeComment = new JTextArea());
        
        fieldTripTypeComment.setName("fieldTripTypeComment");
        fieldTripTypeComment.setColumns(15);
        fieldTripTypeComment.setLineWrap(true);
        fieldTripTypeComment.setWrapStyleWord(true);
        fieldTripTypeComment.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldTripTypeComment"));
    }

    protected void createFieldTripTypeDuration() {
        $objectMap.put("fieldTripTypeDuration", fieldTripTypeDuration = new JTextField());
        
        fieldTripTypeDuration.setName("fieldTripTypeDuration");
        fieldTripTypeDuration.setColumns(15);
        fieldTripTypeDuration.setToolTipText(t("isisfish.common.duration.inhours"));
        fieldTripTypeDuration.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldTripTypeDuration"));
        fieldTripTypeDuration.putClientProperty("sensitivityBean", TripType.class);
        fieldTripTypeDuration.putClientProperty("sensitivityMethod", "TripDuration");
    }

    protected void createFieldTripTypeMinTimeBetweenTrip() {
        $objectMap.put("fieldTripTypeMinTimeBetweenTrip", fieldTripTypeMinTimeBetweenTrip = new JTextField());
        
        fieldTripTypeMinTimeBetweenTrip.setName("fieldTripTypeMinTimeBetweenTrip");
        fieldTripTypeMinTimeBetweenTrip.setColumns(15);
        fieldTripTypeMinTimeBetweenTrip.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldTripTypeMinTimeBetweenTrip"));
        fieldTripTypeMinTimeBetweenTrip.putClientProperty("sensitivityBean", TripType.class);
        fieldTripTypeMinTimeBetweenTrip.putClientProperty("sensitivityMethod", "MinTimeBetweenTrip");
    }

    protected void createFieldTripTypeName() {
        $objectMap.put("fieldTripTypeName", fieldTripTypeName = new JTextField());
        
        fieldTripTypeName.setName("fieldTripTypeName");
        fieldTripTypeName.setColumns(15);
        fieldTripTypeName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldTripTypeName"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new TripTypeHandler(this));
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(TripType.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(SwingUtil.boxComponentWithJxLayer(fieldTripTypeName)), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldTripTypeDuration), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldTripTypeMinTimeBetweenTrip), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane0, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(fieldTripTypeComment));
        // inline complete setup of $Table2
        $Table2.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(create), new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(delete), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 17 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createHandler();
        createValidator();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.tripType.name"));
        createFieldTripTypeName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.tripType.duration"));
        createFieldTripTypeDuration();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.tripType.minTime"));
        createFieldTripTypeMinTimeBetweenTrip();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("isisfish.tripType.comments"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldTripTypeComment();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        createSave();
        createCancel();
        createCreate();
        createDelete();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 17 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 17 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_TRIP_TYPE_NAME_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldTripTypeName.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_TRIP_TYPE_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldTripTypeName, getBean().getName());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_TRIP_TYPE_DURATION_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldTripTypeDuration.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_TRIP_TYPE_DURATION_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null && getBean().getTripDuration() != null) {
                    SwingUtil.setText(fieldTripTypeDuration, String.valueOf(getBean().getTripDuration().getHour()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_TRIP_TYPE_MIN_TIME_BETWEEN_TRIP_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldTripTypeMinTimeBetweenTrip.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_TRIP_TYPE_MIN_TIME_BETWEEN_TRIP_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null && getBean().getMinTimeBetweenTrip() != null) {
                    SwingUtil.setText(fieldTripTypeMinTimeBetweenTrip, String.valueOf(getBean().getMinTimeBetweenTrip().getHour()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL3_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel3.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_TRIP_TYPE_COMMENT_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldTripTypeComment.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_TRIP_TYPE_COMMENT_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldTripTypeComment, jaxx.runtime.SwingUtil.getStringValue(getBean().getComment()));
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    save.setEnabled(validator.isValid() && validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    cancel.setEnabled(validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREATE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    create.setEnabled(!validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DELETE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
                addPropertyChangeListener("bean", this);
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    delete.setEnabled(!validator.isChanged() && getBean() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
                removePropertyChangeListener("bean", this);
            }
        });
    }

}