package fr.ifremer.isisfish.ui.input.setofvessels;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.EffortDescription;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class EffortDescriptionUI extends InputContentUI<SetOfVessels> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_FIELD_EFFORT_DESCRIPTION_EFFORT_DESCRIPTION_LIST_ENABLED = "fieldEffortDescriptionEffortDescriptionList.enabled";
    public static final String BINDING_FIELD_EFFORT_DESCRIPTION_METIER_LIST_ENABLED = "fieldEffortDescriptionMetierList.enabled";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVVz08TQRSeVgoW+aVERIVYEU0IcavxYLSIAkoAixArhNiL0+7UDpnOrjOzZbkY/wT/BL17MfHmyXjw7MGL8V8wxoNX45vddrdrV2xs5DBL3o/vfe/NvK+vvqKUFOjsLnZdQzhc0Rox1hZ2djZKu6SsbhNZFtRWlkD+XyKJkkV0xAzsUqFzxbxOzzbSs0tWzbY44S3ZuTzql2qfEVklRCk0Gc0oS5ktBO6cazuiiRqQikN98f1b8rn57GUSIdcGdkPQSuZvWWEnPXmUpKZCx6BSHWcZ5o+BhqD8MfAd1LYlhqW8h2vkCXqK+vKo18YCwBSa6rxlD8PLd22FRqZXue2oJYsrCN9avaTQjYowaEWQGoGvpLJCZdVwqEF1oCGJsip1IiVh0rhTqVgiKEItvrVq2x54r0I9JYK5QjNxcFCLKkqkUSBqo7Ltw4WpfVXMTUaEQotdkFnxQULYdB0zamKYhkKzkXsJHIbcg3kbBX1uN42tPVnmPtyQvgy3Ebu2iTlhLeSnH+ASIzDJ8UgNP9rz6cjjQcLg9FqhLCzGNBCknYighy4dPh5kZSqUMLOt6XUCcxV5KuFVHI0AaZvOPR1AnCo5Slm8DWPBhFc4Gkle9CKjDCbhWqw6aUsPY89FEyKNXtbGyWjAbHxPbYZmKxl9XAhvR+I6ianbW8a8TFirR6DTkcuBlTfClQ93MlFEKeGAGW6z2K4S98Hl68P4b/qgAT3vz7HRT2+/vFluisIw1D4eG9qiabCstrBs2ACqSw/7iuAoyrLr2M4VURqePAiiJ3gTMcQKDTeQg3reQzB0urGCZRUgUn2f370fe/TxEEouo35mYXMZ6/hVlFZVAVOwmOnaN295jAb2DsM5orkpNACTZPcJN4nQCzo0ByuCMyXKTXgo8y6MYiJmFAGfUvrDj9HC61vNcSSA3sk/hocjST1EvZQzyomnkg0BjFXFI7YkjmmFQhcnfQn9PWM31vaKd16N67ePcL2yXsXrrqM/OY+3/u9GxzCpmmX6T7ALkEH/1vWaA1pXYNq8AEo25w81gxX80oAekPl4xKkO6PUo4np7ufmvGB6rAxDOd4Sw1TXCtQNmO9N5F10h3P2vHGa7nmRnCAdxuNg1B43wC6JTuTQ0CgAA";
    private static final Log log = LogFactory.getLog(EffortDescriptionUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected SetOfVessels bean;
    protected JButton buttonEffortDescriptionAdd;
    protected JButton cancel;
    protected JList<EffortDescription> fieldEffortDescriptionEffortDescriptionList;
    protected JList<Metier> fieldEffortDescriptionMetierList;
    protected EffortDescriptionHandler handler;
    protected JButton removeEffortDescriptionButton;
    protected JButton save;
    @Validator( validatorId = "validator")
    protected SwingValidator<SetOfVessels> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private EffortDescriptionUI $InputContentUI0 = this;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EffortDescriptionUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EffortDescriptionUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EffortDescriptionUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EffortDescriptionUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EffortDescriptionUI() {
        $initialize();
    }

    public EffortDescriptionUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public EffortDescriptionUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EffortDescriptionUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__buttonEffortDescriptionAdd(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addEffortDescriptions();
    }

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__removeEffortDescriptionButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeEffortDescriptions();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().save();validator.setChanged(false);
    }

    public void doValueChanged__on__fieldEffortDescriptionEffortDescriptionList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.onFieldEffortDescriptionEffortDescriptionListValueChanged();
    }

    public void doValueChanged__on__fieldEffortDescriptionMetierList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.onFieldEffortDescriptionMetierListValueChanged();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public SetOfVessels getBean() {
        return bean;
    }

    public JButton getButtonEffortDescriptionAdd() {
        return buttonEffortDescriptionAdd;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JList<EffortDescription> getFieldEffortDescriptionEffortDescriptionList() {
        return fieldEffortDescriptionEffortDescriptionList;
    }

    public JList<Metier> getFieldEffortDescriptionMetierList() {
        return fieldEffortDescriptionMetierList;
    }

    public EffortDescriptionHandler getHandler() {
        return handler;
    }

    public JButton getRemoveEffortDescriptionButton() {
        return removeEffortDescriptionButton;
    }

    public JButton getSave() {
        return save;
    }

    public SwingValidator<SetOfVessels> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(SetOfVessels bean) {
        SetOfVessels oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createButtonEffortDescriptionAdd() {
        $objectMap.put("buttonEffortDescriptionAdd", buttonEffortDescriptionAdd = new JButton());
        
        buttonEffortDescriptionAdd.setName("buttonEffortDescriptionAdd");
        buttonEffortDescriptionAdd.setEnabled(false);
        buttonEffortDescriptionAdd.setText(t("isisfish.common.add"));
        buttonEffortDescriptionAdd.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonEffortDescriptionAdd"));
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createFieldEffortDescriptionEffortDescriptionList() {
        $objectMap.put("fieldEffortDescriptionEffortDescriptionList", fieldEffortDescriptionEffortDescriptionList = new JList<EffortDescription>());
        
        fieldEffortDescriptionEffortDescriptionList.setName("fieldEffortDescriptionEffortDescriptionList");
        fieldEffortDescriptionEffortDescriptionList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__fieldEffortDescriptionEffortDescriptionList"));
    }

    protected void createFieldEffortDescriptionMetierList() {
        $objectMap.put("fieldEffortDescriptionMetierList", fieldEffortDescriptionMetierList = new JList<Metier>());
        
        fieldEffortDescriptionMetierList.setName("fieldEffortDescriptionMetierList");
        fieldEffortDescriptionMetierList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__fieldEffortDescriptionMetierList"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new EffortDescriptionHandler(this));
    }

    protected void createRemoveEffortDescriptionButton() {
        $objectMap.put("removeEffortDescriptionButton", removeEffortDescriptionButton = new JButton());
        
        removeEffortDescriptionButton.setName("removeEffortDescriptionButton");
        removeEffortDescriptionButton.setEnabled(false);
        removeEffortDescriptionButton.setText(t("isisfish.common.remove"));
        removeEffortDescriptionButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeEffortDescriptionButton"));
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(SetOfVessels.class, "effortdescription"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(buttonEffortDescriptionAdd), new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(removeEffortDescriptionButton), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane1, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 3, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 3, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(fieldEffortDescriptionMetierList));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(SwingUtil.boxComponentWithJxLayer(fieldEffortDescriptionEffortDescriptionList));
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        fieldEffortDescriptionMetierList.setCellRenderer(new MetierListRenderer());
        fieldEffortDescriptionMetierList.setModel(new fr.ifremer.isisfish.ui.models.common.GenericListModel<fr.ifremer.isisfish.entities.Metier>());
        fieldEffortDescriptionMetierList.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        fieldEffortDescriptionEffortDescriptionList.setCellRenderer(new EffortDescriptionListRenderer());
        fieldEffortDescriptionEffortDescriptionList.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createHandler();
        createValidator();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldEffortDescriptionMetierList();
        createButtonEffortDescriptionAdd();
        createRemoveEffortDescriptionButton();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createFieldEffortDescriptionEffortDescriptionList();
        createSave();
        createCancel();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_EFFORT_DESCRIPTION_METIER_LIST_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldEffortDescriptionMetierList.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_EFFORT_DESCRIPTION_EFFORT_DESCRIPTION_LIST_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldEffortDescriptionEffortDescriptionList.setEnabled(isActive());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    save.setEnabled(validator.isValid() && validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    cancel.setEnabled(validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
    }

}