/*
 * #%L
 * IsisFish
 * 
 * $Id: ExportInfo.java 4218 2015-05-07 08:47:11Z echatellier $
 * $HeadURL: http://svn.codelutin.com/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/export/ExportInfo.java $
 * %%
 * Copyright (C) 2006 - 2015 Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.export;

/**
 * Interface que doivent implanter les classes d'export de resultats.
 * 
 * Le nom du fichier d'export qui sera utilisé sera le basé sur le nom de la
 * classe d'export
 * 
 * Created: 22 janv. 2006 21:12:58
 *
 * @author poussin
 * @version $Revision: 4218 $
 *
 * Last update: $Date: 2015-05-07 10:47:11 +0200 (jeu., 07 mai 2015) $
 * by : $Author: echatellier $
 */
public interface ExportInfo {

    /**
     * Necessary results names for export execution.
     * 
     * @return the necessaryResult name
     */
    public String[] getNecessaryResult();

    /**
     * Return ExportInfo description.
     * 
     * @return string displayable to the end user
     */
    public String getDescription();

    /**
     * Return filename used to contains export data.
     * 
     * @return filename by example "myexport"
     */
    public String getExportFilename();

    /**
     * Return extension used as filename name extension.
     * 
     * @return extension by example ".csv"
     */
    public String getExtensionFilename();

}
