/*
 * #%L
 * IsisFish
 * 
 * $Id: MigrationEquation.java 4156 2014-12-09 11:27:18Z echatellier $
 * $HeadURL: http://svn.codelutin.com/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/equation/MigrationEquation.java $
 * %%
 * Copyright (C) 2006 - 2011 Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.equation;

import org.nuiton.math.matrix.MatrixND;

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.util.Args;

/**
 * Migration equation.
 *
 * Created: 23 août 2006 12:05:14
 *
 * @author poussin
 * @version $Revision: 4156 $
 *
 * Last update: $Date: 2014-12-09 12:27:18 +0100 (mar., 09 déc. 2014) $
 * by : $Author: echatellier $
 */
public interface MigrationEquation {
    
    /**
     * Compute migration equation.
     * 
     * @param context simulation context
     * @param N effectif de la population
     * @param pop la population pour lequel on souhaite le coffecient de migration
     * @param group le group pour lequel on souhaite le coffecient de migration
     * @param departureZone la zone de depart de migration
     * @param arrivalZone la zone d'arrivé de migration
     * @return la proportion d'individu a migrer de la zone de depart a la zone
     * d'arrivé pour le groupe passé en argument
     * @throws Exception 
     */
    @Args({"context", "N", "pop", "group", "departureZone", "arrivalZone"})
    public double compute(SimulationContext context,
            MatrixND N, Population pop, PopulationGroup group,
            Zone departureZone, Zone arrivalZone) throws Exception;

}
