/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util;

import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.util.IsisCacheBackend;
import fr.ifremer.isisfish.util.IsisCacheBackendOnGuava;
import fr.ifremer.isisfish.util.Nocache;
import fr.ifremer.isisfish.util.Trace;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.nuiton.topia.persistence.TopiaEntity;

public class IsisCache {
    private static Log log = LogFactory.getLog(IsisCache.class);
    public static IsisCacheBackend.Factory defaultFactory = IsisCacheBackendOnGuava.factory;
    private static final int entityPackageLenght = "fr.ifremer.isisfish.entities.".length();
    private static final Object NULL = new Object();
    protected long totalCall = 0L;
    protected long cacheUsed = 0L;
    protected IsisCacheBackend cacheBackend;

    public IsisCache() {
        this(defaultFactory.createNew());
    }

    public IsisCache(IsisCacheBackend cacheBackend) {
        this.cacheBackend = cacheBackend;
    }

    protected Trace getTrace() {
        SimulationContext context = SimulationContext.get();
        Trace result = context.getTrace();
        return result;
    }

    public Object get(Method method, Object[] args, Object defaultValue) throws Throwable {
        ++this.totalCall;
        Object result = null;
        if (method.getAnnotation(Nocache.class) != null || method.getDeclaringClass().getAnnotation(Nocache.class) != null) {
            result = this.realCall(defaultValue);
        } else {
            String key;
            StringBuilder sbKey = new StringBuilder();
            TimeStep step = this.computeKey(sbKey, method, args);
            result = this.get(step, key = sbKey.toString().intern());
            if (result == null) {
                result = this.realCall(defaultValue);
                if (result != null) {
                    this.put(step, key, result);
                }
            } else {
                ++this.cacheUsed;
            }
        }
        return result;
    }

    protected TimeStep computeKey(StringBuilder sbKey, Method method, Object[] args) {
        TimeStep result = null;
        sbKey.append(method.getDeclaringClass().getSimpleName());
        sbKey.append(".");
        sbKey.append(method.getName());
        for (Object o : args) {
            sbKey.append(";");
            if (o == null) {
                sbKey.append("null");
                continue;
            }
            if (o instanceof Number || o instanceof String) {
                sbKey.append(o.toString());
                continue;
            }
            if (o instanceof TimeStep) {
                result = (TimeStep)o;
                sbKey.append(((TimeStep)o).getStep());
                continue;
            }
            if (o instanceof TopiaEntity) {
                sbKey.append(((TopiaEntity)o).getTopiaId().substring(entityPackageLenght));
                continue;
            }
            sbKey.append(o.getClass().getSimpleName());
            sbKey.append('@');
            sbKey.append(Integer.toHexString(System.identityHashCode(o)));
        }
        return result;
    }

    protected Object get(TimeStep step, String key) {
        Object result = this.cacheBackend.get(step, key);
        return result;
    }

    protected void put(TimeStep step, String key, Object value) {
        this.cacheBackend.put(step, key, value);
    }

    protected Object realCall(Object defaultValue) throws Throwable {
        Object result = defaultValue;
        if (defaultValue instanceof ProceedingJoinPoint) {
            result = ((ProceedingJoinPoint)defaultValue).proceed();
        }
        return result;
    }

    public void clear() {
        this.cacheBackend.clear();
    }

    public void clear(TimeStep step) {
        Object key = step;
        if (key == null) {
            key = NULL;
        }
        this.cacheBackend.removeStep(key);
    }

    public long getCacheUsed() {
        long result = this.cacheUsed;
        return result;
    }

    public long getTotalCall() {
        long result = this.totalCall;
        return result;
    }

    public String printStatistiqueAndClear() {
        this.cacheBackend.clear();
        StringBuilder result = new StringBuilder();
        result.append("--- Cache Statistiques ---\n");
        result.append("Total call: ").append(this.totalCall).append("\n");
        result.append("Cache used: ").append(this.cacheUsed).append("\n");
        long percent = 0L;
        if (this.totalCall != 0L) {
            percent = 100L * this.cacheUsed / this.totalCall;
        }
        result.append("Cache usage: ").append(percent).append("%\n");
        result.append(this.cacheBackend.getStat());
        result.append("--------------------\n");
        System.out.println(result.toString());
        return result.toString();
    }
}

