/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.util.ArgTypes;
import fr.ifremer.isisfish.util.Args;
import fr.ifremer.isisfish.util.CompileHelper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class EvaluatorHelper {
    private static Log log = LogFactory.getLog(EvaluatorHelper.class);
    protected static Pattern grepImportPattern = Pattern.compile("(?:^\\s*|(?<=;)\\s*)(import[^;]+;)", 40);
    private static final String HASH_CACHE_KEY = "__hashCache__";

    protected static String getHashCache(File fileCheckSum) {
        String result = "";
        SimulationContext context = SimulationContext.get();
        if (context == null) {
            if (fileCheckSum.exists()) {
                try {
                    result = FileUtils.readFileToString((File)fileCheckSum);
                }
                catch (IOException eee) {
                    log.info((Object)("Can't read old checkSum:  " + fileCheckSum), (Throwable)eee);
                }
            }
        } else {
            String key = HASH_CACHE_KEY;
            Map cache = (Map)context.getValue(key);
            if (cache != null) {
                result = StringUtils.defaultString((String)((String)cache.get(fileCheckSum.getPath())));
            }
        }
        return result;
    }

    protected static void setHashCache(File fileCheckSum, String hashcode) {
        SimulationContext context = SimulationContext.get();
        if (context == null) {
            try {
                FileUtils.writeStringToFile((File)fileCheckSum, (String)hashcode);
            }
            catch (IOException eee) {
                log.info((Object)("Can't write checkSum:  " + fileCheckSum), (Throwable)eee);
            }
        } else {
            HashMap<String, String> cache = (HashMap<String, String>)context.getValue(HASH_CACHE_KEY);
            if (cache == null) {
                cache = new HashMap<String, String>();
                context.setValue(HASH_CACHE_KEY, cache);
            }
            cache.put(fileCheckSum.getPath(), hashcode);
        }
    }

    protected static String normalizeClassName(String name) {
        StringBuilder result = new StringBuilder(name);
        for (int i = 0; i < result.length(); ++i) {
            char c = result.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            result.setCharAt(i, '_');
        }
        return result.toString();
    }

    public static int check(Class javaInterface, String script, PrintWriter out) {
        try {
            File src = File.createTempFile("check", "equation");
            src.deleteOnExit();
            String packageName = null;
            String className = EvaluatorHelper.normalizeClassName(src.getName());
            src = new File(src.getParentFile(), className + ".java");
            src.deleteOnExit();
            Method[] methods = javaInterface.getDeclaredMethods();
            Method interfaceMethod = methods[0];
            String content = EvaluatorHelper.generateContent(packageName, className, interfaceMethod, script);
            FileUtils.writeStringToFile((File)src, (String)content, (String)"utf-8");
            int compileResult = CompileHelper.compile(src.getParentFile(), src, src.getParentFile(), out);
            File dest = new File(src.getParentFile(), className + ".class");
            dest.deleteOnExit();
            return compileResult;
        }
        catch (Exception eee) {
            log.warn((Object)"Can't check equation", (Throwable)eee);
            return -10000;
        }
    }

    public static Object evaluate(String packageName, String className, Class javaInterface, String script, Object ... args) {
        className = EvaluatorHelper.normalizeClassName(className);
        Object result = null;
        Class<?> clazz = null;
        Method[] methods = javaInterface.getDeclaredMethods();
        Method interfaceMethod = methods[0];
        String classname = packageName + "." + className;
        File fileRootSrc = IsisFish.config.getCompileDirectory();
        File fileCheckSum = new File(fileRootSrc, packageName + File.separator + className + ".hashCode");
        File fileSrc = new File(fileRootSrc, packageName + File.separator + className + ".java");
        String oldCheckSum = EvaluatorHelper.getHashCache(fileCheckSum);
        String newCheckSum = Integer.toString(script.hashCode());
        boolean checkSumEquals = newCheckSum.equals(oldCheckSum);
        if (!checkSumEquals) {
            String content = EvaluatorHelper.generateContent(packageName, className, interfaceMethod, script);
            try {
                FileUtils.writeStringToFile((File)fileSrc, (String)content, (String)"utf-8");
                EvaluatorHelper.setHashCache(fileCheckSum, Integer.toString(script.hashCode()));
                EvaluatorHelper.setHashCache(fileCheckSum, Integer.toString(script.hashCode()));
            }
            catch (IOException zzz) {
                throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.save.script.compilation", (Object[])new Object[]{fileSrc}), zzz);
            }
            EvaluatorHelper.compile(fileRootSrc, fileSrc);
        }
        try {
            ClassLoader cl = IsisFish.config.getScriptClassLoader();
            clazz = cl.loadClass(classname);
        }
        catch (Exception ex) {
            EvaluatorHelper.compile(fileRootSrc, fileSrc);
            try {
                ClassLoader cl = IsisFish.config.getScriptClassLoader();
                clazz = cl.loadClass(classname);
            }
            catch (Exception ex2) {
                throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.compile.script", (Object[])new Object[]{fileSrc}), ex2);
            }
        }
        result = EvaluatorHelper.invoke(clazz, interfaceMethod, args);
        return result;
    }

    protected static void compile(File fileRootSrc, File fileSrc) {
        try {
            ArrayList<File> classpath = new ArrayList<File>();
            classpath.add(fileRootSrc.getAbsoluteFile());
            classpath.add(IsisFish.config.getDatabaseDirectory().getAbsoluteFile());
            int compileResult = CompileHelper.compile(classpath, Collections.singletonList(fileSrc), fileRootSrc, null);
            if (compileResult != 0) {
                throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.compile.script", (Object[])new Object[]{compileResult, fileSrc}));
            }
        }
        catch (Exception zzz) {
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.compile.script", (Object[])new Object[]{fileSrc}), zzz);
        }
    }

    protected static String generateContent(String packageName, String className, Method interfaceMethod, String script) {
        String[] stringTypes;
        StringBuilder imports = new StringBuilder();
        StringBuilder code = new StringBuilder();
        EvaluatorHelper.grepImport(script, imports, code);
        String content = "";
        if (packageName != null && !"".equals(packageName)) {
            content = content + "package " + packageName + ";";
        }
        content = content + "import java.util.*;";
        content = content + "import java.io.*;";
        content = content + "import fr.ifremer.isisfish.entities.*;";
        content = content + "import fr.ifremer.isisfish.types.*;";
        content = content + "import org.nuiton.math.matrix.*;";
        content = content + "import org.apache.commons.logging.*;";
        content = content + imports.toString();
        content = content + "public class " + className + " implements " + interfaceMethod.getDeclaringClass().getName() + " {";
        content = content + "private static Log log = LogFactory.getLog(" + className + ".class);";
        content = content + "public " + interfaceMethod.getReturnType().getName() + " " + interfaceMethod.getName() + "(";
        Args args = interfaceMethod.getAnnotation(Args.class);
        String[] names = args.value();
        ArgTypes argTypes = interfaceMethod.getAnnotation(ArgTypes.class);
        if (argTypes != null) {
            stringTypes = argTypes.value();
        } else {
            stringTypes = new String[names.length];
            Class<?>[] types = interfaceMethod.getParameterTypes();
            for (int i = 0; i < types.length; ++i) {
                stringTypes[i] = types[i].getName();
            }
        }
        for (int i = 0; i < names.length; ++i) {
            content = content + stringTypes[i] + " " + names[i];
            if (i + 1 >= names.length) continue;
            content = content + ", ";
        }
        content = content + ") throws Exception {";
        content = content + code.toString();
        content = content + "\n}\n}\n";
        return content;
    }

    protected static void grepImport(String code, StringBuilder imports, StringBuilder others) {
        Matcher matches = grepImportPattern.matcher(code);
        int pos = 0;
        while (matches.find()) {
            int begin = matches.start(1);
            int end = matches.end(1);
            others.append(code.substring(pos, begin));
            imports.append(code.substring(begin, end));
            pos = end;
        }
        others.append(code.substring(pos));
    }

    protected static Object invoke(Class clazz, Method interfaceMethod, Object ... args) {
        Object result;
        try {
            Method method = clazz.getDeclaredMethod(interfaceMethod.getName(), interfaceMethod.getParameterTypes());
            Object eq = clazz.newInstance();
            result = method.invoke(eq, args);
        }
        catch (Exception eee) {
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.invoke.method", (Object[])new Object[]{interfaceMethod, clazz.getName()}), eee);
        }
        return result;
    }
}

