/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.widget.filter;

import fr.ifremer.isisfish.ui.widget.filter.FilterParamModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class FilterModel<M, R> {
    private static final Log log = LogFactory.getLog(FilterModel.class);
    protected List<M> original;
    protected List<M> result;
    protected List<String> paramKeys;
    protected Map<String, FilterParamModel<M, ?>> paramModels;
    protected boolean exclusiveMode = false;

    public abstract R convertToResult(M var1);

    protected FilterModel(List<M> original, Map<String, FilterParamModel<M, ?>> paramModels) {
        this.original = original;
        this.paramModels = paramModels;
        this.result = new ArrayList<M>();
    }

    public FilterParamModel<M, ?> getParamModel(String paramKey) {
        return this.paramModels.get(paramKey);
    }

    public void reset() {
        for (FilterParamModel<M, ?> paramModel : this.paramModels.values()) {
            paramModel.reset();
        }
        this.result.clear();
    }

    public List<M> doFilter() {
        List<FilterParamModel<M, ?>> paramToUse = this.getParamsToUse();
        List<M> list = this.exclusiveMode ? this.exclusiveAccept(paramToUse) : this.inclusiveAccept(paramToUse);
        log.debug((Object)("<-- " + this));
        return list;
    }

    public void selectAll() {
        this.reset();
        this.result.addAll(this.original);
    }

    public List<M> getFiltered() {
        return this.result;
    }

    public List<R> getFilteredResult() {
        ArrayList<R> result = new ArrayList<R>();
        for (M m : this.result) {
            result.add(this.convertToResult(m));
        }
        return result;
    }

    public List<M> getOriginal() {
        return this.original;
    }

    public int getNbResult() {
        return this.result.size();
    }

    public int getNbOriginal() {
        return this.original.size();
    }

    private List<FilterParamModel<M, ?>> getParamsToUse() {
        ArrayList paramToUse = new ArrayList();
        for (FilterParamModel<M, ?> paramModel : this.paramModels.values()) {
            if (paramModel.state != FilterParamModel.State.USE) continue;
            paramToUse.add(paramModel);
        }
        return paramToUse;
    }

    private List<M> inclusiveAccept(List<FilterParamModel<M, ?>> paramToUse) {
        for (M m : this.original) {
            boolean accept = this.inclusiveAccept(paramToUse, m);
            if (!accept) continue;
            this.result.add(m);
        }
        this.setParamResultState(paramToUse);
        return this.result;
    }

    private List<M> exclusiveAccept(List<FilterParamModel<M, ?>> paramToUse) {
        for (M m : this.original) {
            boolean accept = this.exclusiveAccept(paramToUse, m);
            if (!accept) continue;
            this.result.add(m);
        }
        this.setParamResultState(paramToUse);
        return this.result;
    }

    private void setParamResultState(List<FilterParamModel<M, ?>> paramToUse) {
        for (FilterParamModel<M, ?> paramModel : paramToUse) {
            paramModel.resultState = paramModel.hits == 0 ? FilterParamModel.ResultState.KO : FilterParamModel.ResultState.OK;
        }
    }

    private boolean inclusiveAccept(List<FilterParamModel<M, ?>> paramToUse, M m) {
        boolean result = false;
        for (FilterParamModel<M, ?> paramModel : paramToUse) {
            if (!paramModel.accept(m)) continue;
            result = true;
        }
        return result;
    }

    private boolean exclusiveAccept(List<FilterParamModel<M, ?>> paramToUse, M m) {
        boolean result = true;
        for (FilterParamModel<M, ?> paramModel : paramToUse) {
            if (paramModel.accept(m)) continue;
            result = false;
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" (nbOriginal ").append(this.getNbOriginal()).append(')');
        sb.append(" (nbFiltered ").append(this.getNbResult()).append(')');
        for (FilterParamModel<M, ?> paramModel : this.getParamsToUse()) {
            sb.append('\n').append(paramModel);
        }
        return sb.toString();
    }

    public void setFiltered(List<M> filtered) {
        this.result.clear();
        this.result.addAll(filtered);
    }
}

