/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.sensitivity.wizard;

import fr.ifremer.isisfish.simulator.sensitivity.Distribution;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.ui.sensitivity.wizard.ContinuousPanel;
import fr.ifremer.isisfish.ui.sensitivity.wizard.DistributionListRenderer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ContinuousDistributionPanel
extends ContinuousPanel
implements ItemListener {
    private static Log log = LogFactory.getLog(ContinuousDistributionPanel.class);
    private static final long serialVersionUID = 2289588676194644582L;
    protected JComboBox<Distribution> distributionCombo;
    protected JPanel dynamicPanel;
    protected Object originalValue;
    protected List<JComponent> paramComponents = new ArrayList<JComponent>();

    public ContinuousDistributionPanel(Object originalValue) {
        this.setLayout(new GridBagLayout());
        JLabel distributionLabel = new JLabel(I18n.t((String)"isisfish.sensitivity.distribution", (Object[])new Object[0]));
        this.add((Component)distributionLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.distributionCombo = new JComboBox<Distribution>(Distribution.values());
        this.distributionCombo.setSelectedItem(null);
        this.distributionCombo.addItemListener(this);
        this.distributionCombo.setRenderer(new DistributionListRenderer());
        this.add(this.distributionCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.dynamicPanel = new JPanel(new GridBagLayout());
        this.add((Component)this.dynamicPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.originalValue = originalValue;
    }

    @Override
    public void initWithFactor(Factor factor) {
        ContinuousDomain domain = (ContinuousDomain)factor.getDomain();
        if (domain == null) {
            return;
        }
        Distribution distrib = domain.getDistribution();
        this.distributionCombo.setSelectedItem((Object)distrib);
        Distribution.DistributionParam[] params = distrib.getDistibutionParams();
        int paramComponentIndex = 0;
        for (Distribution.DistributionParam param : params) {
            Object value = domain.getDistributionParameters().get(param.getName());
            if (value != null) {
                JComponent comp = this.paramComponents.get(paramComponentIndex);
                ((JTextComponent)comp).setText(value.toString());
            } else if (log.isWarnEnabled()) {
                log.warn((Object)("Param " + param.getName() + " not found during init"));
            }
            ++paramComponentIndex;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Distribution.DistributionParam[] params;
        if (e.getStateChange() != 1) {
            return;
        }
        Distribution distrib = (Distribution)((Object)e.getItem());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Refreshing component for distribution : " + (Object)((Object)distrib)));
        }
        this.dynamicPanel.removeAll();
        this.paramComponents.clear();
        if (distrib == null) {
            return;
        }
        int index = 0;
        JLabel paramDetailsLabel = new JLabel(I18n.t((String)"isisfish.sensitivity.distribution.parameters", (Object[])new Object[]{distrib.getDescription()}));
        this.dynamicPanel.add((Component)paramDetailsLabel, new GridBagConstraints(0, index, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        ++index;
        for (Distribution.DistributionParam param : params = distrib.getDistibutionParams()) {
            JLabel paramLabel = new JLabel(param.getName() + " :");
            paramLabel.setToolTipText(param.getDescription());
            JComponent paramField = this.getParamField(param);
            paramField.setToolTipText(param.getDescription());
            this.dynamicPanel.add((Component)paramLabel, new GridBagConstraints(0, index, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.dynamicPanel.add((Component)paramField, new GridBagConstraints(1, index, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            ++index;
            this.paramComponents.add(paramField);
        }
        this.repaint();
        this.validate();
    }

    protected JComponent getParamField(Distribution.DistributionParam param) {
        JTextField result = param.isOriginalValue() ? new JTextField(this.originalValue.toString()) : new JTextField();
        return result;
    }

    @Override
    public boolean isFactorValid() {
        return true;
    }

    public Distribution getDistribution() {
        return (Distribution)((Object)this.distributionCombo.getSelectedItem());
    }

    public ContinuousDomain generateDomain() {
        Distribution distrib = (Distribution)((Object)this.distributionCombo.getSelectedItem());
        ContinuousDomain domain = new ContinuousDomain(distrib);
        Distribution.DistributionParam[] params = distrib.getDistibutionParams();
        int paramComponentIndex = 0;
        for (Distribution.DistributionParam param : params) {
            JComponent comp = this.paramComponents.get(paramComponentIndex);
            String strValue = ((JTextComponent)comp).getText().trim();
            domain.addDistributionParam(param.getName(), Double.parseDouble(strValue));
            ++paramComponentIndex;
        }
        return domain;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.distributionCombo.setSelectedItem(null);
        }
        this.distributionCombo.setEnabled(enabled);
    }
}

