/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.sensitivity;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.mexico.MexicoHelper;
import fr.ifremer.isisfish.simulator.sensitivity.DesignPlan;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.FactorGroup;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import fr.ifremer.isisfish.ui.input.InputHandler;
import fr.ifremer.isisfish.ui.input.InputOneEquationUI;
import fr.ifremer.isisfish.ui.input.tree.FisheryDataProvider;
import fr.ifremer.isisfish.ui.input.tree.FisheryTreeHelper;
import fr.ifremer.isisfish.ui.input.tree.FisheryTreeNode;
import fr.ifremer.isisfish.ui.input.tree.FisheryTreeRenderer;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityTabUI;
import fr.ifremer.isisfish.ui.sensitivity.wizard.FactorWizardUI;
import fr.ifremer.isisfish.ui.sensitivity.wizard.SensitivityWizardHandler;
import fr.ifremer.isisfish.ui.simulator.RuleChooser;
import fr.ifremer.isisfish.ui.simulator.SimulAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityContextable;
import org.nuiton.util.FileUtil;

public class SensitivityInputHandler
extends InputHandler {
    private static Log log = LogFactory.getLog(SensitivityInputHandler.class);

    public void loadFisheryRegionTree(SensitivityTabUI sensitivityTabUI) {
        FisheryRegion fisheryRegion = sensitivityTabUI.getFisheryRegion();
        if (fisheryRegion == null) {
            sensitivityTabUI.getCardlayoutPrincipal().show(sensitivityTabUI.getInputPanePrincipal(), "none");
            DefaultTreeModel model = new DefaultTreeModel(null);
            sensitivityTabUI.getFisheryRegionTree().setModel(model);
        } else {
            FisheryTreeHelper treeHelper = new FisheryTreeHelper();
            FisheryDataProvider dataProvider = new FisheryDataProvider(fisheryRegion);
            treeHelper.setDataProvider(dataProvider);
            TreeModel model = treeHelper.createTreeModel(fisheryRegion);
            sensitivityTabUI.getFisheryRegionTree().setModel(model);
            sensitivityTabUI.getFisheryRegionTree().setCellRenderer(new FisheryTreeRenderer(dataProvider));
            treeHelper.setUI(sensitivityTabUI.getFisheryRegionTree(), true, false, null);
            sensitivityTabUI.setContextValue(fisheryRegion);
            sensitivityTabUI.setContextValue(treeHelper);
            sensitivityTabUI.setContextValue(model);
            sensitivityTabUI.setContextValue(fisheryRegion.getTopiaContext());
            sensitivityTabUI.getCardlayoutPrincipal().show(sensitivityTabUI.getInputPanePrincipal(), "normale");
        }
    }

    public void nodeSelectionChanged(SensitivityTabUI sensitivityTabUI, TreeSelectionEvent event) {
        Object lastTreePath;
        TreePath newTreePath = event.getNewLeadSelectionPath();
        if (newTreePath != null && (lastTreePath = newTreePath.getLastPathComponent()) instanceof FisheryTreeNode) {
            FisheryTreeNode isisTreeNode = (FisheryTreeNode)((Object)lastTreePath);
            Class internalClass = isisTreeNode.getInternalClass();
            TopiaEntityContextable topiaEntity = null;
            String topiaId = isisTreeNode.getId();
            try {
                if (isisTreeNode.isStaticNode()) {
                    FisheryRegion fisheryRegion = sensitivityTabUI.getContextValue(FisheryRegion.class);
                    TopiaContext topiaContext = fisheryRegion.getTopiaContext();
                    topiaEntity = (TopiaEntityContextable)topiaContext.findByTopiaId(topiaId);
                }
                InputContentUI<?> inputContentUI = this.getUIInstanceForBeanClass(internalClass, sensitivityTabUI);
                inputContentUI.getSaveVerifier().reset();
                if (topiaEntity != null) {
                    inputContentUI.getSaveVerifier().addCurrentEntity(topiaEntity);
                    inputContentUI.getSaveVerifier().setInputContentUI(inputContentUI);
                }
                inputContentUI.setBean(topiaEntity);
                inputContentUI.setActive(topiaEntity != null);
                inputContentUI.setLayer(true);
                inputContentUI.setSensitivity(true);
                sensitivityTabUI.getCardlayoutPrincipal().show(sensitivityTabUI.getInputPanePrincipal(), "normale");
                sensitivityTabUI.getInputPane().removeAll();
                sensitivityTabUI.getInputPane().add(inputContentUI, "Center");
                sensitivityTabUI.getInputPane().repaint();
                sensitivityTabUI.getInputPane().validate();
            }
            catch (Exception ex) {
                throw new IsisFishRuntimeException("Can't display bean " + topiaId, ex);
            }
        }
    }

    public void addNewFactorGroup(SensitivityTabUI sensitivityTabUI, boolean continuous) {
        String factorName = JOptionPane.showInputDialog(sensitivityTabUI, I18n.t((String)"isisfish.sensitivity.newfactorname", (Object[])new Object[0]), I18n.t((String)"isisfish.sensitivity.title", (Object[])new Object[0]), 3);
        if (StringUtils.isNotBlank((CharSequence)factorName)) {
            FactorGroup rootFactorGroup = sensitivityTabUI.getSimulAction().getFactorGroup();
            FactorGroup factorGroup = new FactorGroup(factorName, continuous);
            rootFactorGroup.addFactor(factorGroup);
            sensitivityTabUI.setFactorModel();
        }
    }

    public void moveFactor(SensitivityTabUI sensitivityTabUI, FactorGroup selectedFactorGroup, List<Factor> movedFactors) {
        try {
            selectedFactorGroup.addAllFactors(movedFactors);
            FactorGroup rootFactorGroup = sensitivityTabUI.getSimulAction().getFactorGroup();
            if (!rootFactorGroup.equals(selectedFactorGroup)) {
                rootFactorGroup.removeAll(movedFactors);
            }
            for (int index = 0; index < rootFactorGroup.size(); ++index) {
                FactorGroup factorGroup;
                Factor factor = rootFactorGroup.get(index);
                if (!(factor instanceof FactorGroup) || (factorGroup = (FactorGroup)factor).equals(selectedFactorGroup)) continue;
                factorGroup.removeAll(movedFactors);
            }
            sensitivityTabUI.setFactorModel();
        }
        catch (IllegalArgumentException ex) {
            JOptionPane.showMessageDialog(sensitivityTabUI, I18n.t((String)"isisfish.sensitivity.moveillegal", (Object[])new Object[0]), I18n.t((String)"isisfish.sensitivity.title", (Object[])new Object[0]), 0);
        }
    }

    public void factorsTreeMouseClicked(final SensitivityTabUI sensitivityTabUI, MouseEvent e) {
        if (e.getButton() == 3) {
            JPopupMenu menu = new JPopupMenu();
            JMenuItem menuItemDelete = new JMenuItem(I18n.t((String)"isisfish.common.delete", (Object[])new Object[0]));
            menuItemDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SensitivityInputHandler.this.deleteSelectedFactors(sensitivityTabUI);
                }
            });
            menu.add(menuItemDelete);
            menu.show(e.getComponent(), e.getX(), e.getY());
        } else if (e.getButton() == 1 && e.getClickCount() == 2) {
            this.factorSelected(sensitivityTabUI);
        }
    }

    protected void factorSelected(SensitivityTabUI sensitivityTabUI) {
        Object[] pathWay;
        Object selectedObject;
        TreePath selectedPath = sensitivityTabUI.getFactorsTree().getSelectionPath();
        if (selectedPath != null && (selectedObject = (pathWay = selectedPath.getPath())[pathWay.length - 1]) != null && !(selectedObject instanceof FactorGroup)) {
            Factor selectedFactor = (Factor)selectedObject;
            FactorWizardUI factorWizardUI = new FactorWizardUI((JAXXContext)sensitivityTabUI);
            SensitivityWizardHandler handler = factorWizardUI.getHandler();
            handler.initExistingFactor(factorWizardUI, selectedFactor);
            factorWizardUI.pack();
            factorWizardUI.setLocationRelativeTo(sensitivityTabUI);
            factorWizardUI.setVisible(true);
        }
    }

    protected void deleteSelectedFactors(SensitivityTabUI sensitivityTabUI) {
        Object[] selectedPaths = sensitivityTabUI.getFactorsTree().getSelectionPaths();
        if (!ArrayUtils.isEmpty((Object[])selectedPaths)) {
            for (Object selectedPath : selectedPaths) {
                Object selectedObject;
                Object[] pathWay = ((TreePath)selectedPath).getPath();
                if (pathWay.length < 2 || (selectedObject = pathWay[pathWay.length - 1]) == null || !(selectedObject instanceof Factor)) continue;
                Factor selectedFactor = (Factor)selectedObject;
                FactorGroup selectedFactorGroup = (FactorGroup)pathWay[pathWay.length - 2];
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleting factor " + selectedFactor.getName()));
                }
                selectedFactorGroup.remove(selectedFactor);
                sensitivityTabUI.setFactorModel();
            }
        }
    }

    public boolean canBeFactor(Class type) {
        boolean result = false;
        if (TopiaEntity.class.isAssignableFrom(type)) {
            result = true;
        } else if (Double.TYPE.isAssignableFrom(type)) {
            result = true;
        } else if (Number.class.isAssignableFrom(type)) {
            result = true;
        } else if (TimeStep.class.isAssignableFrom(type)) {
            result = true;
        } else if (Month.class.isAssignableFrom(type)) {
            result = true;
        }
        return result;
    }

    protected Object getComponentValue(JComponent component) {
        Object result = null;
        if (component instanceof JTextComponent) {
            result = ((JTextComponent)component).getText();
        } else if (component instanceof MatrixPanelEditor) {
            result = ((MatrixPanelEditor)component).getMatrix();
        } else if (component instanceof InputOneEquationUI) {
            result = ((InputOneEquationUI)component).getEditor().getText();
        } else if (component instanceof RuleChooser) {
            result = ((RuleChooser)((Object)component)).getRulesList();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Value for component : " + component.getClass().getSimpleName() + " is " + result));
        }
        return result;
    }

    public void exportFactorsToMexico(SensitivityTabUI view) {
        File xmlFile = FileUtil.getFile((String)I18n.t((String)"isisfish.sensitivity.mexico.exporttoxml.title", (Object[])new Object[0]), (String)I18n.t((String)"isisfish.sensitivity.mexico.exporttoxml.approve", (Object[])new Object[0]), (Component)view, (String[])new String[]{".*\\.xml", I18n.t((String)"isisfish.sensitivity.mexico.exporttoxml.filter", (Object[])new Object[0])});
        if (xmlFile != null) {
            if (!FilenameUtils.isExtension((String)xmlFile.getAbsolutePath(), (String)"xml")) {
                xmlFile = new File(xmlFile.getAbsolutePath() + ".xml");
            }
            SimulAction simulAction = view.getContextValue(SimulAction.class);
            DesignPlan designPlan = new DesignPlan();
            designPlan.setFactorGroup(simulAction.getFactorGroup());
            String xml = MexicoHelper.getDesignPlanAsXML(designPlan, new String[0]);
            MexicoHelper.writeDesignPlanToFile(xmlFile, designPlan);
        }
    }
}

