/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.models.optimization;

import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ObjectiveStorage;
import fr.ifremer.isisfish.simulator.Objective;
import fr.ifremer.isisfish.ui.util.TooltipHelper;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import org.nuiton.i18n.I18n;

public class ObjectiveComboRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = -4070846632975105788L;
    protected Map<String, Objective> objectiveCache = new HashMap<String, Objective>();

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel c = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        String objectiveName = (String)value;
        c.setText(objectiveName);
        try {
            Objective objective = this.objectiveCache.get(objectiveName);
            if (objective == null) {
                ObjectiveStorage storage = ObjectiveStorage.getObjective(objectiveName, new CodeSourceStorage.Location[0]);
                objective = (Objective)storage.getNewInstance();
                this.objectiveCache.put(objectiveName, objective);
            }
            c.setToolTipText(objective.getDescription());
        }
        catch (Exception e) {
            String errorTooltip = TooltipHelper.getErrorTooltip(I18n.t((String)"isisfish.error.compile.fileerror", (Object[])new Object[]{objectiveName}));
            c.setToolTipText(errorTooltip);
        }
        return c;
    }
}

