/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.variable;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.entities.Variable;
import fr.ifremer.isisfish.entities.VariableDAO;
import fr.ifremer.isisfish.entities.VariableType;
import fr.ifremer.isisfish.ui.input.model.TopiaEntityListModel;
import fr.ifremer.isisfish.ui.input.variable.EntityVariableUI;
import java.awt.CardLayout;
import java.util.List;
import javax.swing.JList;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityContextable;

public class EntityVariableHandler {
    private static Log log = LogFactory.getLog(EntityVariableHandler.class);

    public void initView(EntityVariableUI view) {
        TopiaEntityListModel model;
        List variables;
        block6: {
            view.getVariablesList().clearSelection();
            variables = null;
            model = (TopiaEntityListModel)view.getVariablesList().getModel();
            TopiaEntityContextable bean = view.getBean();
            if (bean != null) {
                try {
                    TopiaContext context = view.getTopiaContext();
                    VariableDAO dao = IsisFishDAOHelper.getVariableDAO(context);
                    variables = dao.findAllByEntityId(bean.getTopiaId());
                }
                catch (TopiaException ex) {
                    throw new IsisFishRuntimeException("Can't init view", ex);
                }
                try {
                    String name = BeanUtils.getProperty((Object)view.getBean(), (String)"name");
                    view.getVariableEntityName().setText(name);
                }
                catch (Exception ex) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"Can't get entity name", (Throwable)ex);
                    }
                    break block6;
                }
            }
            view.getVariableEntityName().setText("");
        }
        model.setEntities(variables);
    }

    public void addNewVariable(EntityVariableUI view) {
        try {
            TopiaContext context = view.getTopiaContext();
            VariableDAO dao = IsisFishDAOHelper.getVariableDAO(context);
            Variable variable = (Variable)dao.create(new Object[]{"entityId", view.getBean().getTopiaId(), "name", I18n.t((String)"isisfish.variables.defaultname", (Object[])new Object[0])});
            TopiaEntityListModel model = (TopiaEntityListModel)view.getVariablesList().getModel();
            List<? extends TopiaEntity> variables = model.getElements();
            variables.add((TopiaEntity)variable);
            model.setEntities(variables);
            view.getVariablesList().setSelectedValue(variable, true);
        }
        catch (TopiaException ex) {
            throw new IsisFishRuntimeException("Can't add variable", ex);
        }
    }

    public void deleteVariable(EntityVariableUI view) {
        JList variableList = view.getVariablesList();
        Variable variable = (Variable)variableList.getSelectedValue();
        try {
            TopiaContext context = view.getTopiaContext();
            VariableDAO dao = IsisFishDAOHelper.getVariableDAO(context);
            dao.delete((TopiaEntity)variable);
            context.commitTransaction();
            view.getVariablesList().clearSelection();
            TopiaEntityListModel model = (TopiaEntityListModel)view.getVariablesList().getModel();
            List<? extends TopiaEntity> variables = model.getElements();
            variables.remove(variable);
            model.setEntities(variables);
        }
        catch (TopiaException ex) {
            throw new IsisFishRuntimeException("Can't delete variable", ex);
        }
    }

    public void showSelectedVariable(EntityVariableUI view) {
        JList variableList = view.getVariablesList();
        Variable variable = (Variable)variableList.getSelectedValue();
        view.setVariable(variable);
        view.getSaveVerifier().addCurrentEntity(variable);
    }

    public void showSelectedType(EntityVariableUI view) {
        CardLayout cardLayout = view.getVariableTypeLayout();
        VariableType type = (VariableType)((Object)view.getVariableTypeCombo().getSelectedItem());
        view.getVariable().setType(type);
        switch (type) {
            case DOUBLE: {
                cardLayout.show(view.getVariableTypePanel(), "doubletype");
                break;
            }
            case EQUATION: {
                cardLayout.show(view.getVariableTypePanel(), "equationtype");
                break;
            }
            case MATRIX: {
                cardLayout.show(view.getVariableTypePanel(), "matrixtype");
            }
        }
    }

    public void saveVariable(EntityVariableUI view) {
        JList variableList = view.getVariablesList();
        Variable variable = (Variable)variableList.getSelectedValue();
        variable.setName(view.getVariableNameField().getText().trim());
        VariableType type = (VariableType)((Object)view.getVariableTypeCombo().getSelectedItem());
        switch (type) {
            case DOUBLE: {
                try {
                    double v = Double.parseDouble(view.getVariableDoubleValue().getText().trim());
                    variable.setDoubleValue(v);
                }
                catch (NumberFormatException ex) {
                    if (!log.isWarnEnabled()) break;
                    log.warn((Object)"Can't parse double value as double", (Throwable)ex);
                }
                break;
            }
            case MATRIX: {
                variable.setMatrixValue(view.getMatrixPanel().getMatrix());
            }
        }
        view.getSaveVerifier().save();
        TopiaEntityListModel model = (TopiaEntityListModel)view.getVariablesList().getModel();
        List<? extends TopiaEntity> variables = model.getElements();
        model.setEntities(variables);
    }
}

