/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.logging.io;

import fr.ifremer.isisfish.logging.LogLevel;
import fr.ifremer.isisfish.logging.io.LineReader;
import fr.ifremer.isisfish.logging.io.OffsetReader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class LineReaderUtil {

    public static class LevelsLineReader
    extends LineReader {
        protected List<String> levels = new ArrayList<String>();

        public LevelsLineReader(File file, OffsetReader offsetReader, LogLevel ... level) {
            super(file, offsetReader);
            for (LogLevel logLevel : level) {
                this.levels.add(logLevel.toString());
            }
        }

        public LevelsLineReader(LineReader parent, OffsetReader offsetReader, LogLevel ... levels) {
            super(parent, offsetReader);
            for (LogLevel level : levels) {
                if (this.levels.contains(level.toString())) continue;
                this.levels.add(level.toString());
            }
        }

        @Override
        public boolean match(String line) {
            if (this.levels.isEmpty()) {
                return true;
            }
            for (String s : this.levels) {
                if (!line.startsWith(s)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            return "(levels:" + this.levels + ')' + super.toString();
        }
    }

    public static class LevelLineReader
    extends LineReader {
        protected String level;

        public LevelLineReader(File file, OffsetReader offsetReader, LogLevel level) {
            super(file, offsetReader);
            this.level = level.toString();
        }

        public LevelLineReader(LineReader parent, OffsetReader offsetReader, LogLevel level) {
            super(parent, offsetReader);
            this.level = level.toString();
        }

        @Override
        public boolean match(String line) {
            return line.startsWith(this.level);
        }

        @Override
        public String toString() {
            return "(level:" + this.level + ')' + super.toString();
        }
    }

    public static class PatternLineReader
    extends LineReader {
        protected Pattern pattern;

        public PatternLineReader(File file, OffsetReader offsetReader, String level, int flags) {
            super(file, offsetReader);
            this.pattern = Pattern.compile(level, flags);
        }

        public PatternLineReader(LineReader parent, OffsetReader offsetReader, String level, int flags) {
            super(parent, offsetReader);
            this.pattern = Pattern.compile(level, flags);
        }

        @Override
        public boolean match(String line) {
            return this.pattern.matcher(line).matches();
        }

        @Override
        public String toString() {
            return "(pattern:" + this.pattern + ')' + super.toString();
        }
    }
}

