/*
 * #%L
 * IsisFish
 * 
 * $Id: JaxxUtil.java 3969 2014-04-17 16:48:13Z echatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.util;

import jaxx.runtime.JAXXObject;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import java.util.Map;

/** some util generic algorithm  for jaxx objects */
public class JaxxUtil {

    public static void doReset(Map<String, ?> $objectMap) {

        if ($objectMap == null) return;

        for (Map.Entry<String, ?> o : $objectMap.entrySet()) {
            Class aClass = o.getValue().getClass();
            Object val = o.getValue();
            if (JTextField.class.isAssignableFrom(aClass))
                ((JTextField) val).setText("");
            else if (JCheckBox.class.isAssignableFrom(aClass))
                ((JCheckBox) val).setSelected(false);
            else if (JComboBox.class.isAssignableFrom(aClass))
                ((JComboBox) val).setSelectedIndex(-1);
        }
    }

    /**
     * Refresh dialog and process data binding for given keys
     *
     * @param dial     jaxx dialog
     * @param keyFirst first to refresh
     * @param keys     keys to refresh
     */
    public static void refresh(JAXXObject dial, String keyFirst, String... keys) {
        if (!IDialog.class.isAssignableFrom(dial.getClass())) return;

        IDialog dialog = (IDialog) dial;
        dialog.getOk().setEnabled(dialog.isOkEnabled());
        dial.processDataBinding(keyFirst);
        for (String key : keys) dial.processDataBinding(key);
        dialog.repaint();
    }
}

