/*
 * #%L
 * IsisFish
 * 
 * $Id: SensitivityAnalysisListModel.java 3969 2014-04-17 16:48:13Z echatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.models.sensitivityanalysis;

import java.util.List;

import javax.swing.AbstractListModel;

import fr.ifremer.isisfish.simulator.sensitivity.SensitivityAnalysis;

/**
 * Model pour la liste des instances de calculateurs.
 *
 * @author chatellier
 * @version $Revision: 3969 $
 * 
 * Last update : $Date: 2014-04-17 18:48:13 +0200 (jeu., 17 avril 2014) $
 * By : $Author: echatellier $
 */
public class SensitivityAnalysisListModel extends AbstractListModel<SensitivityAnalysis> {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4070846632975105788L;

    protected List<SensitivityAnalysis> sensitivityAnalysis;

    /**
     * Empty constructor.
     */
    public SensitivityAnalysisListModel() {
        this(null);
    }

    /**
     * Constructor with list.
     * 
     * @param sensitivityAnalysis analysis list
     */
    public SensitivityAnalysisListModel(List<SensitivityAnalysis> sensitivityAnalysis) {
        setSensitivityAnalysis(sensitivityAnalysis);
    }

    /**
     * Get analysis list.
     * 
     * @return the analysis
     */
    public List<SensitivityAnalysis> getSensitivityAnalysis() {
        return sensitivityAnalysis;
    }

    /**
     * Set analysis list.
     * 
     * @param sensitivityAnalysis the analysis to set
     */
    public void setSensitivityAnalysis(List<SensitivityAnalysis> sensitivityAnalysis) {
        this.sensitivityAnalysis = sensitivityAnalysis;
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public SensitivityAnalysis getElementAt(int index) {
        return sensitivityAnalysis.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        int size = 0;

        if (sensitivityAnalysis != null) {
            size = sensitivityAnalysis.size();
        }
        return size;
    }
}
