/*
 * #%L
 * $Id: ObservationsNodeLoador.java 3969 2014-04-17 16:48:13Z echatellier $
 * $HeadURL: http://svn.codelutin.com/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/ui/input/tree/loadors/ObservationsNodeLoador.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input.tree.loadors;

import java.util.List;

import jaxx.runtime.swing.nav.NavDataProvider;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.Observation;
import fr.ifremer.isisfish.ui.input.tree.FisheryDataProvider;
import fr.ifremer.isisfish.ui.input.tree.FisheryTreeNode;

/**
 * Observation tree path node loader.
 * 
 * @author chatellier
 * @since 3.4.0.0
 */
public class ObservationsNodeLoador extends FisheryTreeNodeLoador<Observation> {

    /** serialVersionUID. */
    private static final long serialVersionUID = 6540304326033236054L;

    public ObservationsNodeLoador() {
        super(Observation.class);
    }

    @Override
    public List<Observation> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {
        FisheryDataProvider ficheryRegionDataProvider = (FisheryDataProvider)dataProvider;
        FisheryRegion fisheryRegion = ficheryRegionDataProvider.getFisheryRegion();
        List<Observation> observations = fisheryRegion.getObservations();
        return observations;
    }

    @Override
    public FisheryTreeNode createNode(Observation observation, NavDataProvider dataProvider) {

        // Create clients static nodes
        FisheryTreeNode observationNode = new FisheryTreeNode(
                Observation.class, observation.getTopiaId(),
                null, null);

        return observationNode;
    }
}
