/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.input.model;

import java.util.List;

import javax.swing.DefaultListModel;

import fr.ifremer.isisfish.entities.Metier;

/**
 * Model pour la liste des metiers de l'interface SetOfVessels.
 *
 * @author chatellier
 * @version $Revision: 3969 $
 * 
 * Last update : $Date: 2014-04-17 18:48:13 +0200 (jeu., 17 avril 2014) $
 * By : $Author: echatellier $
 */
public class MetierListModel extends DefaultListModel<Metier> {

    /** serialVersionUID. */
    private static final long serialVersionUID = -2715181950778932871L;
    
    /** Listes des metiers */
    protected List<Metier> metiers;

    /**
     * Empty constructor.
     */
    public MetierListModel() {
        this(null);
    }

    /**
     * Constructor with metiers list.
     * 
     * @param metiers liste des metiers
     */
    public MetierListModel(List<Metier> metiers) {
        setMetiers(metiers);
    }

    /**
     * Get metiers list.
     * 
     * @return the metiers list
     */
    public List<Metier> getMetiers() {
        return metiers;
    }

    /**
     * Set metiers list.
     * 
     * @param metiers the metiers list to set
     */
    public void setMetiers(List<Metier> metiers) {
        this.metiers = metiers;
        fireContentsChanged(this, 0, getSize());
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public Metier getElementAt(int index) {
        return metiers.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        int size = 0;

        if (metiers != null) {
            size = metiers.size();
        }
        return size;
    }
}
