package fr.ifremer.echobase.ui.actions.spatial;

/*
 * #%L
 * EchoBase :: UI
 * $Id: ShowSpatialData.java 881 2013-11-03 10:39:54Z tchemit $
 * $HeadURL: https://forge.codelutin.com/svn/echobase/tags/echobase-2.4/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/spatial/ShowSpatialData.java $
 * %%
 * Copyright (C) 2011 - 2013 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.opensymphony.xwork2.Preparable;
import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.entities.references.CellType;
import fr.ifremer.echobase.services.service.WorkingDbPersistenceService;
import fr.ifremer.echobase.services.service.spatial.SpatialService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;

import java.util.Map;

/**
 * To configure and show spatial datas.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.2
 */
public class ShowSpatialData extends EchoBaseActionSupport implements Preparable {

    private static final long serialVersionUID = 1L;

    protected final ShowSpatialModel model = new ShowSpatialModel();

    public ShowSpatialModel getModel() {
        return model;
    }

    protected boolean canAddSpatial;

    /** Universe of existing voyages. */
    protected Map<String, String> voyages;

    public Map<String, String> getVoyages() {
        return voyages;
    }

    /** Universe of existing cell types. */
    protected Map<String, String> cellTypes;

    public Map<String, String> getCellTypes() {
        return cellTypes;
    }

    public boolean isCanAddSpatial() {
        return canAddSpatial;
    }

    @Override
    public void prepare() throws Exception {
        voyages = workingDbPersistenceService.loadSortAndDecorate(Voyage.class);
        cellTypes = workingDbPersistenceService.loadSortAndDecorate(CellType.class);

        model.setJdbcUrl(getServiceContext().getWorkgingDbUrl());
        model.setWithSpatial(spatialService.isSpatialAware());

        // can add postgis if working db is postgresql and has still no echobase
        // spatial db
        canAddSpatial = !model.isWithSpatial() && spatialService.isPostgresql();
    }

    @Override
    public String input() throws Exception {

        model.setWithData(false);
        return SUCCESS;
    }

    @InputConfig(methodName = "input")
    @Override
    public String execute() throws Exception {
        getModel().setWithData(true);

        return SUCCESS;
    }

    //------------------------------------------------------------------------//
    //-- Injected objects                                                     //
    //------------------------------------------------------------------------//

    protected transient WorkingDbPersistenceService workingDbPersistenceService;

    public void setWorkingDbPersistenceService(WorkingDbPersistenceService workingDbPersistenceService) {
        this.workingDbPersistenceService = workingDbPersistenceService;
    }

    protected transient SpatialService spatialService;

    public void setSpatialService(SpatialService spatialService) {
        this.spatialService = spatialService;
    }
}
