package fr.ifremer.echobase.ui.actions.spatial;

/*
 * #%L
 * EchoBase :: UI
 * $Id: GetSpatialData.java 843 2013-08-20 06:07:41Z tchemit $
 * $HeadURL: https://forge.codelutin.com/svn/echobase/tags/echobase-2.4/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/spatial/GetSpatialData.java $
 * %%
 * Copyright (C) 2011 - 2013 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.echobase.entities.spatial.SpatialData;
import fr.ifremer.echobase.services.service.spatial.SpatialService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;

import java.util.Set;

/**
 * Obtain all spatial data used for a given voyage.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.2
 */
public class GetSpatialData extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    protected final ShowSpatialModel model = new ShowSpatialModel();

    protected GeoJsonObject data;

    public ShowSpatialModel getModel() {
        return model;
    }

    public GeoJsonObject getData() {
        return data;
    }

    @Override
    public String execute() throws Exception {

        Set<SpatialData> spatialData = spatialService.getSpatialData(model);

        GeoJsonObject.GeoJsonObjectBuilder builder =
                GeoJsonObject.newBuilder("Feature");

        for (SpatialData s : spatialData) {
            builder.newFeature("Feature", s.getId(), "Point")
                    .addFeatureProperty("name", s.getCell().getName())
                    .addFeatureProperty(s.getDataMetadata().getName(), s.getDataValue())
                    .addFeatureGeometryPoint(s.getLongitude(), s.getLatitude());
        }
        data = builder.flush();

        return SUCCESS;
    }

    //------------------------------------------------------------------------//
    //-- Injected objects                                                     //
    //------------------------------------------------------------------------//

    protected transient SpatialService spatialService;

    public void setSpatialService(SpatialService spatialService) {
        this.spatialService = spatialService;
    }
}