/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: AbstractLoadPage.java 842 2013-08-15 10:53:16Z tchemit $
 * $HeadURL: https://forge.codelutin.com/svn/echobase/tags/echobase-2.4/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/dbeditor/AbstractLoadPage.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.dbeditor;

import com.google.common.collect.Maps;
import fr.ifremer.echobase.entities.EchoBaseEntityEnum;
import fr.ifremer.echobase.services.service.DbEditorService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.nuiton.topia.persistence.metadata.ColumnMeta;
import org.nuiton.topia.persistence.metadata.DbMeta;
import org.nuiton.topia.persistence.metadata.TableMeta;

import java.util.List;
import java.util.Map;

/**
 * A abstract action which can load the table names and a selected table
 * meta datas.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public abstract class AbstractLoadPage extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    /** Type of entity to load. */
    protected EchoBaseEntityEnum entityType;

    public void setEntityType(EchoBaseEntityEnum entityType) {
        this.entityType = entityType;
    }

    public EchoBaseEntityEnum getEntityType() {
        return entityType;
    }

    /** All entities availables. */
    protected Map<String, String> entityTypes;

    public Map<String, String> getEntityTypes() {
        return entityTypes;
    }

    /** Metas of the table. */
    protected TableMeta<EchoBaseEntityEnum> tableMeta;

    public List<ColumnMeta> getColumnMetas() {
        return tableMeta.getColumns();
    }

    public void load() throws Exception {
        entityTypes = Maps.newTreeMap();
        DbMeta<EchoBaseEntityEnum> dbMeta = getEchoBaseApplicationContext().getDbMeta();
        for (TableMeta<EchoBaseEntityEnum> meta : dbMeta) {

            // keep only editable metas
            if (dbMeta.isEditable(meta)) {
                String name = meta.getName();
                entityTypes.put(name, name);
            }
        }
        if (entityType == null) {

            // no table selected
            addFlashMessage(_("echobase.info.no.table.selected"));
        } else {

            // load table metas
            tableMeta = dbEditorService.getTableMeta(entityType);
        }
    }

    //------------------------------------------------------------------------//
    //-- Injected objects                                                     //
    //------------------------------------------------------------------------//

    protected transient DbEditorService dbEditorService;

    public void setDbEditorService(DbEditorService dbEditorService) {
        this.dbEditorService = dbEditorService;
    }

}
