package fr.ifremer.echobase.ui.actions.spatial;

/*
 * #%L
 * EchoBase :: UI
 * $Id: ShowSpatialModel.java 843 2013-08-20 06:07:41Z tchemit $
 * $HeadURL: https://forge.codelutin.com/svn/echobase/tags/echobase-2.3/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/spatial/ShowSpatialModel.java $
 * %%
 * Copyright (C) 2011 - 2013 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.echobase.entities.spatial.SpatialConfiguration;
import fr.ifremer.echobase.entities.spatial.SpatialData;

import java.io.Serializable;
import java.util.Set;

/**
 * TODO
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.2
 */
public class ShowSpatialModel extends SpatialConfiguration implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Loaded spatial data.
     */
    protected Set<SpatialData> spatialData;

    /**
     * Can we use spatial data (means is the database is spatial?).
     */
    protected boolean withSpatial;

    /**
     * Can we collect spatial data (means is the configuration filled enough ?).
     */
    protected boolean withData;

    public boolean isWithSpatial() {
        return withSpatial;
    }

    public void setWithSpatial(boolean withSpatial) {
        this.withSpatial = withSpatial;
    }

    public boolean isWithData() {
        return withData;
    }

    public void setWithData(boolean withData) {
        this.withData = withData;
    }

}
