/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: SelectImportType.java 842 2013-08-15 10:53:16Z tchemit $
 * $HeadURL: https://forge.codelutin.com/svn/echobase/tags/echobase-2.2/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/importData/SelectImportType.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.importData;

import fr.ifremer.echobase.services.service.DecoratorService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;

import java.util.Map;

/**
 * To select the type of import to configure.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class SelectImportType extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    protected ImportMode mode;

    public void setMode(ImportMode mode) {
        this.mode = mode;
    }

    public ImportMode getMode() {
        return mode;
    }

    /** Universe of possible import modes. */
    protected Map<String, String> modes;

    public Map<String, String> getModes() {
        return modes;
    }

    @Override
    public String input() throws Exception {
        modes = decoratorService.decorateEnums(ImportMode.values());

        if (mode == null) {
            mode = ImportMode.Common;
        }
        return INPUT;
    }

    @Override
    public String execute() throws Exception {
        return SUCCESS;
    }

    //------------------------------------------------------------------------//
    //-- Injected objects                                                     //
    //------------------------------------------------------------------------//

    protected transient DecoratorService decoratorService;

    public void setDecoratorService(DecoratorService decoratorService) {
        this.decoratorService = decoratorService;
    }
}
