/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: ConfigureCommonImport.java 842 2013-08-15 10:53:16Z tchemit $
 * $HeadURL: https://forge.codelutin.com/svn/echobase/tags/echobase-2.2/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/importData/ConfigureCommonImport.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.importData;

import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import fr.ifremer.echobase.entities.ImportType;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.entities.references.AreaOfOperation;
import fr.ifremer.echobase.entities.references.Mission;
import fr.ifremer.echobase.services.service.importdata.CommonImportConfiguration;

import java.io.File;
import java.util.Map;

/**
 * Configure a common data (voyage / transit / transect) import.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class ConfigureCommonImport extends AbstractConfigureImport<CommonImportConfiguration> {

    private static final long serialVersionUID = 1L;

    /** Universe of existing missions. */
    protected Map<String, String> missions;

    /** Universe of existing voyages. */
    protected Map<String, String> voyages;

    /** Universe of existing area of operations. */
    protected Map<String, String> areaOfOperations;

    /** Universe of possible import modes. */
    protected Map<String, String> importTypes;

    public ConfigureCommonImport() {
        super(CommonImportConfiguration.class);
    }

    @Override
    protected CommonImportConfiguration createModel() {
        return new CommonImportConfiguration(getLocale());
    }

    @Override
    protected void prepareInputAction(CommonImportConfiguration model) {
        missions = workingDbPersistenceService.loadSortAndDecorate(Mission.class);
        voyages = workingDbPersistenceService.loadSortAndDecorate(Voyage.class);
        areaOfOperations = workingDbPersistenceService.loadSortAndDecorate(AreaOfOperation.class);
        importTypes = decoratorService.decorateEnums(ImportType.getCommonImportType());

        if (model.getImportType() == null) {

            model.setImportType(ImportType.COMMON_ALL);
        }
    }

    @InputConfig(methodName = "input")
    public String modeAll() throws Exception {

        return execute();
    }

    @InputConfig(methodName = "input")
    public String modeVoyage() throws Exception {

        return execute();
    }

    @InputConfig(methodName = "input")
    public String modeTransit() throws Exception {

        return execute();
    }

    @InputConfig(methodName = "input")
    public String modeTransect() throws Exception {

        return execute();
    }

    public Map<String, String> getMissions() {
        return missions;
    }

    public Map<String, String> getVoyages() {
        return voyages;
    }

    public Map<String, String> getAreaOfOperations() {
        return areaOfOperations;
    }

    public Map<String, String> getImportTypes() {
        return importTypes;
    }

    public void setVoyageFile(File file) {
        getModel().getVoyageFile().setFile(file);
    }

    public void setVoyageFileContentType(String contentType) {
        getModel().getVoyageFile().setContentType(contentType);
    }

    public void setVoyageFileFileName(String fileName) {
        getModel().getVoyageFile().setFileName(fileName);
    }

    public void setTransitFile(File file) {
        getModel().getTransitFile().setFile(file);
    }

    public void setTransitFileContentType(String contentType) {
        getModel().getTransitFile().setContentType(contentType);
    }

    public void setTransitFileFileName(String fileName) {
        getModel().getTransitFile().setFileName(fileName);
    }

    public void setTransectFile(File file) {
        getModel().getTransectFile().setFile(file);
    }

    public void setTransectFileContentType(String contentType) {
        getModel().getTransectFile().setContentType(contentType);
    }

    public void setTransectFileFileName(String fileName) {
        getModel().getTransectFile().setFileName(fileName);
    }

}
