/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: ImportMode.java 116 2011-11-24 23:06:43Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/trunk/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/importData/ImportMode.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.importData;

import static org.nuiton.i18n.I18n.n_;

/**
 * Define import mode (use an existing voayge, or create a new one.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public enum ImportMode {

    CREATE_NEW_VOYAGE(n_("echobase.common.importMode.createNewVoyage")),
    USE_EXISTING_VOYAGE(n_("echobase.common.importMode.useExistingVoyage"));


    private final String i18nKey;

    ImportMode(String i18nKey) {
        this.i18nKey = i18nKey;
    }

    public String getI18nKey() {
        return i18nKey;
    }
}
