/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: GetSqlResult.java 51 2011-11-13 16:20:45Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/trunk/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/export/GetSqlResult.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.export;

import fr.ifremer.echobase.services.ExportSqlService;
import fr.ifremer.echobase.ui.actions.AbstractJSONPaginedAction;

import java.util.Map;

/**
 * Obtains result of a sql query.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class GetSqlResult extends AbstractJSONPaginedAction {

    private static final long serialVersionUID = 1L;

    /** Sql request to execute. */
    protected String sql;

    /** Datas of the given table. */
    protected Map<?, ?>[] datas;

    public GetSqlResult() {
        super("datas_");
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public Map<?, ?>[] getDatas() {
        return datas;
    }

    @Override
    public Integer getRows() {
        return pager.getPageSize();
    }

    @Override
    public Integer getPage() {
        return pager.getPageNumber();
    }

    @Override
    public Integer getTotal() {
        return pager.getPageCount();
    }

    @Override
    public Integer getRecords() {
        return pager.getRecords();
    }

    @Override
    public String execute() throws Exception {

        ExportSqlService service = newService(ExportSqlService.class);
        datas = service.executeSql(sql, pager);
        return SUCCESS;
    }
}
