/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.services;

import fr.ifremer.coser.CoserBusinessConfig;
import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.CoserConstants;
import fr.ifremer.coser.CoserUtils;
import fr.ifremer.coser.bean.AbstractDataContainer;
import fr.ifremer.coser.bean.Control;
import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.bean.RSufiResult;
import fr.ifremer.coser.bean.Selection;
import fr.ifremer.coser.bean.SpeciesFieldType;
import fr.ifremer.coser.command.Command;
import fr.ifremer.coser.command.DeleteLineCommand;
import fr.ifremer.coser.command.MergeSpeciesCommand;
import fr.ifremer.coser.command.ModifyFieldCommand;
import fr.ifremer.coser.control.ControlError;
import fr.ifremer.coser.data.AbstractDataEntity;
import fr.ifremer.coser.data.Catch;
import fr.ifremer.coser.data.Haul;
import fr.ifremer.coser.data.Length;
import fr.ifremer.coser.data.Strata;
import fr.ifremer.coser.services.CommandService;
import fr.ifremer.coser.services.CommonService;
import fr.ifremer.coser.services.PublicationService;
import fr.ifremer.coser.storage.DataStorage;
import fr.ifremer.coser.util.Coordinate;
import fr.ifremer.coser.util.ProgressMonitor;
import java.beans.Introspector;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math.util.MathUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.DimensionHelper;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.MatrixProvider;
import org.nuiton.math.matrix.MatrixProxy;

public class ProjectService {
    private static final Log log = LogFactory.getLog(ProjectService.class);
    protected CoserBusinessConfig config;
    protected CommonService commonService;
    protected CommandService commandService;
    protected PublicationService publicationService;

    public ProjectService(CoserBusinessConfig config) {
        this.config = config;
        this.commonService = new CommonService(config);
        this.commandService = new CommandService(config);
        this.publicationService = new PublicationService(config);
    }

    public List<String> getProjectNames() {
        File projectsDirectory = this.config.getRSufiProjectsDirectory();
        ArrayList<String> result = new ArrayList<String>();
        File[] projects = projectsDirectory.listFiles();
        if (projects != null) {
            for (File existingProject : projects) {
                if (!existingProject.isDirectory()) continue;
                String projectName = existingProject.getName();
                result.add(projectName);
            }
        }
        Collections.sort(result);
        return result;
    }

    public Project createProject(Project project, Map<CoserConstants.Category, File> categoriesAndFiles, List<File> maps, ProgressMonitor progress) throws CoserBusinessException {
        String projectName;
        File projectDirectory;
        File projectsDirectory = this.config.getRSufiProjectsDirectory();
        if (!projectsDirectory.isDirectory()) {
            projectsDirectory.mkdirs();
        }
        if ((projectDirectory = new File(projectsDirectory, projectName = project.getName())).exists()) {
            throw new CoserBusinessException(I18n.t((String)"Project %s already exist", (Object[])new Object[]{project.getName()}));
        }
        project.setCreationDate(new Date());
        project.clearData();
        if (progress != null) {
            progress.setCurrent(0);
            int total = 0;
            for (Map.Entry<CoserConstants.Category, File> categoryAndFile : categoriesAndFiles.entrySet()) {
                total = (int)((long)total + categoryAndFile.getValue().length());
            }
            progress.setTotal(total);
        }
        Control control = new Control();
        for (Map.Entry<CoserConstants.Category, File> categoryAndFile : categoriesAndFiles.entrySet()) {
            CoserConstants.Category category = categoryAndFile.getKey();
            File dataFile = categoryAndFile.getValue();
            if (!dataFile.exists()) {
                throw new CoserBusinessException(I18n.t((String)"Can't read file %s for category %s", (Object[])new Object[]{dataFile.getAbsolutePath(), I18n.t((String)category.getTranslationKey(), (Object[])new Object[0])}));
            }
            DataStorage dataStorage = this.commonService.loadCSVFile(project, category, dataFile, progress, true);
            this.addProjectContent(project, control, category, dataStorage, false);
            if (!category.isDataCategory()) continue;
            DataStorage dataStorage2 = this.commonService.getEmptyStorage(project, category);
            this.addProjectContent(project, control, category, dataStorage2, true);
        }
        projectDirectory.mkdirs();
        File originalDirectory = new File(projectDirectory, "original");
        originalDirectory.mkdirs();
        for (Map.Entry<CoserConstants.Category, File> categoryAndFile : categoriesAndFiles.entrySet()) {
            CoserConstants.Category category = categoryAndFile.getKey();
            File dataFile = categoryAndFile.getValue();
            try {
                if (category.isDataCategory()) {
                    String storageFileName = this.commonService.getDataStorageFileName(project, category, null);
                    File storageDataFile = new File(originalDirectory, storageFileName);
                    FileUtils.copyFile((File)dataFile, (File)storageDataFile);
                    continue;
                }
                File storageDataFile = new File(projectDirectory, category.getStorageFileName());
                FileUtils.copyFile((File)dataFile, (File)storageDataFile);
            }
            catch (IOException ex) {
                try {
                    FileUtils.deleteDirectory((File)projectDirectory);
                }
                catch (IOException e) {
                    throw new CoserBusinessException(I18n.t((String)"Can't create project", (Object[])new Object[0]), ex);
                }
                throw new CoserBusinessException(I18n.t((String)"Can't create project", (Object[])new Object[0]), ex);
            }
        }
        this.saveProject(project, maps);
        project.setSelections(new HashMap<String, Selection>());
        control.setHistoryCommands(new ArrayList<Command>());
        project.setControl(control);
        LinkedHashMap<String, String> reftaxSpecies = this.getReftaxSpeciesDisplayFieldMap(project, false);
        project.setRefTaxSpeciesMap(reftaxSpecies);
        return project;
    }

    public void saveProject(Project project, List<File> maps) throws CoserBusinessException {
        File projectsDirectory = this.config.getRSufiProjectsDirectory();
        String projectName = project.getName();
        File projectDirectory = new File(projectsDirectory, projectName);
        Project localProject = this.updateProjectMaps(project, projectDirectory, maps);
        File propertiesFile = new File(projectDirectory, "project.properties");
        Properties props = localProject.toProperties();
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(propertiesFile);
            props.store(outputStream, null);
            ((OutputStream)outputStream).close();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saving project properties file : " + propertiesFile));
            }
        }
        catch (IOException ex) {
            try {
                throw new CoserBusinessException("Can't save project properties file", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        LinkedHashMap<String, String> reftaxSpecies = this.getReftaxSpeciesDisplayFieldMap(project, false);
        project.setRefTaxSpeciesMap(reftaxSpecies);
    }

    protected Project updateProjectMaps(Project project, File projectDirectory, List<File> newMaps) throws CoserBusinessException {
        File mapsDirectory = new File(projectDirectory, "maps");
        List<File> currentMaps = project.getMaps();
        if (currentMaps == null) {
            currentMaps = new ArrayList<File>();
        }
        ArrayList<File> mapsList = new ArrayList<File>(currentMaps);
        try {
            Collection removedMaps = CollectionUtils.subtract(currentMaps, newMaps);
            for (File removedMap : removedMaps) {
                removedMap.delete();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleting map : " + removedMap));
                }
                mapsList.remove(removedMap);
            }
            Collection addedMaps = CollectionUtils.subtract(newMaps, currentMaps);
            if (!addedMaps.isEmpty()) {
                mapsDirectory.mkdirs();
            }
            for (File addedMap : addedMaps) {
                File storageMap = new File(mapsDirectory, addedMap.getName());
                FileUtils.copyFile((File)addedMap, (File)storageMap);
                mapsList.add(storageMap);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Adding map : " + storageMap));
            }
            project.setMaps(mapsList);
        }
        catch (IOException ex) {
            throw new CoserBusinessException("Can't copy maps", ex);
        }
        return project;
    }

    public Project openProject(String projectName) throws CoserBusinessException {
        return this.openProject(projectName, null);
    }

    public Project openProject(String projectName, File parentDirectory) throws CoserBusinessException {
        File projectDirectory;
        File projectsDirectory = parentDirectory;
        if (projectsDirectory == null) {
            projectsDirectory = this.config.getRSufiProjectsDirectory();
        }
        if (!(projectDirectory = new File(projectsDirectory, projectName)).isDirectory()) {
            throw new CoserBusinessException(I18n.t((String)"Project %s doesn't exists !", (Object[])new Object[]{projectName}));
        }
        Project project = new Project(projectName);
        for (CoserConstants.Category category : CoserConstants.Category.values()) {
            if (category.isDataCategory()) continue;
            File inputFile = new File(projectDirectory, category.getStorageFileName());
            if (inputFile.isFile()) {
                DataStorage dataStorage = this.commonService.loadCSVFile(project, category, inputFile);
                this.addProjectContent(project, null, category, dataStorage, false);
                continue;
            }
            throw new CoserBusinessException(I18n.t((String)"Missing file %s", (Object[])new Object[]{inputFile}));
        }
        File controlDirectory = new File(projectDirectory, "control");
        File controlPropertiesFile = new File(controlDirectory, "control.properties");
        Control control = new Control();
        if (controlPropertiesFile.exists()) {
            FileInputStream inputStream;
            block23: {
                inputStream = null;
                try {
                    Properties props = new Properties();
                    inputStream = new FileInputStream(controlPropertiesFile);
                    props.load(inputStream);
                    control.fromProperties(props);
                    ((InputStream)inputStream).close();
                    if (!log.isDebugEnabled()) break block23;
                    log.debug((Object)("Read control properties file : " + controlPropertiesFile));
                }
                catch (IOException ex) {
                    try {
                        throw new CoserBusinessException("Can't read control properties file", ex);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputStream);
                        throw throwable;
                    }
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        project.setControl(control);
        HashMap<String, Selection> selections = new HashMap<String, Selection>();
        File selectionsDirectory = new File(projectDirectory, "selections");
        if (selectionsDirectory.isDirectory()) {
            File[] selectionDirectories;
            for (File selectionDirectory : selectionDirectories = selectionsDirectory.listFiles()) {
                if (!selectionDirectory.isDirectory()) continue;
                String selectionName = selectionDirectory.getName();
                Selection selection = new Selection();
                selection.setName(selectionName);
                File selectionPropertiesFile = new File(selectionDirectory, selectionName + ".selection");
                FileInputStream inputStream = null;
                try {
                    Properties props = new Properties();
                    inputStream = new FileInputStream(selectionPropertiesFile);
                    props.load(inputStream);
                    selection.fromProperties(props);
                    ((InputStream)inputStream).close();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Read selection properties file : " + selectionPropertiesFile));
                    }
                }
                catch (IOException ex) {
                    try {
                        throw new CoserBusinessException("Can't read selection properties file", ex);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputStream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                File othersDir = new File(selectionDirectory, "others");
                ArrayList<File> otherFiles = new ArrayList<File>();
                if (othersDir.isDirectory()) {
                    for (File file : othersDir.listFiles()) {
                        otherFiles.add(file);
                    }
                }
                selection.setOtherFiles(otherFiles);
                List<RSufiResult> rsufiResults = this.loadRSufiResults(selectionDirectory);
                selection.setRsufiResults(rsufiResults);
                selections.put(selectionDirectory.getName(), selection);
            }
        }
        project.setSelections(selections);
        File projectPropertiesFile = new File(projectDirectory, "project.properties");
        File mapsDirectory = new File(projectDirectory, "maps");
        FileInputStream inputStream = null;
        try {
            Properties props = new Properties();
            inputStream = new FileInputStream(projectPropertiesFile);
            props.load(inputStream);
            project.fromProperties(props, mapsDirectory);
            ((InputStream)inputStream).close();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Read project properties file : " + projectPropertiesFile));
            }
        }
        catch (IOException ex) {
            try {
                throw new CoserBusinessException("Can't read project properties file", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        LinkedHashMap<String, String> reftaxSpecies = this.getReftaxSpeciesDisplayFieldMap(project, false);
        project.setRefTaxSpeciesMap(reftaxSpecies);
        return project;
    }

    protected List<RSufiResult> loadRSufiResults(File selectionDirectory) throws CoserBusinessException {
        ArrayList<RSufiResult> results = new ArrayList<RSufiResult>();
        File resultsDirectory = new File(selectionDirectory, "results");
        File[] resultsDirectories = resultsDirectory.listFiles();
        if (resultsDirectories != null) {
            for (File resultDirectory : resultsDirectories) {
                if (!resultDirectory.isDirectory()) continue;
                RSufiResult rsufiResult = this.getRSufiResult(resultDirectory);
                rsufiResult.setName(resultDirectory.getName());
                results.add(rsufiResult);
                File mapsDir = new File(resultDirectory, "maps");
                rsufiResult.setMapsAvailable(mapsDir.isDirectory());
                File othersDir = new File(resultDirectory, "others");
                ArrayList<File> otherFiles = new ArrayList<File>();
                if (othersDir.isDirectory()) {
                    for (File file : othersDir.listFiles()) {
                        otherFiles.add(file);
                    }
                }
                rsufiResult.setOtherFiles(otherFiles);
            }
        }
        return results;
    }

    public RSufiResult getRSufiResult(File resultDirectory) throws CoserBusinessException {
        RSufiResult rsufiResult = new RSufiResult();
        rsufiResult.setName(resultDirectory.getName());
        File resultPropertiesFile = new File(resultDirectory, "result.properties");
        FileInputStream inputStream = null;
        try {
            Properties props = new Properties();
            inputStream = new FileInputStream(resultPropertiesFile);
            props.load(inputStream);
            rsufiResult.fromProperties(props);
            ((InputStream)inputStream).close();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Read result properties file : " + resultPropertiesFile));
            }
        }
        catch (IOException ex) {
            try {
                throw new CoserBusinessException("Can't read result properties file", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return rsufiResult;
    }

    public Project loadControlData(Project project) throws CoserBusinessException {
        block16: {
            Control control;
            block15: {
                FileInputStream inputStream;
                block14: {
                    File controlPropertiesFile;
                    File projectsDirectory = this.config.getRSufiProjectsDirectory();
                    File projectDirectory = new File(projectsDirectory, project.getName());
                    project.clearData();
                    control = project.getControl();
                    File controlDirectory = new File(projectDirectory, "control");
                    int fileLoaded = 0;
                    for (CoserConstants.Category category : CoserConstants.Category.values()) {
                        DataStorage dataStorage;
                        if (!category.isDataCategory()) continue;
                        String storageFileName = this.commonService.getDataStorageFileName(project, category, "_co");
                        File inputFile = new File(controlDirectory, storageFileName);
                        if (inputFile.isFile()) {
                            dataStorage = this.commonService.loadCSVFile(project, category, inputFile);
                            this.addProjectContent(project, control, category, dataStorage, false);
                            ++fileLoaded;
                        } else if (log.isDebugEnabled()) {
                            log.debug((Object)("Can't find file " + inputFile));
                        }
                        storageFileName = this.commonService.getDataStorageFileName(project, category, "_del");
                        inputFile = new File(controlDirectory, storageFileName);
                        dataStorage = null;
                        if (inputFile.isFile()) {
                            dataStorage = this.commonService.loadCSVFile(project, category, inputFile);
                        } else {
                            dataStorage = this.commonService.getEmptyStorage(project, category);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Can't find file " + inputFile));
                            }
                        }
                        this.addProjectContent(project, control, category, dataStorage, true);
                    }
                    if (fileLoaded == 0) {
                        File originalDirectory = new File(projectDirectory, "original");
                        for (CoserConstants.Category category : CoserConstants.Category.values()) {
                            if (!category.isDataCategory()) continue;
                            String storageFileName = this.commonService.getDataStorageFileName(project, category, null);
                            File storageDataFile = new File(originalDirectory, storageFileName);
                            if (!storageDataFile.isFile()) {
                                throw new CoserBusinessException(I18n.t((String)"Missing file %s", (Object[])new Object[]{storageDataFile}));
                            }
                            DataStorage dataStorage = this.commonService.loadCSVFile(project, category, storageDataFile, null, true);
                            this.addProjectContent(project, control, category, dataStorage, false);
                            dataStorage = this.commonService.getEmptyStorage(project, category);
                            this.addProjectContent(project, control, category, dataStorage, true);
                        }
                    }
                    if (!(controlPropertiesFile = new File(controlDirectory, "control.properties")).exists()) break block15;
                    inputStream = null;
                    try {
                        Properties props = new Properties();
                        inputStream = new FileInputStream(controlPropertiesFile);
                        props.load(inputStream);
                        ((InputStream)inputStream).close();
                        List<Command> commands = this.getHistoryCommandsFromProperties(props, "control.commands");
                        control.setHistoryCommands(commands);
                        if (!log.isDebugEnabled()) break block14;
                        log.debug((Object)("Read control properties file : " + controlPropertiesFile));
                    }
                    catch (IOException ex) {
                        try {
                            throw new CoserBusinessException("Can't read control properties file", ex);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(inputStream);
                            throw throwable;
                        }
                    }
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                break block16;
            }
            control.setHistoryCommands(new ArrayList<Command>());
        }
        return project;
    }

    public Project loadSelectionData(Project project, Selection selection) throws CoserBusinessException {
        return this.loadSelectionData(this.config.getRSufiProjectsDirectory(), project, selection);
    }

    public Project loadSelectionData(File projectsDirectory, Project project, Selection selection) throws CoserBusinessException {
        File projectDirectory = new File(projectsDirectory, project.getName());
        project.clearData();
        String selectionName = selection.getName();
        File selectionsDirectory = new File(projectDirectory, "selections");
        File selectionDirectory = new File(selectionsDirectory, selectionName);
        for (CoserConstants.Category category : CoserConstants.Category.values()) {
            if (!category.isDataCategory()) continue;
            String storageFileName = this.commonService.getDataStorageFileName(project, category, "_se");
            File inputFile = new File(selectionDirectory, storageFileName);
            if (inputFile.isFile()) {
                DataStorage dataStorage = this.commonService.loadCSVFile(project, category, inputFile);
                this.addProjectContent(project, selection, category, dataStorage, false);
                continue;
            }
            throw new CoserBusinessException(I18n.t((String)"Missing file %s", (Object[])new Object[]{inputFile}));
        }
        File selectionPropertiesFile = new File(selectionDirectory, selectionName + ".selection");
        FileInputStream inputStream = null;
        try {
            Properties props = new Properties();
            inputStream = new FileInputStream(selectionPropertiesFile);
            props.load(inputStream);
            ((InputStream)inputStream).close();
            List<Command> commands = this.getHistoryCommandsFromProperties(props, "selection.commands");
            selection.setHistoryCommands(commands);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Read selection properties file : " + selectionPropertiesFile));
            }
        }
        catch (IOException ex) {
            try {
                throw new CoserBusinessException("Can't read selection properties file", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return project;
    }

    public void saveProjectControl(Project project) throws CoserBusinessException {
        File projectsDirectory = this.config.getRSufiProjectsDirectory();
        String projectName = project.getName();
        File projectDirectory = new File(projectsDirectory, projectName);
        Control control = project.getControl();
        File controlDirectory = new File(projectDirectory, "control");
        controlDirectory.mkdirs();
        for (CoserConstants.Category category : CoserConstants.Category.values()) {
            if (!category.isDataCategory()) continue;
            String storageFileName = this.commonService.getDataStorageFileName(project, category, "_co");
            File controlFile = new File(controlDirectory, storageFileName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saving control file : " + controlFile));
            }
            DataStorage content = this.getProjectContent(project, control, category, false);
            this.commonService.storeData(content, controlFile);
            DataStorage contentDeleted = this.getProjectContent(project, control, category, true);
            if (contentDeleted.size() <= 1) continue;
            String deletedFileName = this.commonService.getDataStorageFileName(project, category, "_del");
            File deletedDataFile = new File(controlDirectory, deletedFileName);
            this.commonService.storeData(contentDeleted, deletedDataFile);
        }
        File propertiesFile = new File(controlDirectory, "control.properties");
        Properties props = control.toProperties();
        this.addHistoryCommandsToProperties(props, project.getControl().getHistoryCommands(), "control.commands");
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(propertiesFile);
            props.store(outputStream, null);
            ((OutputStream)outputStream).close();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saving control properties file : " + propertiesFile));
            }
        }
        catch (IOException ex) {
            try {
                throw new CoserBusinessException("Can't save control properties file", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    public void validControl(Project project, List<ControlError> validationErrors) throws CoserBusinessException {
        Control control = project.getControl();
        control.setValidated(true);
        this.saveProjectControl(project);
        File projectsDirectory = this.config.getRSufiProjectsDirectory();
        File projectDirectory = new File(projectsDirectory, project.getName());
        File controlDirectory = new File(projectDirectory, "control");
        File controlReportPdf = new File(controlDirectory, "control.pdf");
        this.publicationService.extractControlLogAsPDF(project, control, validationErrors, controlReportPdf);
    }

    public void validSelection(Project project, Selection selection) throws CoserBusinessException {
        selection.setValidated(true);
        this.saveProjectSelection(project, selection);
        File projectsDirectory = this.config.getRSufiProjectsDirectory();
        File projectDirectory = new File(projectsDirectory, project.getName());
        File selectionsDirectory = new File(projectDirectory, "selections");
        File selectionDirectory = new File(selectionsDirectory, selection.getName());
        File selectionReportPdf = new File(selectionDirectory, "selection.pdf");
        this.publicationService.extractSelectionLogAsPDF(project, selection, selectionReportPdf);
    }

    public Selection initProjectSelection(Project project) throws CoserBusinessException {
        if (!project.getControl().isValidated()) {
            throw new CoserBusinessException(I18n.t((String)"coser.business.selection.notValidatedControl", (Object[])new Object[0]));
        }
        Project localProject = project;
        if (localProject.getControl() == null || !localProject.getControl().isDataLoaded()) {
            localProject = this.loadControlData(localProject);
        }
        Selection selection = new Selection();
        this.copyControlDataToSelection(localProject, selection);
        selection.setRsufiResults(new ArrayList<RSufiResult>());
        selection.setDensityFilter(this.config.getSelectionDensityFilter());
        selection.setOccurrenceFilter(this.config.getSelectionOccurrenceFilter());
        List<String> allYears = this.getProjectYears(selection);
        selection.setAllYears(allYears);
        selection.setSelectedYears(new ArrayList<String>(allYears));
        return selection;
    }

    public Selection initProjectSelectionFromFile(Project project, File selectionFile) throws CoserBusinessException {
        Selection selection = this.initProjectSelection(project);
        selection.setName(null);
        FileInputStream selectionStream = null;
        try {
            Properties props = new Properties();
            selectionStream = new FileInputStream(selectionFile);
            props.load(selectionStream);
            selection.fromProperties(props);
            ((InputStream)selectionStream).close();
        }
        catch (IOException ex) {
            try {
                throw new CoserBusinessException("Can't read selection properties file", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(selectionStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)selectionStream);
        this.filterDataYearsAndGetStrata(project, selection, selection.getSelectedYears());
        ArrayList<Command> commands = new ArrayList<Command>(selection.getHistoryCommands());
        selection.clearHistoryCommands();
        for (Command command : commands) {
            this.commandService.doAction(command, project, selection);
        }
        return selection;
    }

    protected Selection copyControlDataToSelection(Project project, Selection selection) {
        Control control = project.getControl();
        DataStorage dataCatch = control.getCatch();
        DataStorage dataHaul = control.getHaul();
        DataStorage dataLength = control.getLength();
        DataStorage dataStrata = control.getStrata();
        project.clearData();
        selection.setCatch(dataCatch);
        selection.setHaul(dataHaul);
        selection.setLength(dataLength);
        selection.setStrata(dataStrata);
        selection.setHistoryCommands(new ArrayList<Command>());
        return selection;
    }

    public void createProjectSelection(Project project, Selection selection) throws CoserBusinessException {
        File projectsDirectory = this.config.getRSufiProjectsDirectory();
        File projectDirectory = new File(projectsDirectory, project.getName());
        File selectionsDirectory = new File(projectDirectory, "selections");
        File selectionDirectory = new File(selectionsDirectory, selection.getName());
        if (selectionDirectory.isDirectory()) {
            throw new CoserBusinessException(I18n.t((String)"Selection %s already exists", (Object[])new Object[]{selection.getName()}));
        }
        selectionDirectory.mkdirs();
        this.saveProjectSelection(project, selection);
        project.addSelections(selection);
    }

    public void saveProjectSelection(Project project, Selection selection) throws CoserBusinessException {
        File projectsDirectory = this.config.getRSufiProjectsDirectory();
        File projectDirectory = new File(projectsDirectory, project.getName());
        File selectionsDirectory = new File(projectDirectory, "selections");
        String selectionName = selection.getName();
        File selectionDirectory = new File(selectionsDirectory, selectionName);
        for (CoserConstants.Category category : CoserConstants.Category.values()) {
            if (!category.isDataCategory()) continue;
            String storageFileName = this.commonService.getDataStorageFileName(project, category, "_se");
            File dataFile = new File(selectionDirectory, storageFileName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saving selection file : " + dataFile));
            }
            DataStorage content = this.getProjectContent(project, selection, category, false);
            this.commonService.storeData(content, dataFile);
        }
        File propertiesFile = new File(selectionDirectory, selectionName + ".selection");
        Properties props = selection.toProperties();
        this.addHistoryCommandsToProperties(props, selection.getHistoryCommands(), "selection.commands");
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(propertiesFile);
            props.store(outputStream, null);
            ((OutputStream)outputStream).close();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saving selection properties file : " + propertiesFile));
            }
        }
        catch (IOException ex) {
            try {
                throw new CoserBusinessException("Can't save selection properties file", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        if (selection.isValidated()) {
            File listSpeciesFile = new File(selectionDirectory, "ListEspeces" + project.getName() + ".txt");
            this.fillListSpeciesFile(selection, listSpeciesFile);
        }
    }

    public void saveRsufiResults(Project project, Selection selection, RSufiResult rsufiResult, List<File> othersFiles) throws CoserBusinessException {
        File projectsDirectory = this.config.getRSufiProjectsDirectory();
        File projectDirectory = new File(projectsDirectory, project.getName());
        File selectionsDirectory = new File(projectDirectory, "selections");
        File selectionDirectory = new File(selectionsDirectory, selection.getName());
        File resultsDirectory = new File(selectionDirectory, "results");
        File rsufiResultDirectory = new File(resultsDirectory, rsufiResult.getName());
        if (rsufiResultDirectory.exists()) {
            throw new CoserBusinessException(I18n.t((String)"coser.business.result.rsufiResultAlreadyExists", (Object[])new Object[]{rsufiResult.getName()}));
        }
        rsufiResultDirectory.mkdirs();
        if (rsufiResult.getCreationDate() == null) {
            rsufiResult.setCreationDate(new Date());
        }
        try {
            File estComIndFile = new File(rsufiResult.getEstComIndPath());
            File estPopIndFile = new File(rsufiResult.getEstPopIndPath());
            rsufiResult.setEstComIndName(estComIndFile.getName());
            rsufiResult.setEstPopIndName(estPopIndFile.getName());
            FileUtils.copyFileToDirectory((File)estComIndFile, (File)rsufiResultDirectory);
            FileUtils.copyFileToDirectory((File)estPopIndFile, (File)rsufiResultDirectory);
            File resultMapsDirectory = new File(rsufiResultDirectory, "maps");
            if (StringUtils.isNotEmpty((CharSequence)rsufiResult.getMapsPath())) {
                File mapsDirectory = new File(rsufiResult.getMapsPath());
                FileUtils.copyDirectory((File)mapsDirectory, (File)resultMapsDirectory);
            }
            File otherFilesDirectory = new File(rsufiResultDirectory, "others");
            for (File othersFile : othersFiles) {
                if (othersFile.isDirectory()) {
                    FileUtils.copyDirectoryToDirectory((File)othersFile, (File)otherFilesDirectory);
                    continue;
                }
                FileUtils.copyFileToDirectory((File)othersFile, (File)otherFilesDirectory);
            }
            this.saveRSufiResult(rsufiResultDirectory, rsufiResult);
        }
        catch (IOException ex) {
            throw new CoserBusinessException("Can't save result properties file", ex);
        }
        File mapsDir = new File(rsufiResultDirectory, "maps");
        rsufiResult.setMapsAvailable(mapsDir.isDirectory());
        File othersDir = new File(rsufiResultDirectory, "others");
        ArrayList<File> otherFiles = new ArrayList<File>();
        if (othersDir.isDirectory()) {
            for (File file : othersDir.listFiles()) {
                otherFiles.add(file);
            }
        }
        rsufiResult.setOtherFiles(otherFiles);
        List<RSufiResult> results = selection.getRsufiResults();
        results.add(rsufiResult);
        selection.setRsufiResults(results);
    }

    public void editRsufiResults(Project project, Selection selection, RSufiResult rsufiResult, List<File> othersFile) throws CoserBusinessException {
        File projectsDirectory = this.config.getRSufiProjectsDirectory();
        File projectDirectory = new File(projectsDirectory, project.getName());
        File selectionsDirectory = new File(projectDirectory, "selections");
        File selectionDirectory = new File(selectionsDirectory, selection.getName());
        File resultsDirectory = new File(selectionDirectory, "results");
        File rsufiResultDirectory = new File(resultsDirectory, rsufiResult.getName());
        File otherFilesDirectory = new File(rsufiResultDirectory, "others");
        try {
            this.saveRSufiResult(rsufiResultDirectory, rsufiResult);
            Collection toDeletes = CollectionUtils.subtract(rsufiResult.getOtherFiles(), othersFile);
            for (File toDelete : toDeletes) {
                FileUtils.deleteQuietly((File)toDelete);
            }
            for (File otherFile : othersFile) {
                if (otherFile.getAbsolutePath().startsWith(otherFilesDirectory.getAbsolutePath())) continue;
                if (otherFile.isDirectory()) {
                    FileUtils.copyDirectoryToDirectory((File)otherFile, (File)otherFilesDirectory);
                    continue;
                }
                FileUtils.copyFileToDirectory((File)otherFile, (File)otherFilesDirectory);
            }
            ArrayList<File> otherFiles = new ArrayList<File>();
            if (otherFilesDirectory.isDirectory()) {
                for (File file : otherFilesDirectory.listFiles()) {
                    otherFiles.add(file);
                }
            }
            rsufiResult.setOtherFiles(otherFiles);
            List<RSufiResult> results = selection.getRsufiResults();
            selection.setRsufiResults(results);
        }
        catch (IOException ex) {
            throw new CoserBusinessException("Can't edit result", ex);
        }
    }

    public void saveRSufiResult(File rsufiResultDirectory, RSufiResult rsufiResult) throws CoserBusinessException {
        FileOutputStream outputStream = null;
        try {
            File propertiesFile = new File(rsufiResultDirectory, "result.properties");
            Properties props = rsufiResult.toProperties();
            outputStream = new FileOutputStream(propertiesFile);
            props.store(outputStream, null);
            ((OutputStream)outputStream).close();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saving result properties file : " + propertiesFile));
            }
        }
        catch (IOException ex) {
            try {
                throw new CoserBusinessException("Can't save result", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    public void deleteRSufiResult(Project project, Selection selection, RSufiResult rsufiResult) throws CoserBusinessException {
        try {
            File projectsDirectory = this.config.getRSufiProjectsDirectory();
            File projectDirectory = new File(projectsDirectory, project.getName());
            File selectionsDirectory = new File(projectDirectory, "selections");
            File selectionDirectory = new File(selectionsDirectory, selection.getName());
            File resultsDirectory = new File(selectionDirectory, "results");
            File rsufiResultDirectory = new File(resultsDirectory, rsufiResult.getName());
            FileUtils.deleteDirectory((File)rsufiResultDirectory);
            List<RSufiResult> results = selection.getRsufiResults();
            results.remove(rsufiResult);
            selection.setRsufiResults(results);
            Object[] resultFiles = resultsDirectory.listFiles();
            if (ArrayUtils.isEmpty((Object[])resultFiles)) {
                resultsDirectory.delete();
            }
        }
        catch (IOException ex) {
            throw new CoserBusinessException("Can't delete directory", ex);
        }
    }

    protected void addHistoryCommandsToProperties(Properties props, List<Command> historyCommand, String propertyPrefix) throws CoserBusinessException {
        int commandIndex = 0;
        for (Command command : historyCommand) {
            String commandProperty = propertyPrefix + "." + commandIndex;
            String commandValue = this.convertCommandToLine(command);
            props.setProperty(commandProperty, commandValue);
            ++commandIndex;
        }
    }

    protected List<Command> getHistoryCommandsFromProperties(Properties props, final String propertyPrefix) throws CoserBusinessException {
        ArrayList<Command> historyCommand = new ArrayList<Command>();
        ArrayList<String> propertiesNames = new ArrayList<String>(props.stringPropertyNames());
        Collections.sort(propertiesNames, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int result = -1;
                if (o1.matches(Pattern.quote(propertyPrefix + ".") + "\\d+")) {
                    if (o2.matches(Pattern.quote(propertyPrefix + ".") + "\\d+")) {
                        int int1 = Integer.parseInt(o1.substring(propertyPrefix.length() + 1));
                        int int2 = Integer.parseInt(o2.substring(propertyPrefix.length() + 1));
                        result = int1 - int2;
                    } else {
                        result = o1.compareTo(o2);
                    }
                } else {
                    result = o1.compareTo(o2);
                }
                return result;
            }
        });
        for (String propertyName : propertiesNames) {
            if (!propertyName.startsWith(propertyPrefix + ".")) continue;
            String commandAsString = props.getProperty(propertyName);
            Command command = this.convertLineToCommand(commandAsString);
            historyCommand.add(command);
        }
        return historyCommand;
    }

    protected String convertCommandToLine(Command command) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(command.getCommandUUID());
        args.add(command.getClass().getSimpleName());
        args.add(command.getComment() == null ? "" : command.getComment());
        args.add(command.toStringRepresentation());
        String result = CoserUtils.convertBracketString(args);
        return result;
    }

    protected Command convertLineToCommand(String line) throws CoserBusinessException {
        Command result = null;
        List<String> lineDetail = CoserUtils.convertBracketToList(line);
        String commandUUID = lineDetail.get(0);
        String commandName = lineDetail.get(1);
        String commandComment = lineDetail.get(2);
        String commandArgs = lineDetail.get(3);
        String commandFQN = Command.class.getPackage().getName() + "." + commandName;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Make new instance of command : " + commandFQN));
        }
        try {
            result = (Command)Class.forName(commandFQN).newInstance();
            result.setCommandUUID(commandUUID);
            result.setComment(commandComment);
            result.fromStringRepresentation(commandArgs);
        }
        catch (Exception ex) {
            throw new CoserBusinessException("Can't init command intance", ex);
        }
        return result;
    }

    protected void addProjectContent(Project project, AbstractDataContainer container, CoserConstants.Category category, DataStorage content, boolean deletedContent) {
        switch (category) {
            case CATCH: {
                if (!deletedContent) {
                    container.setCatch(content);
                    break;
                }
                container.setDeletedCatch(content);
                break;
            }
            case HAUL: {
                if (!deletedContent) {
                    container.setHaul(content);
                    break;
                }
                container.setDeletedHaul(content);
                break;
            }
            case LENGTH: {
                if (!deletedContent) {
                    container.setLength(content);
                    break;
                }
                container.setDeletedLength(content);
                break;
            }
            case STRATA: {
                if (!deletedContent) {
                    container.setStrata(content);
                    break;
                }
                container.setDeletedStrata(content);
                break;
            }
            case REFTAX_SPECIES: {
                project.setRefTaxSpecies(content);
                break;
            }
            case TYPE_ESPECES: {
                project.setTypeEspeces(content);
            }
        }
    }

    protected DataStorage getProjectContent(Project project, AbstractDataContainer container, CoserConstants.Category category, boolean deletedContent) {
        DataStorage content = null;
        switch (category) {
            case CATCH: {
                if (!deletedContent) {
                    content = container.getCatch();
                    break;
                }
                content = container.getDeletedCatch();
                break;
            }
            case HAUL: {
                if (!deletedContent) {
                    content = container.getHaul();
                    break;
                }
                content = container.getDeletedHaul();
                break;
            }
            case LENGTH: {
                if (!deletedContent) {
                    content = container.getLength();
                    break;
                }
                content = container.getDeletedLength();
                break;
            }
            case STRATA: {
                content = !deletedContent ? container.getStrata() : container.getDeletedStrata();
            }
        }
        return content;
    }

    public void deleteData(Project project, Control control, CoserConstants.Category category, String index, String commandUUID) throws CoserBusinessException {
        DeleteLineCommand command = new DeleteLineCommand();
        command.setCategory(category);
        command.setLineNumber(index);
        command.setCommandUUID(commandUUID);
        this.commandService.doAction(command, project, control);
    }

    public void deleteData(Project project, Control control, CoserConstants.Category category, String index) throws CoserBusinessException {
        this.deleteData(project, control, category, index, null);
    }

    public boolean replaceFieldValue(Project project, CoserConstants.Category category, String headerName, String searchString, String replaceString, String[] data, boolean isRegex, String commandUUID) throws CoserBusinessException {
        boolean result = false;
        AbstractDataEntity beanData = null;
        switch (category) {
            case CATCH: {
                beanData = new Catch();
                break;
            }
            case HAUL: {
                beanData = new Haul();
                break;
            }
            case LENGTH: {
                beanData = new Length();
                break;
            }
            case STRATA: {
                beanData = new Strata();
            }
        }
        beanData.setData(data);
        try {
            String newValue;
            String fieldName = Introspector.decapitalize(headerName);
            String stringFieldProperty = fieldName + "AsString";
            String currentValue = (String)PropertyUtils.getProperty((Object)beanData, (String)stringFieldProperty);
            String escapeSearchString = searchString;
            if (!isRegex) {
                escapeSearchString = Pattern.quote(escapeSearchString);
            }
            if (!currentValue.equals(newValue = currentValue.replaceAll(escapeSearchString, replaceString))) {
                String lineNumber = data[0];
                ModifyFieldCommand command = new ModifyFieldCommand();
                command.setCommandUUID(commandUUID);
                command.setFieldName(headerName);
                command.setLineNumber(lineNumber);
                command.setCurrentValue(currentValue);
                command.setNewValue(newValue);
                command.setCategory(category);
                this.commandService.doAction(command, project, project.getControl());
                result = true;
            }
        }
        catch (Exception ex) {
            throw new CoserBusinessException("Can't replace inner field value", ex);
        }
        return result;
    }

    public void replaceData(Project project, Control control, CoserConstants.Category category, String[] data) throws CoserBusinessException {
        String lineNumber = data[0];
        int lineIndex = -1;
        AbstractDataEntity currentBeanData = null;
        AbstractDataEntity newBeanData = null;
        switch (category) {
            case CATCH: {
                currentBeanData = new Catch();
                newBeanData = new Catch();
                lineIndex = control.getCatch().indexOf(lineNumber);
                currentBeanData.setData(control.getCatch().get(lineIndex));
                break;
            }
            case HAUL: {
                currentBeanData = new Haul();
                newBeanData = new Haul();
                lineIndex = control.getHaul().indexOf(lineNumber);
                currentBeanData.setData(control.getHaul().get(lineIndex));
                break;
            }
            case LENGTH: {
                currentBeanData = new Length();
                newBeanData = new Length();
                lineIndex = control.getLength().indexOf(lineNumber);
                currentBeanData.setData(control.getLength().get(lineIndex));
                break;
            }
            case STRATA: {
                currentBeanData = new Strata();
                newBeanData = new Strata();
                lineIndex = control.getStrata().indexOf(lineNumber);
                currentBeanData.setData(control.getStrata().get(lineIndex));
            }
        }
        newBeanData.setData(data);
        String commandUUID = this.commandService.getUniqueCommandUUID();
        for (String propertyHeader : currentBeanData.getHeaders()) {
            String propertyName = Introspector.decapitalize(propertyHeader);
            String stringFieldProperty = propertyName + "AsString";
            try {
                String currentValue = (String)PropertyUtils.getProperty((Object)currentBeanData, (String)stringFieldProperty);
                String newValue = (String)PropertyUtils.getProperty((Object)newBeanData, (String)stringFieldProperty);
                if (currentValue.equals(newValue)) continue;
                ModifyFieldCommand command = new ModifyFieldCommand();
                command.setCommandUUID(commandUUID);
                command.setFieldName(propertyHeader);
                command.setLineNumber(lineNumber);
                command.setCurrentValue(currentValue);
                command.setNewValue(newValue);
                command.setCategory(category);
                this.commandService.doAction(command, project, control);
            }
            catch (Exception ex) {
                throw new CoserBusinessException("Can't get bean value", ex);
            }
        }
    }

    public Project loadControlDataToSelection(Project project, Selection selection) throws CoserBusinessException {
        Project newProject = this.loadControlData(project);
        this.copyControlDataToSelection(newProject, selection);
        return newProject;
    }

    public List<String> getProjectYears(Selection selection) {
        TreeSet<String> years = new TreeSet<String>();
        Iterator<String[]> itTuple = selection.getHaul().iterator(true);
        while (itTuple.hasNext()) {
            String[] tuple = itTuple.next();
            String year = tuple[2];
            years.add(year);
        }
        ArrayList<String> result = new ArrayList<String>(years);
        return result;
    }

    public List<String> filterDataYearsAndGetStrata(Project project, Selection selection, List<String> selectedYears) throws CoserBusinessException {
        List<String> currentSelectionYears = selection.getSelectedYears();
        if (currentSelectionYears == null || !currentSelectionYears.containsAll(selectedYears)) {
            project = this.loadControlDataToSelection(project, selection);
        }
        ArrayList<String> result = new ArrayList<String>();
        Iterator<String[]> itHaul = selection.getHaul().iterator(true);
        while (itHaul.hasNext()) {
            String[] tupleHaul = itHaul.next();
            String year = tupleHaul[2];
            if (!selectedYears.contains(year)) {
                itHaul.remove();
                continue;
            }
            String strates = tupleHaul[5];
            if (result.contains(strates)) continue;
            result.add(strates);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Haul data filtered by " + selectedYears));
        }
        Iterator<String[]> itCatch = selection.getCatch().iterator(true);
        while (itCatch.hasNext()) {
            String[] tupleCatch = itCatch.next();
            String year = tupleCatch[2];
            if (selectedYears.contains(year)) continue;
            itCatch.remove();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Catch data filtered by " + selectedYears));
        }
        Iterator<String[]> itLength = selection.getLength().iterator(true);
        while (itLength.hasNext()) {
            String[] tupleLength = itLength.next();
            String year = tupleLength[2];
            if (selectedYears.contains(year)) continue;
            itLength.remove();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Length data filtered by " + selectedYears));
        }
        selection.setSelectedYears(selectedYears);
        Collections.sort(result);
        return result;
    }

    public void filterDataStrata(Project project, Selection selection, List<String> selectedStrata) {
        String haul;
        String year;
        HashSet<String> existentYearsHauls = new HashSet<String>();
        Iterator<String[]> itStrata = selection.getStrata().iterator(true);
        while (itStrata.hasNext()) {
            String[] tupleStrata = itStrata.next();
            String stratum = tupleStrata[2];
            if (selectedStrata.contains(stratum)) continue;
            itStrata.remove();
        }
        Iterator<String[]> itHaul = selection.getHaul().iterator(true);
        while (itHaul.hasNext()) {
            String[] tupleHaul = itHaul.next();
            String stratum = tupleHaul[5];
            if (!selectedStrata.contains(stratum)) {
                itHaul.remove();
                continue;
            }
            year = tupleHaul[2];
            haul = tupleHaul[3];
            existentYearsHauls.add(year + ";" + haul);
        }
        Iterator<String[]> itCatch = selection.getCatch().iterator(true);
        while (itCatch.hasNext()) {
            String[] tupleCatch = itCatch.next();
            year = tupleCatch[2];
            haul = tupleCatch[3];
            if (existentYearsHauls.contains(year + ";" + haul)) continue;
            itCatch.remove();
        }
        Iterator<String[]> itLength = selection.getLength().iterator(true);
        while (itLength.hasNext()) {
            String[] tupleLength = itLength.next();
            String year2 = tupleLength[2];
            String haul2 = tupleLength[3];
            if (existentYearsHauls.contains(year2 + ";" + haul2)) continue;
            itLength.remove();
        }
        selection.setSelectedStrata(selectedStrata);
    }

    public Map<String, String> getProjectSpeciesTypes(Project project) {
        TreeMap<String, String> types = new TreeMap<String, String>();
        Iterator<String[]> itTuples = project.getTypeEspeces().iterator(true);
        while (itTuples.hasNext()) {
            String[] tuple = itTuples.next();
            String type = tuple[0];
            String comment = tuple[1];
            String numSysMin = tuple[2];
            String numSysMax = tuple[3];
            if (numSysMin.equals(numSysMax)) continue;
            types.put(type, comment);
        }
        return types;
    }

    public void filterDataSpecies(Project project, Selection selection, List<String> selectedSpecies) {
        Iterator<String[]> itCatch = selection.getCatch().iterator(true);
        while (itCatch.hasNext()) {
            String[] tupleCatch = itCatch.next();
            String species = tupleCatch[4];
            if (selectedSpecies.contains(species)) continue;
            itCatch.remove();
        }
        Iterator<String[]> itLength = selection.getLength().iterator(true);
        while (itLength.hasNext()) {
            String[] tupleLength = itLength.next();
            String species = tupleLength[4];
            if (selectedSpecies.contains(species)) continue;
            itLength.remove();
        }
        selection.setSelectedSpecies(selectedSpecies);
    }

    public Collection<String> getSpeciesWithSizeAllYears(Selection selection) {
        TreeSet<String> years = new TreeSet<String>();
        Iterator<String[]> itTuple = selection.getHaul().iterator(true);
        while (itTuple.hasNext()) {
            String[] tuple = itTuple.next();
            String year = tuple[2];
            years.add(year);
        }
        HashMap<String, HashSet<String>> yearsForSpecies = new HashMap<String, HashSet<String>>();
        Iterator<String[]> itLength = selection.getLength().iterator(true);
        while (itLength.hasNext()) {
            String[] tupleLength = itLength.next();
            String species = tupleLength[4];
            String annee = tupleLength[2];
            HashSet<String> speciesYears = (HashSet<String>)yearsForSpecies.get(species);
            if (speciesYears == null) {
                speciesYears = new HashSet<String>();
                yearsForSpecies.put(species, speciesYears);
            }
            speciesYears.add(annee);
        }
        ArrayList<String> completeSpecies = new ArrayList<String>();
        for (Map.Entry yearForSpeciesEntry : yearsForSpecies.entrySet()) {
            if (!((Set)yearForSpeciesEntry.getValue()).equals(years)) continue;
            completeSpecies.add((String)yearForSpeciesEntry.getKey());
        }
        return completeSpecies;
    }

    public Collection<String> getSpeciesWithMaturity(Selection selection) {
        HashSet<String> speciesWithMaturity = new HashSet<String>();
        Iterator<String[]> itLength = selection.getLength().iterator(true);
        while (itLength.hasNext()) {
            String[] tupleLength = itLength.next();
            String species = tupleLength[4];
            String maturity = tupleLength[6];
            if (!"m".equalsIgnoreCase(maturity)) continue;
            speciesWithMaturity.add(species);
        }
        return speciesWithMaturity;
    }

    public List<String> getProjectSpecies(AbstractDataContainer container, Project project, Collection<String> filterSpecyType) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator<String[]> itCatch = container.getCatch().iterator(true);
        while (itCatch.hasNext()) {
            String[] tuple = itCatch.next();
            String species = tuple[4];
            if (result.contains(species)) continue;
            result.add(species);
        }
        if (project != null && filterSpecyType != null) {
            HashMap<String, Integer> speciesNumSys = new HashMap<String, Integer>();
            Iterator<String[]> refTaxIterator = project.getRefTaxSpecies().iterator(true);
            while (refTaxIterator.hasNext()) {
                String[] tuple = refTaxIterator.next();
                Integer iNumSys = Integer.valueOf(tuple[1]);
                String specyId = null;
                switch (project.getStorageSpeciesType()) {
                    case C_PERM: {
                        specyId = tuple[0];
                        break;
                    }
                    case C_Valide: {
                        specyId = tuple[3];
                        break;
                    }
                    case L_Valide: {
                        specyId = tuple[4];
                    }
                }
                speciesNumSys.put(specyId, iNumSys);
            }
            HashMap<String, Integer[]> mapType = new HashMap<String, Integer[]>();
            Iterator<String[]> itTypeSpecies = project.getTypeEspeces().iterator(true);
            while (itTypeSpecies.hasNext()) {
                String[] tuple = itTypeSpecies.next();
                String specyType = tuple[0];
                if (filterSpecyType == null || !filterSpecyType.contains(specyType)) continue;
                Integer iMinNumSys = Integer.valueOf(tuple[2]);
                Integer iMaxNumSys = Integer.valueOf(tuple[3]);
                mapType.put(specyType, new Integer[]{iMinNumSys, iMaxNumSys});
            }
            Iterator itSpecies = result.iterator();
            while (itSpecies.hasNext()) {
                String specy = (String)itSpecies.next();
                Integer specyNumSys = (Integer)speciesNumSys.get(specy);
                if (specyNumSys == null) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Can't find specy " + specy + " in reftax"));
                    }
                    itSpecies.remove();
                    continue;
                }
                boolean foundInFilter = false;
                for (Integer[] bornes : mapType.values()) {
                    if (specyNumSys < bornes[0] || specyNumSys > bornes[1]) continue;
                    foundInFilter = true;
                }
                if (foundInFilter) continue;
                itSpecies.remove();
            }
        }
        Collections.sort(result);
        return result;
    }

    public boolean isSpeciesNameExist(Project project, String newSpeciesName) {
        boolean result = false;
        Iterator<String[]> itTuple = project.getRefTaxSpecies().iterator(true);
        while (itTuple.hasNext() && !result) {
            String[] tuple = itTuple.next();
            String specyCode = null;
            switch (project.getStorageSpeciesType()) {
                case C_PERM: {
                    specyCode = tuple[0];
                    break;
                }
                case C_Valide: {
                    specyCode = tuple[3];
                    break;
                }
                case L_Valide: {
                    specyCode = tuple[4];
                }
            }
            if (!specyCode.equals(newSpeciesName)) continue;
            result = true;
        }
        return result;
    }

    public Project mergeSpecies(Project project, Selection selection, String newSpeciesName, String comment, String ... speciesNames) throws CoserBusinessException {
        if (!this.isSpeciesNameExist(project, newSpeciesName)) {
            throw new CoserBusinessException(I18n.t((String)"Species %s doesn't exist in referential", (Object[])new Object[]{project.getDisplaySpeciesText(newSpeciesName)}));
        }
        List<String> selectionSpecies = this.getProjectSpecies(selection, project, null);
        if (selectionSpecies.contains(newSpeciesName) && !ArrayUtils.contains((Object[])speciesNames, (Object)newSpeciesName)) {
            throw new CoserBusinessException(I18n.t((String)"Species %s already exists in current selection", (Object[])new Object[]{project.getDisplaySpeciesText(newSpeciesName)}));
        }
        MergeSpeciesCommand command = new MergeSpeciesCommand();
        command.setNewSpecyName(newSpeciesName);
        command.setSpeciesNames(speciesNames);
        command.setComment(comment);
        this.commandService.doAction(command, project, selection);
        return project;
    }

    public MatrixND getSamplingEffort(Project project, Selection selection) {
        HashMap dynMatrix = new HashMap();
        HashSet<String> lineNames = new HashSet<String>();
        HashSet<String> columns = new HashSet<String>();
        Iterator<String[]> itData = selection.getHaul().iterator(true);
        while (itData.hasNext()) {
            String[] tuple = itData.next();
            String year = tuple[2];
            String strata = tuple[5];
            lineNames.add(strata);
            columns.add(year);
            HashMap<String, Double> haulCountForStrata = (HashMap<String, Double>)dynMatrix.get(strata);
            if (haulCountForStrata == null) {
                haulCountForStrata = new HashMap<String, Double>();
                haulCountForStrata.put(year, 1.0);
                dynMatrix.put(strata, haulCountForStrata);
                continue;
            }
            Double haulCountForYear = (Double)haulCountForStrata.get(year);
            if (haulCountForYear == null) {
                haulCountForStrata.put(year, 1.0);
                continue;
            }
            Double d = haulCountForYear;
            Double d2 = haulCountForYear = Double.valueOf(haulCountForYear + 1.0);
            haulCountForStrata.put(year, haulCountForYear);
        }
        ArrayList lineNames2 = new ArrayList(lineNames);
        ArrayList columnsNames2 = new ArrayList(columns);
        MatrixND matrix = null;
        if (!lineNames2.isEmpty() && !columnsNames2.isEmpty()) {
            Collections.sort(lineNames2);
            Collections.sort(columnsNames2);
            matrix = MatrixFactory.getInstance().create(I18n.n((String)"coser.business.matrix.samplingeffort", (Object[])new Object[0]), new List[]{lineNames2, columnsNames2});
            for (Map.Entry dynMatrixEntry : dynMatrix.entrySet()) {
                for (Map.Entry haulCountForYearEntry : ((Map)dynMatrixEntry.getValue()).entrySet()) {
                    matrix.setValue(dynMatrixEntry.getKey(), haulCountForYearEntry.getKey(), ((Double)haulCountForYearEntry.getValue()).doubleValue());
                }
            }
        }
        return matrix;
    }

    public MatrixND getOccurrence(Project project, Selection selection) {
        HashMap dynMatrix = new HashMap();
        HashSet<String> lineNames = new HashSet<String>();
        HashSet<String> columns = new HashSet<String>();
        HashMap traitsCountPerYear = new HashMap();
        Iterator<String[]> itData = selection.getCatch().iterator(true);
        while (itData.hasNext()) {
            String[] tuple = itData.next();
            String year = tuple[2];
            String haul = tuple[3];
            String species = tuple[4];
            lineNames.add(species);
            columns.add(year);
            Set traitCountPerYear = (Set)traitsCountPerYear.get(year);
            if (traitCountPerYear == null) {
                HashSet<String> hauls = new HashSet<String>();
                hauls.add(haul);
                traitsCountPerYear.put(year, hauls);
            } else {
                traitCountPerYear.add(haul);
            }
            HashMap haulCountForStrata = (HashMap)dynMatrix.get(species);
            if (haulCountForStrata == null) {
                haulCountForStrata = new HashMap();
                HashSet<String> hauls = new HashSet<String>();
                hauls.add(haul);
                haulCountForStrata.put(year, hauls);
                dynMatrix.put(species, haulCountForStrata);
                continue;
            }
            Set traitCountPerYear2 = (Set)haulCountForStrata.get(year);
            if (traitCountPerYear2 == null) {
                HashSet<String> hauls = new HashSet<String>();
                hauls.add(haul);
                haulCountForStrata.put(year, hauls);
                continue;
            }
            traitCountPerYear2.add(haul);
        }
        ArrayList lineNames2 = new ArrayList(lineNames);
        Collections.sort(lineNames2);
        ArrayList columnsNames2 = new ArrayList(columns);
        Collections.sort(columnsNames2);
        MatrixND matrix = MatrixFactory.getInstance().create(I18n.n((String)"coser.business.matrix.occurrence", (Object[])new Object[0]), new List[]{lineNames2, columnsNames2});
        for (Map.Entry dynMatrixEntry : dynMatrix.entrySet()) {
            for (Map.Entry haulCountForYearEntry : ((Map)dynMatrixEntry.getValue()).entrySet()) {
                double occurence = (double)((Set)haulCountForYearEntry.getValue()).size() / (double)((Set)traitsCountPerYear.get(haulCountForYearEntry.getKey())).size();
                occurence = MathUtils.round((double)(occurence * 100.0), (int)2);
                matrix.setValue(dynMatrixEntry.getKey(), haulCountForYearEntry.getKey(), occurence);
            }
        }
        return matrix;
    }

    public MatrixND getDensity(Project project, Selection selection) {
        HashMap densityPerSpecyStrataYear = new HashMap();
        HashSet<String> speciesList = new HashSet<String>();
        HashSet<String> yearsList = new HashSet<String>();
        HashMap<String, Double> startaAndSurface = new HashMap<String, Double>();
        double totalSourface = 0.0;
        Iterator<String[]> itStrata = selection.getStrata().iterator(true);
        while (itStrata.hasNext()) {
            String[] tuple = itStrata.next();
            String stataName = tuple[2];
            String stringSurface = tuple[3];
            try {
                Double surface = Double.valueOf(stringSurface);
                totalSourface += surface.doubleValue();
                startaAndSurface.put(stataName, surface);
            }
            catch (NumberFormatException ex) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Can't convert surface '" + stringSurface + "' as double"));
            }
        }
        HashMap<String, String> haulAndStratas = new HashMap<String, String>();
        HashMap<String, Double> haulAndSweptSurface = new HashMap<String, Double>();
        Iterator<String[]> itHaul = selection.getHaul().iterator(true);
        while (itHaul.hasNext()) {
            String[] tuple = itHaul.next();
            String haul = tuple[3];
            String haulKey = tuple[2] + ";" + haul;
            String strataName = tuple[5];
            haulAndStratas.put(haul, strataName);
            String sweptSurfaceAsString = tuple[6];
            try {
                Double sweptSurface = Double.valueOf(sweptSurfaceAsString);
                haulAndSweptSurface.put(haulKey, sweptSurface);
            }
            catch (NumberFormatException ex) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Can't convert swept surface '" + sweptSurfaceAsString + "' as double"));
            }
        }
        HashMap<String, Double> surfacesParStrates = new HashMap<String, Double>();
        Iterator<String[]> itData = selection.getCatch().iterator(true);
        while (itData.hasNext()) {
            String[] tuple = itData.next();
            String species = tuple[4];
            String year = tuple[2];
            String haul = tuple[3];
            String numberAsString = tuple[5];
            String strata = (String)haulAndStratas.get(haul);
            speciesList.add(species);
            yearsList.add(year);
            try {
                HashSet<Double> densities;
                HashMap strataDensityPerYear;
                Double number = Double.valueOf(numberAsString);
                Double sweptSurface = (Double)haulAndSweptSurface.get(year + ";" + haul);
                Double density = null;
                if (sweptSurface == null) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Can't find swept surface for " + year + ";" + haul));
                    }
                    density = 0.0;
                } else {
                    density = number / sweptSurface;
                }
                HashMap specyDensityPerStrataYear = (HashMap)densityPerSpecyStrataYear.get(species);
                if (specyDensityPerStrataYear == null) {
                    specyDensityPerStrataYear = new HashMap();
                    strataDensityPerYear = new HashMap();
                    densities = new HashSet<Double>();
                    densities.add(density);
                    strataDensityPerYear.put(strata, densities);
                    specyDensityPerStrataYear.put(year, strataDensityPerYear);
                    densityPerSpecyStrataYear.put(species, specyDensityPerStrataYear);
                } else {
                    strataDensityPerYear = (HashMap)specyDensityPerStrataYear.get(year);
                    if (strataDensityPerYear == null) {
                        strataDensityPerYear = new HashMap();
                        densities = new HashSet();
                        densities.add(density);
                        strataDensityPerYear.put(strata, densities);
                        specyDensityPerStrataYear.put(year, strataDensityPerYear);
                    } else {
                        HashSet<Double> specyYearDensity = (HashSet<Double>)strataDensityPerYear.get(strata);
                        if (specyYearDensity == null) {
                            specyYearDensity = new HashSet<Double>();
                            specyYearDensity.add(density);
                            strataDensityPerYear.put(strata, specyYearDensity);
                        } else {
                            specyYearDensity.add(density);
                        }
                    }
                }
                Double surface = (Double)startaAndSurface.get(strata);
                surfacesParStrates.put(species + ";" + year + ";" + strata, surface);
            }
            catch (NumberFormatException ex) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Can't convert number '" + numberAsString + "' as double"));
            }
        }
        ArrayList sortedSpecies = new ArrayList(speciesList);
        Collections.sort(sortedSpecies);
        ArrayList sortedYears = new ArrayList(yearsList);
        Collections.sort(sortedYears);
        MatrixND matrix = MatrixFactory.getInstance().create(I18n.n((String)"coser.business.matrix.density", (Object[])new Object[0]), new List[]{sortedSpecies, sortedYears});
        for (Map.Entry dynMatrixEntry : densityPerSpecyStrataYear.entrySet()) {
            String specy = (String)dynMatrixEntry.getKey();
            for (Map.Entry haulCountForYearEntry : ((Map)dynMatrixEntry.getValue()).entrySet()) {
                String year = (String)haulCountForYearEntry.getKey();
                double totalNombreparstrate = 0.0;
                for (Map.Entry densityForYear : ((Map)haulCountForYearEntry.getValue()).entrySet()) {
                    double totalDensity = 0.0;
                    double densityCount = 0.0;
                    for (Double singleDensity : (Set)densityForYear.getValue()) {
                        totalDensity += singleDensity.doubleValue();
                        densityCount += 1.0;
                    }
                    double meanDensity = totalDensity / densityCount;
                    String strata = (String)densityForYear.getKey();
                    Double surfaceparstrate = (Double)surfacesParStrates.get(specy + ";" + year + ";" + strata);
                    if (surfaceparstrate == null) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)("no surface for " + specy + ";" + year + ";" + strata));
                        }
                        surfaceparstrate = 0.0;
                    }
                    double nombreparstrate = surfaceparstrate * meanDensity;
                    totalNombreparstrate += nombreparstrate;
                }
                double densiteparannee = totalNombreparstrate / totalSourface;
                matrix.setValue((Object)specy, (Object)year, densiteparannee);
            }
        }
        return matrix;
    }

    public MatrixND getLengthStructure(Project project, AbstractDataContainer dataContainer) {
        HashMap<String, String> haulAndStratas = new HashMap<String, String>();
        Iterator<String[]> itHaul = dataContainer.getHaul().iterator(true);
        while (itHaul.hasNext()) {
            String[] tuple = itHaul.next();
            String haul = tuple[3];
            String strataName = tuple[5];
            haulAndStratas.put(haul, strataName);
        }
        HashSet<Double> lengthSet = new HashSet<Double>();
        HashSet<String> speciesSet = new HashSet<String>();
        HashSet<String> strataSet = new HashSet<String>();
        HashSet<String> yearsSet = new HashSet<String>();
        Iterator<String[]> itData = dataContainer.getLength().iterator(true);
        while (itData.hasNext()) {
            String[] tuple = itData.next();
            String year = tuple[2];
            String haul = tuple[3];
            String species = tuple[4];
            String lengthAsString = tuple[7];
            String strata = (String)haulAndStratas.get(haul);
            if (strata == null) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("No strata for haul " + haul));
                continue;
            }
            String speciesText = project.getDisplaySpeciesText(species);
            speciesSet.add(speciesText);
            strataSet.add(strata);
            yearsSet.add(year);
            try {
                double length = Double.parseDouble(lengthAsString);
                length = this.getHalfStepValue(length);
                lengthSet.add(length);
            }
            catch (NumberFormatException ex) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Can't parse length as double : " + lengthAsString));
            }
        }
        ArrayList lengthSem = new ArrayList(lengthSet);
        Collections.sort(lengthSem);
        ArrayList speciesSem = new ArrayList(speciesSet);
        Collections.sort(speciesSem);
        ArrayList strataSem = new ArrayList(strataSet);
        Collections.sort(strataSem);
        ArrayList yearsSem = new ArrayList(yearsSet);
        Collections.sort(yearsSem);
        if (log.isDebugEnabled()) {
            log.debug((Object)I18n.t((String)"Creating matrix : %d*%d*%d*%d", (Object[])new Object[]{lengthSem.size(), speciesSem.size(), strataSem.size(), yearsSem.size()}));
        }
        MatrixProxy matrix = MatrixFactory.getInstance().createProxy(I18n.n((String)"coser.business.matrix.lengthstructure", (Object[])new Object[0]), new List[]{lengthSem, speciesSem, strataSem, yearsSem}, new String[]{I18n.n((String)"coser.business.common.length", (Object[])new Object[0]), I18n.n((String)"coser.business.common.species", (Object[])new Object[0]), I18n.n((String)"coser.business.common.strata", (Object[])new Object[0]), I18n.n((String)"coser.business.common.years", (Object[])new Object[0])}, (MatrixProvider)new LengthStructureMatrixProvider(project, dataContainer));
        return matrix;
    }

    public void fillLengthStructureMatrix(Project project, AbstractDataContainer dataContainer, MatrixND matrix) {
        HashMap<String, String> haulAndStratas = new HashMap<String, String>();
        Iterator<String[]> itHaul = dataContainer.getHaul().iterator(true);
        while (itHaul.hasNext()) {
            String[] tuple = itHaul.next();
            String haul = tuple[3];
            String strataName = tuple[5];
            haulAndStratas.put(haul, strataName);
        }
        DimensionHelper dimHelper = new DimensionHelper();
        Iterator<String[]> itData = dataContainer.getLength().iterator(true);
        while (itData.hasNext()) {
            String[] tuple = itData.next();
            String year = tuple[2];
            String haul = tuple[3];
            String species = tuple[4];
            String lengthAsString = tuple[7];
            String numberAsString = tuple[8];
            String strata = (String)haulAndStratas.get(haul);
            if (strata == null) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("No strata for haul " + haul));
                continue;
            }
            String speciesText = project.getDisplaySpeciesText(species);
            if (!matrix.getSemantic(1).contains(speciesText) || !matrix.getSemantic(2).contains(strata) || !matrix.getSemantic(3).contains(year)) continue;
            try {
                double length = Double.parseDouble(lengthAsString);
                length = this.getHalfStepValue(length);
                if (!matrix.getSemantic(0).contains(length)) continue;
                try {
                    double number = Double.parseDouble(numberAsString);
                    double currentNumber = matrix.getValue(dimHelper.get((Object)length, (Object)speciesText, (Object)strata, (Object)year));
                    matrix.setValue(dimHelper.get((Object)length, (Object)speciesText, (Object)strata, (Object)year), currentNumber += number);
                }
                catch (NumberFormatException ex) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)("Can't parse number as double : " + numberAsString));
                }
            }
            catch (NumberFormatException ex) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Can't parse length as double : " + lengthAsString));
            }
        }
    }

    protected double getHalfStepValue(double value) {
        double round;
        double floor = Math.floor(value);
        value = floor == (round = Math.floor(value + 0.5)) ? floor : floor + 0.5;
        return value;
    }

    public File extractRSUfiData(Project project, Selection selection, File directory, boolean onlyDataTable) throws CoserBusinessException {
        File exportDirectory = new File(directory, "RSUFI_DATA_" + project.getName());
        exportDirectory.mkdirs();
        for (CoserConstants.Category category : CoserConstants.Category.values()) {
            if (!category.isDataCategory()) continue;
            String storageFileName = this.commonService.getDataStorageFileName(project, category, null);
            File dataFile = new File(exportDirectory, storageFileName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saving selection file : " + dataFile));
            }
            DataStorage content = this.getProjectContent(project, selection, category, false);
            LinkedHashMap<String, String> reftaxSpecies = this.getReftaxSpeciesDisplayFieldMap(project, true);
            this.commonService.storeDataWhithoutQuote(content, dataFile, reftaxSpecies, category);
        }
        if (!onlyDataTable) {
            File listSpeciesFile = new File(exportDirectory, "ListEspeces" + project.getName() + ".txt");
            this.fillListSpeciesFile(selection, listSpeciesFile);
            File informationFile = new File(exportDirectory, "project.txt");
            PrintStream out = null;
            try {
                out = new PrintStream(new BufferedOutputStream(new FileOutputStream(informationFile)));
                out.println(I18n.t((String)"coser.business.extract.projectName", (Object[])new Object[0]) + project.getName());
                out.println(I18n.t((String)"coser.business.extract.projectAuthor", (Object[])new Object[0]) + project.getAuthor());
                out.println(I18n.t((String)"coser.business.extract.projectComment", (Object[])new Object[0]) + project.getComment());
                out.println(I18n.t((String)"coser.business.extract.selectionName", (Object[])new Object[0]) + selection.getName());
                DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 3, this.config.getLocale());
                out.println(I18n.t((String)"coser.business.extract.creationdate", (Object[])new Object[0]) + dateFormat.format(project.getCreationDate()));
                File projectsDirectory = this.config.getRSufiProjectsDirectory();
                File projectDirectory = new File(projectsDirectory, project.getName());
                File selectionsDirectory = new File(projectDirectory, "selections");
                File selectionDirectory = new File(selectionsDirectory, selection.getName());
                File otherFilesDirectory = new File(selectionDirectory, "others");
                if (otherFilesDirectory.isDirectory()) {
                    FileUtils.copyDirectoryToDirectory((File)otherFilesDirectory, (File)exportDirectory);
                }
                File reftaxFile = new File(projectDirectory, CoserConstants.Category.REFTAX_SPECIES.getStorageFileName());
                FileUtils.copyFileToDirectory((File)reftaxFile, (File)exportDirectory);
            }
            catch (IOException ex) {
                try {
                    throw new CoserBusinessException("Can't save project information file", ex);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
        return exportDirectory;
    }

    protected void fillListSpeciesFile(Selection selection, File ouputFile) throws CoserBusinessException {
        List<String> allSpecies = selection.getSelectedSpecies();
        List<String> occDensSpecies = selection.getSelectedSpeciesOccDens();
        List<String> sizeAllYearSpecies = selection.getSelectedSpeciesSizeAllYear();
        List<String> maturitySpecies = selection.getSelectedSpeciesMaturity();
        PrintStream out = null;
        try {
            out = new PrintStream(new BufferedOutputStream(new FileOutputStream(ouputFile)));
            out.println("Espece\tListAll\tListIdent\tListLong\tListMat");
            for (String species : allSpecies) {
                String listIdent = occDensSpecies.contains(species) ? "1" : "0";
                String listLong = sizeAllYearSpecies.contains(species) ? "1" : "0";
                String listMat = maturitySpecies.contains(species) ? "1" : "0";
                out.println(species + "\t1\t" + listIdent + "\t" + listLong + "\t" + listMat);
            }
        }
        catch (FileNotFoundException ex) {
            try {
                throw new CoserBusinessException("Can't extract rsufi files", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    public String getProjectSurveyName(File resultDirectory, RSufiResult rSufiResult) throws CoserBusinessException {
        String result = null;
        String estComIndName = rSufiResult.getEstComIndName();
        File estComIndFile = new File(resultDirectory, estComIndName);
        DataStorage dataStorage = this.commonService.loadCSVFile(estComIndFile, '\t');
        Iterator<String[]> itEstComIndData = dataStorage.iterator(true);
        while (StringUtils.isEmpty(result) && itEstComIndData.hasNext()) {
            result = itEstComIndData.next()[0];
        }
        return result;
    }

    public List<Coordinate> getStrataHaulCoordinate(Selection selection, Collection<String> strataCollection) throws CoserBusinessException {
        ArrayList<Coordinate> hauls = new ArrayList<Coordinate>();
        ArrayList<String> serieCache = new ArrayList<String>();
        Iterator<String[]> itData = selection.getHaul().iterator(true);
        while (itData.hasNext()) {
            String[] tuple = itData.next();
            String strata = tuple[5];
            if (!serieCache.contains(strata)) {
                serieCache.add(strata);
            }
            if (!strataCollection.contains(strata)) continue;
            String stratum = tuple[5];
            String year = tuple[2];
            String haul = tuple[3];
            String depth = tuple[9];
            String lat = tuple[7];
            String longi = tuple[8];
            double dlat = Double.parseDouble(lat);
            double dlong = Double.parseDouble(longi);
            String name = I18n.t((String)"coser.business.map.haulname", (Object[])new Object[]{stratum, year, haul, depth});
            int serieIndex = serieCache.indexOf(strata);
            Coordinate coordinate = new Coordinate(serieIndex, name, dlat, dlong);
            hauls.add(coordinate);
        }
        return hauls;
    }

    public SortedMap<String, List<String>> getSelectionByProject() {
        TreeMap<String, List<String>> selectionByProject = new TreeMap<String, List<String>>();
        File projectsDirectory = this.config.getRSufiProjectsDirectory();
        File[] projectFiles = projectsDirectory.listFiles();
        if (projectFiles != null) {
            for (File projectFile : projectFiles) {
                File selectionsDirectory;
                File[] selectionFiles;
                if (!projectFile.isDirectory() || (selectionFiles = (selectionsDirectory = new File(projectFile, "selections")).listFiles()) == null) continue;
                String projectName = projectFile.getName();
                for (File selectionFile : selectionFiles) {
                    if (!selectionFile.isDirectory()) continue;
                    ArrayList<String> selections = (ArrayList<String>)selectionByProject.get(projectName);
                    if (selections == null) {
                        selections = new ArrayList<String>();
                        selectionByProject.put(projectName, selections);
                    }
                    selections.add(selectionFile.getName());
                }
            }
        }
        return selectionByProject;
    }

    public Selection openSelection(String projectName, String selectionName) throws CoserBusinessException {
        File projectsDirectory = this.config.getRSufiProjectsDirectory();
        File projectDirectory = new File(projectsDirectory, projectName);
        if (!projectDirectory.isDirectory()) {
            throw new CoserBusinessException(I18n.t((String)"Project %s doesn't exists !", (Object[])new Object[]{projectName}));
        }
        File selectionsDirectory = new File(projectDirectory, "selections");
        File selectionDirectory = new File(selectionsDirectory, selectionName);
        if (!projectDirectory.isDirectory()) {
            throw new CoserBusinessException(I18n.t((String)"Selection %s doesn't exists !", (Object[])new Object[]{projectName}));
        }
        Selection selection = new Selection();
        selection.setName(selectionName);
        File selectionPropertiesFile = new File(selectionDirectory, selectionName + ".selection");
        FileInputStream inputStream = null;
        try {
            Properties props = new Properties();
            inputStream = new FileInputStream(selectionPropertiesFile);
            props.load(inputStream);
            selection.fromProperties(props);
            List<Command> commands = this.getHistoryCommandsFromProperties(props, "selection.commands");
            selection.setHistoryCommands(commands);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Read selection properties file : " + selectionPropertiesFile));
            }
        }
        catch (IOException ex) {
            try {
                throw new CoserBusinessException("Can't read selection properties file", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return selection;
    }

    public void fillListsSelection(Selection selection, List<String> selectedSpeciesOccDens, List<String> selectedSpeciesSizeAllYear, List<String> selectedSpeciesMaturity) {
        List<String> allSpecies = selection.getSelectedSpecies();
        List localSpeciesOccDens = ListUtils.retainAll(selectedSpeciesOccDens, allSpecies);
        List localSpeciesSizeAllYear = ListUtils.retainAll(selectedSpeciesSizeAllYear, allSpecies);
        List localSpeciesMaturity = ListUtils.retainAll(selectedSpeciesMaturity, allSpecies);
        selection.setSelectedSpeciesOccDens(localSpeciesOccDens);
        selection.setSelectedSpeciesSizeAllYear(localSpeciesSizeAllYear);
        selection.setSelectedSpeciesMaturity(localSpeciesMaturity);
    }

    public LinkedHashMap<String, String> getReftaxSpeciesDisplayFieldMap(Project project, boolean outputField) {
        HashMap<String, String> speciesMap = new HashMap<String, String>();
        Iterator<String[]> itData = project.getRefTaxSpecies().iterator(true);
        while (itData.hasNext()) {
            String[] tuple = itData.next();
            String key = null;
            String value = null;
            switch (project.getStorageSpeciesType()) {
                case C_Valide: {
                    key = tuple[3];
                    break;
                }
                case C_PERM: {
                    key = tuple[0];
                    break;
                }
                case L_Valide: {
                    key = tuple[4];
                }
            }
            SpeciesFieldType valueField = outputField ? project.getOutputSpeciesType() : project.getDisplaySpeciesType();
            switch (valueField) {
                case C_Valide: {
                    value = tuple[3];
                    break;
                }
                case C_PERM: {
                    value = tuple[0];
                    break;
                }
                case L_Valide: {
                    value = tuple[4];
                }
            }
            speciesMap.put(key, value);
        }
        return CoserUtils.sortByValue(speciesMap);
    }

    public void editSelectionOptions(Project project, Selection selection, List<File> othersFile) throws CoserBusinessException {
        File projectsDirectory = this.config.getRSufiProjectsDirectory();
        File projectDirectory = new File(projectsDirectory, project.getName());
        File selectionsDirectory = new File(projectDirectory, "selections");
        File selectionDirectory = new File(selectionsDirectory, selection.getName());
        File otherFilesDirectory = new File(selectionDirectory, "others");
        try {
            this.saveProjectSelection(project, selection);
            Collection toDeletes = CollectionUtils.subtract(selection.getOtherFiles(), othersFile);
            for (File toDelete : toDeletes) {
                FileUtils.deleteQuietly((File)toDelete);
            }
            for (File otherFile : othersFile) {
                if (otherFile.getAbsolutePath().startsWith(otherFilesDirectory.getAbsolutePath())) continue;
                if (otherFile.isDirectory()) {
                    FileUtils.copyDirectoryToDirectory((File)otherFile, (File)otherFilesDirectory);
                    continue;
                }
                FileUtils.copyFileToDirectory((File)otherFile, (File)otherFilesDirectory);
            }
            ArrayList<File> otherFiles = new ArrayList<File>();
            if (otherFilesDirectory.isDirectory()) {
                for (File file : otherFilesDirectory.listFiles()) {
                    otherFiles.add(file);
                }
            }
            selection.setOtherFiles(otherFiles);
        }
        catch (IOException ex) {
            throw new CoserBusinessException("Can't edit result", ex);
        }
    }

    class LengthStructureMatrixProvider
    implements MatrixProvider {
        protected Project project;
        protected AbstractDataContainer container;

        public LengthStructureMatrixProvider(Project project, AbstractDataContainer container) {
            this.project = project;
            this.container = container;
        }

        public void fillValues(MatrixND matrix) {
            ProjectService.this.fillLengthStructureMatrix(this.project, this.container, matrix);
        }
    }
}

