/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.result.repository.legacy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.coser.CoserConstants;
import fr.ifremer.coser.bean.EchoBaseProject;
import fr.ifremer.coser.bean.RSufiResultPath;
import fr.ifremer.coser.bean.SpeciesListMap;
import fr.ifremer.coser.bean.SpeciesMap;
import fr.ifremer.coser.result.repository.ResultRepository;
import fr.ifremer.coser.result.repository.legacy.LegacyResultRepositoryType;
import fr.ifremer.coser.result.request.CoserRequestExtractTypeListAware;
import fr.ifremer.coser.result.request.CoserRequestFacadeAware;
import fr.ifremer.coser.result.request.CoserRequestRepositoryResultTypeAware;
import fr.ifremer.coser.result.request.CoserRequestRepositoryTypeAware;
import fr.ifremer.coser.result.request.CoserRequestZoneAware;
import fr.ifremer.coser.result.request.CoserRequestZoneListAware;
import fr.ifremer.coser.storage.DataStorage;
import fr.ifremer.coser.storage.DataStorages;
import fr.ifremer.coser.util.DataType;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LegacyResultRepository
implements ResultRepository {
    private static final Log log = LogFactory.getLog(LegacyResultRepository.class);
    protected final File basedir;
    protected final File resultDirectory;
    protected final File mapsDirectory;
    protected final RSufiResultPath path;
    protected final Function<File, String> mapFileToSpeciesCode;
    protected final Function<String, String> speciesCodeToMapFile;
    protected final FilenameFilter mapSpeciesFilenameFilter;
    protected final String surveyName;
    protected SpeciesMap speciesMap;
    protected SpeciesListMap speciesListMap;
    protected final String id;

    public LegacyResultRepository(File basedir, RSufiResultPath path, String surveyName) {
        Preconditions.checkNotNull((Object)basedir);
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)surveyName);
        this.basedir = basedir;
        this.surveyName = surveyName;
        this.resultDirectory = FileUtils.getFile((File)basedir, (String[])new String[]{"selections", path.getSelection().getName(), "results", path.getRsufiResult().getName()});
        this.mapsDirectory = new File(this.resultDirectory, "maps");
        this.path = path;
        this.mapFileToSpeciesCode = EchoBaseProject.newMapFileToSpeciesCode(surveyName);
        this.speciesCodeToMapFile = EchoBaseProject.newSpeciesCodeToMapFileName(surveyName);
        this.mapSpeciesFilenameFilter = EchoBaseProject.newMapSpeciesFilenameFilter(surveyName);
        this.id = String.format("%s::%s", "rsufi", this.resultDirectory);
        if (log.isInfoEnabled()) {
            log.info((Object)("New result repository: " + this.id));
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public LegacyResultRepositoryType getResultRepositoryType() {
        return LegacyResultRepositoryType.INSTANCE;
    }

    @Override
    public String getSurveyName() {
        return this.surveyName;
    }

    @Override
    public File getBasedir() {
        return this.basedir;
    }

    @Override
    public String getProjectName() {
        return this.path.getProject().getName();
    }

    @Override
    public String getZone() {
        return this.path.getRsufiResult().getZone();
    }

    @Override
    public boolean isMapsResult() {
        return this.path.getRsufiResult().isMapsResult();
    }

    @Override
    public boolean isIndicatorsResult() {
        return this.path.getRsufiResult().isIndicatorsResult();
    }

    @Override
    public boolean isPubliableResult() {
        return this.path.getRsufiResult().isPubliableResult();
    }

    @Override
    public boolean isDataResult() {
        return this.path.getRsufiResult().isDataAllowed();
    }

    public File getResultDirectory() {
        return this.resultDirectory;
    }

    public RSufiResultPath getPath() {
        return this.path;
    }

    public String getSelectionName() {
        return this.path.getSelection().getName();
    }

    public String getResultName() {
        return this.path.getRsufiResult().getName();
    }

    public boolean matchFacade(CoserRequestFacadeAware request) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("No usage of facade in request: " + request));
        }
        return true;
    }

    public boolean matchZone(CoserRequestZoneAware request) {
        return this.getZone().equals(request.getZone());
    }

    public boolean matchZone(CoserRequestZoneListAware request) {
        List<String> zoneList = request.getZoneList();
        boolean result = zoneList.contains(this.getZone());
        return result;
    }

    public boolean matchRepositoryType(CoserRequestRepositoryTypeAware request) {
        boolean result = request.getRepositoryType().equals("rsufi");
        return result;
    }

    public boolean matchResultType(CoserRequestRepositoryResultTypeAware request) {
        boolean result;
        switch (request.getResultType()) {
            case MAP: {
                result = this.isMapsResult();
                break;
            }
            case INDICATOR: {
                result = this.isIndicatorsResult();
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public boolean matchExtractTypeList(CoserRequestExtractTypeListAware request) {
        boolean result = false;
        if (this.isMapsResult()) {
            result = request.getExtractTypeList().contains((Object)DataType.MAP);
        } else if (this.isIndicatorsResult()) {
            boolean bl = result = request.getExtractTypeList().contains((Object)DataType.POPULATION) || request.getExtractTypeList().contains((Object)DataType.COMMUNITY);
        }
        if (!result && this.isDataResult()) {
            result = request.getExtractTypeList().contains((Object)DataType.SOURCE);
        }
        return result;
    }

    public boolean matchCommunity(Predicate<String[]> predicate) {
        Preconditions.checkNotNull(predicate);
        DataStorage storage = this.getCommunityIndicatorStorage();
        boolean result = DataStorages.match(storage, predicate, true);
        return result;
    }

    public boolean matchPopulation(Predicate<String[]> predicate) {
        Preconditions.checkNotNull(predicate);
        DataStorage storage = this.getPopulationIndicatorStorage();
        boolean result = DataStorages.match(storage, predicate, true);
        return result;
    }

    public File getMapSpeciesFile(String species) {
        String fileName = (String)this.speciesCodeToMapFile.apply((Object)species);
        File file = fileName == null ? null : new File(this.mapsDirectory, fileName);
        return file;
    }

    public Map<String, String> getMapSpeciesMap() {
        HashSet speciesList = Sets.newHashSet();
        Object[] files = this.mapsDirectory.listFiles(this.mapSpeciesFilenameFilter);
        if (files != null) {
            List transform = Lists.transform((List)Lists.newArrayList((Object[])files), this.mapFileToSpeciesCode);
            speciesList.addAll(transform);
        }
        Map<String, String> result = this.getSpeciesMap().getSpeciesSubMap(speciesList);
        return result;
    }

    public SpeciesListMap getSpeciesListMap() {
        if (this.speciesListMap == null) {
            File file = new File(this.basedir, CoserConstants.Category.TYPE_ESPECES.getStorageFileName());
            this.speciesListMap = new SpeciesListMap(file);
        }
        return this.speciesListMap;
    }

    public SpeciesMap getSpeciesMap() {
        if (this.speciesMap == null) {
            File file = new File(this.basedir, CoserConstants.Category.REFTAX_SPECIES.getStorageFileName());
            this.speciesMap = new SpeciesMap(file);
        }
        return this.speciesMap;
    }

    public DataStorage getPopulationIndicatorStorage() {
        File file = new File(this.resultDirectory, this.path.getRsufiResult().getEstPopIndName());
        DataStorage result = DataStorages.load(file, '\t');
        return result;
    }

    public DataStorage getCommunityIndicatorStorage() {
        File file = new File(this.resultDirectory, this.path.getRsufiResult().getEstComIndName());
        DataStorage result = DataStorages.load(file, '\t');
        return result;
    }
}

